# 23w51

## What's Changed
 - Upgrade pyav to 12.0.0
 - Sources are now directly linked in the v3 format.
 - Removed the `--source` and `--add` option
 - Switch from setup.py to pyproject.toml

Remember to upgrade setuptools! `pip install -U setuptools`

**Full Changelog**: https://github.com/WyattBlue/auto-editor/compare/23w46a...23w51a


# 23w43a

## What's Changed
 - Bump pyav from `11.0.1` to `11.2.0`
 - Bump Pillow from `10.0.1` to `10.1.0`
 - Palet: added `append class eval for-items list list?`, and fixed many bugs
 - Removed the ability to draw text and ellipse shapes.

**Full Changelog**: https://github.com/WyattBlue/auto-editor/compare/23w40a...23w43a


# 23w38a

## What's Changed
 - Auto-Editor now knows all h264, hevc, av1, and prores encoders
 - Bump `pillow` from 10.0.0 to 10.0.1
 - Palet: Rename `string-append` to `&`, add `&=`
 - Palet: `/` will now return a float, unless all numbers are frac? or any number is complex.
 - Palet: Add keyword datatype, allow keyword parameters for `define`

**Full Changelog**: https://github.com/WyattBlue/auto-editor/compare/23w35a...23w38a


# 23w35a

## What's Changed
 - Removed support for Python 3.9, use 3.10 or 3.11
 - DaVinci Resolve: Use fcp10 format instead of fcp7
 - Palet: Add `incf` `decf` `case`
 - Palet: Add dot syntax and lang pragma

**Full Changelog**: https://github.com/WyattBlue/auto-editor/compare/23w32a...23w35a


# 23w32a

## What's Changed
 - Final Cut Pro XML: Fix desync issue / Use modern APIs
 - Palet: Add `hash-ref` `hash-set!` `hash-update!` `hash-remove!`
 - Palet: Fix `hash` incorrectly erroring when its arity is 0
 - Palet: `ref` no longer accepts hashes


# 23w31a

## What's Changed
 * ShotCut: support exporting multiple videos
 * Palet: Implement lexical scoping
 * Palet: Add `let` `let*` `system` `cond` `sleep` `error`
 * Palet: Improve variable error messages

**Full Changelog**: https://github.com/WyattBlue/auto-editor/compare/23w28a...23w31a


# 23w28a

## What's Changed
 - Fix ShotCut export producing wrong cuts
 - Translate README to Chinese by @flt6 in https://github.com/WyattBlue/auto-editor/pull/361
 - Add back `var-exists?` procedure, add `rename` and `delete` syntax
 - Info subcommand: remove `--include-vfr`
 - Bump pillow version to 10.0.0

## New Contributors
* @flt6 made their first contribution in https://github.com/WyattBlue/auto-editor/pull/361

**Full Changelog**: https://github.com/WyattBlue/auto-editor/compare/23w24a...23w28a


# 23w24a

## What's Changed
- Added the following procedures: `assert` `array-copy` `between/c` `div` `maxclip` `maxcut`
  - `maxcut` and `maxclip` were added to address #348
- Fix displaying vectors
- Updated `--audio-normalize ebu`'s contracts so they match the ranges for ffmpeg >=6

**Full Changelog**: https://github.com/WyattBlue/auto-editor/compare/23w21a...23w24a


# 23w21a

## What's Changed
 - wavfile: immediately return when data chunk is read (fixes #351)
 - fcp7: fix reading pathurl

**Full Changelog**: https://github.com/WyattBlue/auto-editor/compare/23w20b...23w21a


# 23w20b

## What's Changed
 - Work around DaVinci Resolve bug where timeline will break strangely if `<duration>` tag in `<file>` is not present even though the value is not used

**Full Changelog**: https://github.com/WyattBlue/auto-editor/compare/23w20a...23w20b


# 23w20a

## What's Changed
- fcp7 backend (Premiere and DaVinci Resolve)
  - You can now export multiple video files into one xml
  - The xml now respects the number of channels the audio has and no longer assumes it's always 2
- v3 timeline backend
  - the `"timeline"` key has been flatten and removed
  - `"version"` value has been changed `"unstable:3.0"` -> `"3"`
  - the `"dur"` attribute for all timeline objects is now always the "real" duration even if the speed is != 1. This makes many internal operations simpler and imitates how fcp7 represents timing.
 - v1 timeline importing and exporting is back
 - All v(NUMBER) timelines now no longer use or accept semantic versioning

**Full Changelog**: https://github.com/WyattBlue/auto-editor/compare/23w15a...23w20a


# 23w15a

## What's Changed
 - Only allow valid bitrate units  `k` `K` `M`
 - Handle previously unhandled exceptions when parsing certain options with invalid values
 - Pin pillow to `9.5.0`

**Full Changelog**: https://github.com/WyattBlue/auto-editor/compare/23w12a...23w15a


# 23w12a

## What's Changed
 * Support for DaVinci Resolve is now added back in. Added the `--export resolve` `-exr` and `--export-to-resolve`

**Full Changelog**: https://github.com/WyattBlue/auto-editor/compare/23w11a...23w12a


# 23w11a

## What's Changed
* Add new option `--audio-normalize` that can apply EBU R128 or Peak audio normalizing methods
* Change default video bitrate from 10m to 10M by @hunterhogan in https://github.com/WyattBlue/auto-editor/pull/337

## New Contributors
* @hunterhogan made their first contribution in https://github.com/WyattBlue/auto-editor/pull/337

**Full Changelog**: https://github.com/WyattBlue/auto-editor/compare/23w10c...23w11a


# 23w10c

## Breaking
- `--edit all` is now `--edit all/e`

## What's Changed
- **Bug Fix** Premiere can now find the source file in Premiere XMLs
- Levels subcommand
  - Levels now has start tag to ensure no dropped data
  - Levels can now use `none` and `all/e` edit methods

**Full Changelog**: https://github.com/WyattBlue/auto-editor/compare/23w08a...23w10c


# 23w08a

## What's Changed
- `auto-editor info` now displays the audio stream's channel count
- `--add` now uses palet for parsing instead of having a little parsing language for each attribute.
```shell
#  old way, adding special characters like newline and tab was terrible
auto-editor --add 'text:0,60,This is my text!
Wow,font=Arial'

#  new clean and explicit way
auto-editor --add 'text:0,60,"This is my text!\nWow",font="Arial"'
```
- The palet scripting language, and its [associated docs](https://auto-editor.com/ref/23w08a/palet), has been greatly improved. For a normal auto-editor, palet doesn't matter right now, but allow for new and exciting auto-editor functionally in the future.

**Full Changelog**: https://github.com/WyattBlue/auto-editor/compare/23w04a...23w08a


# 23w04a

## What's New

### New Features
 - Added `subtitle` edit method. `subtitle` analyzes subtitle streams and adds sections when any subtitle shown on screen matches the given regex pattern.
 - Added new attribute: `name` for the `premiere` and `final-cut-pro` export object.

### Breaking Changes
 - Removed `--min-clip` `--min-cut` cmd options. Use `minclip` and `mincut` procedures in the `--edit` option or the new `mincut` `minclip` attributes on the `audio` edit method: `--edit audio:mincut=4,minclip=3`
 - Removed `--show-ffmpeg-debug`. Instead use `--show-ffmpeg-commands` or `--show-ffmpeg-output`
 - Removed the `grep` subcommand. The new `subtitle` edit method does all of its functionality

### Palet
"Palet" is auto-editor's scripting language used in the `--edit` option and `repl` subcommand. It is similar to the racket language but has a few differences. Palet existed in earlier versions but it wasn't worth mentioning in the release notes until now.  The biggest change is that you can now define your own procedures:

```racket
(define circle-area (lambda (r) (* pi (* r r))))
(circle-area 5)
> 78.53981633974483

```


### Dependencies
 - Upgrade Pillow `9.3.0 -> 9.4.0`

**Full Changelog**: https://github.com/WyattBlue/auto-editor/compare/22w52a...23w04a

