if(NAME MATCHES "MSI")
	set(PACKAGES ON)
endif()

if(NAME MATCHES "GNU")
	set(GNU ON)
elseif(NAME MATCHES "clang" AND DEFINED ENV{LLVM})
	set(PATH "$ENV{LLVM}")
endif()

if(NOT GNU)
	set(VCVARS cmd /c vcvarsall.bat amd64 && call)
endif()

if(NAME MATCHES "_dev")
	set(PRESET ci-win-debug)
elseif(PACKAGES)
	set(PRESET ci-win-release)
else()
	set(PRESET ci-win)
endif()

step(${VCVARS} ${T_CFG} --preset ${PRESET} PATH "${PATH}")

if(PACKAGES)
	step(${VCVARS} ${T_TARGET} package)
	step(${VCVARS} ${T_TARGET} package.sign)
	if(NOT RELEASE)
		step(${CMAKE_COMMAND} -DCMD=CHECK_WIX_WARNING -DFILE=${T_BUILD_DIR}/_CPack_Packages/win64/WIX/wix.log -P ${CMAKE_DIR}/cmd.cmake)
	endif()
else()
	step(${VCVARS} ${T_BUILD})
endif()

if(NOT RELEASE AND NOT PACKAGES)
	step(${T_CTEST} ENV QT_PLUGIN_PATH=${WORKSPACE}/libs/dist/plugins QML2_IMPORT_PATH=${WORKSPACE}/libs/dist/qml PATH "${WORKSPACE}/libs/dist/bin")
endif()
