/*
 * This file was automatically generated by EvoSuite
 * Fri Jan 12 12:22:53 GMT 2018
 */

package uk.ac.sanger.artemis.components.genebuilder.cv;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.runtime.EvoAssertions.*;
import java.util.Date;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.components.genebuilder.cv.DatePanel;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, separateClassLoader = true, useJEE = true) 
public class DatePanel_ESTest extends DatePanel_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test00()  throws Throwable  {
      DatePanel datePanel0 = new DatePanel("b+mF88o.u&@Z7V", 2914);
      assertFalse(datePanel0.getIgnoreRepaint());
  }

  @Test(timeout = 4000)
  public void test01()  throws Throwable  {
      DatePanel datePanel0 = new DatePanel((String) null);
      // Undeclared exception!
      try { 
        datePanel0.getDate("yyyyMMdd");
        fail("Expecting exception: NumberFormatException");
      
      } catch(NumberFormatException e) {
         //
         // For input string: \"yyyy\"
         //
         verifyException("java.lang.NumberFormatException", e);
      }
  }

  @Test(timeout = 4000)
  public void test02()  throws Throwable  {
      DatePanel datePanel0 = null;
      try {
        datePanel0 = new DatePanel("lye<}&hs", 7);
        fail("Expecting exception: NumberFormatException");
      
      } catch(NumberFormatException e) {
         //
         // For input string: \"lye<\"
         //
         verifyException("java.lang.NumberFormatException", e);
      }
  }

  @Test(timeout = 4000)
  public void test03()  throws Throwable  {
      DatePanel datePanel0 = null;
      try {
        datePanel0 = new DatePanel("20140214", 2949);
        fail("Expecting exception: IllegalArgumentException");
      
      } catch(IllegalArgumentException e) {
         //
         // (start <= value <= end) is false
         //
         verifyException("javax.swing.SpinnerDateModel", e);
      }
  }

  @Test(timeout = 4000)
  public void test04()  throws Throwable  {
      DatePanel datePanel0 = null;
      try {
        datePanel0 = new DatePanel("_1sRpI&8");
        fail("Expecting exception: NumberFormatException");
      
      } catch(NumberFormatException e) {
         //
         // For input string: \"_1sR\"
         //
         verifyException("java.lang.NumberFormatException", e);
      }
  }

  @Test(timeout = 4000)
  public void test05()  throws Throwable  {
      DatePanel datePanel0 = new DatePanel("", (-2474));
      Date date0 = datePanel0.getDate("20140214");
      assertEquals("Fri Feb 14 20:21:21 GMT 2014", date0.toString());
  }

  @Test(timeout = 4000)
  public void test06()  throws Throwable  {
      DatePanel datePanel0 = new DatePanel("", (-2474));
      Date date0 = datePanel0.getDate("");
      assertNull(date0);
  }

  @Test(timeout = 4000)
  public void test07()  throws Throwable  {
      DatePanel datePanel0 = new DatePanel((String) null);
      Date date0 = datePanel0.getDate((String) null);
      assertNull(date0);
  }

  @Test(timeout = 4000)
  public void test08()  throws Throwable  {
      DatePanel datePanel0 = new DatePanel((String) null);
      Date date0 = datePanel0.getDate("?");
      assertNull(date0);
  }

  @Test(timeout = 4000)
  public void test09()  throws Throwable  {
      DatePanel datePanel0 = new DatePanel((String) null);
      // Undeclared exception!
      try { 
        datePanel0.setValue("");
        fail("Expecting exception: IllegalArgumentException");
      
      } catch(IllegalArgumentException e) {
         //
         // illegal value
         //
         verifyException("javax.swing.SpinnerDateModel", e);
      }
  }

  @Test(timeout = 4000)
  public void test10()  throws Throwable  {
      DatePanel datePanel0 = null;
      try {
        datePanel0 = new DatePanel("19700101");
        fail("Expecting exception: IllegalArgumentException");
      
      } catch(IllegalArgumentException e) {
         //
         // (start <= value <= end) is false
         //
         verifyException("javax.swing.SpinnerDateModel", e);
      }
  }

  @Test(timeout = 4000)
  public void test11()  throws Throwable  {
      String string0 = DatePanel.getDate();
      assertEquals("20140214", string0);
  }

  @Test(timeout = 4000)
  public void test12()  throws Throwable  {
      DatePanel datePanel0 = new DatePanel("", (-2474));
      String string0 = datePanel0.getText();
      assertEquals("", string0);
  }
}
