---
name: ANTs command line tools - bugs, unexpected results or other run time problems
about: Issues with *ANTs command line tools*. For ANTsPy, ANTsR, etc, please find the correct repository at the link below.
---

<!--
Text in these brackets are comments, and won't be visible when you submit your
issue. Please read before submitting.

Before opening an issue, please check the ANTs wiki and existing issues. The
ANTs Wiki is at:

https://github.com/ANTsX/ANTs/wiki

The main Github search bar can search issues and wikis simultaneously. Type 
search times and select "In this repository".

If you find related issues but still have questions, you can open a new issue
and reference them with #number. Eg, "This is similar to #1234, but my data..."
-->

**Describe the problem**
<!-- Brief description of the problem. -->


**To Reproduce**
<!--
Steps to reproduce the problem. The majority of issues with ANTs are specific to
the data, so uploading example data will make it much easier to provide help. If
it is impossible to share the data in question, attempting to reproduce the
problem with other public data is helpful.

Even if you can't share data, please include:

 * The exact command line as it was run. Please run all commands with
   verbose output where possible. If your command takes a long time, please try
   to produce a faster example that still shows the problem (eg, by running
   fewer iterations).

 * The full verbose output printed to the terminal when you run the command. If
   this is very long, please save in a text file and upload as an attachment.

If uploading data as an attachment, please try to minimize the file size by
compressing, downsampling or otherwise creating smaller images that demonstrate
the problem.
-->

**System information (please complete the following information)**
<!--
Many issues are specific to a particular system. Please include all information
about your computing environment.
-->

 - OS: [e.g. Mac OS]
 - OS version: [e.g. 10.15.1]
 - Type of system: [Desktop, laptop, HPC cluster, cloud instance,
   other]
<!--
   If you are building inside a virtual machine, container, Cygwin,
   Windows Subsystem for Linux, or other non-native environment, please
   let us know and include details of both the virtual Linux and the
   host OS.
-->

**ANTs version information**
 - ANTs code version: [output of antsRegistration --version]
 - ANTs installation type: [Compiled from source, downloaded binary
   (from where?), installed by another package (which?), installed in
   container (URL?), other (please specify)]

**Additional information**
<!--
Any other information that might help solve the problem. If you cannot share
data to reproduce the problem, relevant information (such as image headers
printed with PrintHeader) can help.
-->
