package main

import (
	"testing"
)

func TestDropAmbiguousPkgs(t *testing.T) {
	pkgs := []string{
		"bar",
		"bar",
		"baz",
		"baz:arm64",
		"foo",
		"foo",
		"foo:amd64",
		"foo:i386",
	}
	want := []string{
		"bar",
		"baz:arm64",
		"foo:amd64",
		"foo:i386",
	}
	got := uniqArchFreePkgs(pkgs)

	// TODO: use cmp.Diff instead.
	equal := len(got) == len(want)
	if equal {
		for i := range got {
			if got[i] != want[i] {
				equal = false
				break
			}
		}
	}

	if !equal {
		t.Errorf("dropAmbiguousPkgs(%#v) =\n     %#v\nwant %#v", pkgs, got, want)
	}
}
