; This file was initially generated automatically from legacy documentation
; strings.  See source files in this directory for copyright and license
; information.

(in-package "ACL2")

(include-book "xdoc/top" :dir :system)

(defxdoc cancel-floor-+
  :parents (floor-lemmas integer-ratio-lemmas)
  :short "Rewrite: (FLOOR (+ x y) z) = x/z + (FLOOR y z), when x/z is an integer;
also the commutative form."
  :long  "<p></p>
 
 
 <p>
 </p>")

(defxdoc cancel-floor-+-3
  :parents (floor-lemmas integer-ratio-lemmas)
  :short "Rewrite: (FLOOR (+ w x y) z) = y/z + (FLOOR (+ w x) z), when y/z is an
integer."
  :long  "<p></p>
 
 
 <p>
 </p>")

(defxdoc cancel-mod-+
  :parents (mod-lemmas integer-ratio-lemmas)
  :short "Rewrite: (MOD (+ x y) z) = (MOD y z), when x/z is an integer;
also the commutative form."
  :long  "<p></p>
 
 
 <p>
 </p>")

(defxdoc cancel-mod-+-3
  :parents (mod-lemmas integer-ratio-lemmas)
  :short "Rewrite: (MOD (+ w x y) z) = (MOD (+ w x) z), when y/z is an integer."
  :long  "<p></p>
 
 
 <p>
 </p>")

(defxdoc floor-+
  :parents (floor-lemmas)
  :short "Rewrite (D): (FLOOR (+ x y) z) =
(FLOOR x z) + (FLOOR y z) + (FLOOR (+ (MOD x z) (MOD y z)) z)."
  :long  "<p>
 As this rule could easily loop it is exported DISABLEd.  Don't ENABLE this
 lemma unless you are sure that the FLOOR/MOD term will simplify, or else
 put SYNTAXP guards on the variables x, y, and/or z.
 </p>
 
 
 <p>
 </p>")

(defxdoc floor-=-x/y
  :parents (floor-lemmas)
  :short "Rewrite: (FLOOR x y) = x/y, when x/y is an integer."
  :long  "<p>
 This rule is a corollary of a more general equality which is also stored as
 a :REWRITE and :GENERALIZE rule.
 </p>
 
 
 <p>
 </p>")

(defxdoc floor-as-truncate
  :parents (floor-lemmas)
  :short "Rewrite: Rewrite (FLOOR x y) to a function of (TRUNCATE x y)."
  :long  "<p></p>
 
 
 <p>
 </p>")

(defxdoc floor-bounds
  :parents (floor-lemmas)
  :short "Linear (D) : x/y - 1 &lt; (FLOOR x y) &lt;= x/y."
  :long  "<p>
 This lemma `defines' FLOOR as a set of inequalties.  Many of the properties
 of FLOOR will be derived from this theorem.  Unfortunately, this lemma is
 implicated in thrashing in the linear arithmetic procedure and must be
 DISABLEd at times.  This lemmas is stored as a :LINEAR rule for FLOOR
 exclusively since we consider it to be a property of FLOOR, and not a
 general property of (/ x y).
 </p>
 
 
 <p>
 </p>")

(defxdoc floor-cancel-*
  :parents (floor-lemmas)
  :short "Rewrite: (FLOOR (* x y) y) = (FLOOR x 1)."
  :long  "<p>
 NB: You get the commuted form as well.
 </p>
 
 
 <p>
 </p>")

(defxdoc floor-cancel-*-2
  :parents (floor-lemmas)
  :short "Rewrite: (FLOOR (* x y) (* x z)) = (FLOOR y z)."
  :long  "<p></p>
 
 
 <p>
 </p>")

(defxdoc floor-floor-integer
  :parents (floor-lemmas)
  :short "Rewrite: (FLOOR (FLOOR x i) j) = (FLOOR x (* i j)) for integers i,j &gt; 0."
  :long  "<p></p>
 
 
 <p>
 </p>")

(defxdoc floor-lemmas
  :parents (quotient-remainder-lemmas)
  :short "Lemmas about FLOOR."
  :long  "<p></p>
 
 
 <p>
 </p>")

(defxdoc floor-minus
  :parents (floor-lemmas)
  :short "Rewrite: (FLOOR (- x) y) = 
         (IF (INTEGERP (* x (/ y))) 
             (- (FLOOR x y)) 
           (- (- (FLOOR x y)) 1)));
         Rhs identical for -y."
  :long  "<p></p>
 
 
 <p>
 </p>")

(defxdoc floor-mod-elim
  :parents (floor-lemmas mod-lemmas)
  :short "Rewrite: (+ (MOD x y) (* y (FLOOR x y))) = x."
  :long  "<p>
 NB: This rule is also stored as an :ELIM rule.
 </p>
 
 
 <p>
 </p>")

(defxdoc floor-type-1
  :parents (floor-lemmas)
  :short "Decide (FLOOR x y) &lt; 0  based on inequalities of x and y."
  :long  "<p>
 This rule is available in various forms: :REWRITE, :LINEAR,
 :TYPE-PRESCRIPTION, and :GENERALIZE as appropriate.  Note that unless we
 can decide the inequalities of x and y the :LINEAR forms may thrash.
 </p>
 
 
 <p>
 </p>")

(defxdoc floor-type-2
  :parents (floor-lemmas)
  :short "Decide (FLOOR x y) &gt; 0  based on inequalities of x and y."
  :long  "<p>
 This rule is available in various forms: :REWRITE, :LINEAR,
 :TYPE-PRESCRIPTION, and :GENERALIZE as appropriate.  Note that unless we
 can decide the inequalities of x and y the :LINEAR forms may thrash.
 </p>
 
 
 <p>
 </p>")

(defxdoc floor-type-3
  :parents (floor-lemmas)
  :short "Decide (FLOOR x y) &gt; 0  based on inequalities of x and y."
  :long  "<p>
 This rule is available in various forms: :REWRITE, :LINEAR,
 :TYPE-PRESCRIPTION, and :GENERALIZE as appropriate.  Note that unless we
 can decide the inequalities of x and y the :LINEAR forms may thrash.
 </p>
 
 
 <p>
 </p>")

(defxdoc floor-type-4
  :parents (floor-lemmas)
  :short "Decide (FLOOR x y) = -1  based on inequalities of x and y."
  :long  "<p>
 This rule is available in various forms: :REWRITE, :LINEAR,
 :TYPE-PRESCRIPTION, and :GENERALIZE as appropriate.  Note that unless we
 can decide the inequalities of x and y the :LINEAR forms may thrash.
 </p>
 
 
 <p>
 </p>")

(defxdoc floor-type-linear
  :parents (floor-lemmas)
  :short "A theory of the :LINEAR rules created by the lemmas FLOOR-TYPE-1 and
FLOOR-TYPE-2."
  :long  "<p>
 These rules are implicated in thrashing linear arithmetic, so we provide
 this theory which can be DISABLED if it becomes a problem.
 </p>
 
 
 <p>
 </p>")

(defxdoc floor-x+i*k-i*j
  :parents (floor-lemmas)
  :short "Rewrite: (FLOOR (+ x (* i k)) (* i j)) = (FLOOR k j), when
i,j &gt; 0 and 0 &lt;= x &lt; i."
  :long  "<p>
 This is a crucial lemma for certain kinds of reasoning about hardware
 specifications, and is used to prove MOD-x+i*j-i*k.
 </p>
 
 
 <p>
 </p>")

(defxdoc integer-ratio-lemmas
  :parents (quotient-remainder-lemmas)
  :short "Lemmas about ratios x/y that are known to be INTEGERP."
  :long  "<p></p>
 
 
 <p>
 </p>")

(defxdoc integer-truncate-as-niq
  :parents (truncate-lemmas)
  :short "Rewrite (D) : (TRUNCATE i j) = 
              (SIGNUM i) * (SIGNUM j) * (NIQ i j), for integers i,j."
  :long  "<p>
 This rule shows that TRUNCATE is the \"usual\" (i.e., FORTRAN-style)
 integer quotient for both positive and negative integers.
 </p>
 
 
 <p>
 </p>")

(defxdoc integerp-i/j-integerp-forward
  :parents (integer-ratio-lemmas)
  :short "Forward: If i/j is an integer and j is an integer, then i is an integer."
  :long  "<p>
 NB: The trigger-term is (INTEGERP (/ i j)).
 </p>
 
 
 <p>
 </p>")

(defxdoc integerp-mod
  :parents (mod-lemmas)
  :short "Type-Prescription: (MOD i j) is an integer, when i and j are integers."
  :long  "<p></p>
 
 
 <p>
 </p>")

(defxdoc integerp-rem
  :parents (rem-lemmas)
  :short "Type-Prescription: (REM i j) is an integer, when i and j are integers."
  :long  "<p></p>
 
 
 <p>
 </p>")

(defxdoc justify-floor-recursion
  :parents (floor-lemmas)
  :short "Rewrite: (FLOOR x y) &lt; x, when x &gt; 0 and y &gt; 1;
         x &lt; (FLOOR x y), when x &lt; -1 and y &gt;= 2."
  :long  "<p>
 This theorem justifies recursion by FLOOR using the measure ACL2-COUNT,
 which for integers i is simply (ABS i).  Thus, this theorem won't justify
 a simple recursion by a negative y, since (FLOOR 1 y) = -1 for negative y,
 and (ABS -1) = (ABS 1).  For the most general case that includes negative
 y one would need to define a different measure that could handle this 
 condition.
 </p>
 
 
 <p>
 </p>")

(defxdoc linearize-mod
  :parents (mod-lemmas)
  :short "Rewrite (D): Transform (MOD x y) &lt; z, (MOD x y) &gt; z, and (MOD x y) = z
into an equivalent FLOOR expression suitable for reasoning about with 
FLOOR-BOUNDS and other theorems about FLOOR."
  :long  "<p>
 Since this lemma can be considered a `definition' of MOD, it is exported
 DISABLED.
 </p>
 
 
 <p>
 </p>")

(defxdoc linearize-rem
  :parents (rem-lemmas)
  :short "Rewrite (D): Transform (REM x y) &lt; z, (REM x y) &gt; z, and (REM x y) = z
into an equivalent TRUNCATE expression suitable for reasoning about with 
TRUNCATE-BOUNDS and other theorems about TRUNCATE."
  :long  "<p>
 Since this lemma can be considered a `definition' of REM, it is exported
 DISABLED.
 </p>
 
 
 <p>
 </p>")

(defxdoc mod-+
  :parents (mod-+)
  :short "Rewrite (D): (MOD (+ x y) z) = (MOD (+ (MOD x z) (MOD y z)) z)."
  :long  "<p>
 As this rule could easily loop it is exported DISABLEd.  Don't ENABLE this
    lemma unless you are sure that the MOD/MOD term will simplify, or else
    put SYNTAXP guards on the variables x, y, and/or z.
 </p>
 
 
 <p>
 </p>")

(defxdoc mod-=-0
  :parents (mod-lemmas integer-ratio-lemmas)
  :short "Rewrite: (MOD x y) = 0, when x/y is an integer;"
  :long  "<p>
 This rule is a corollary of a more general equality.
 The equality is also stored as a :REWRITE and :GENERALIZE rule.
 </p>
 
 
 <p>
 </p>")

(defxdoc mod-bounds
  :parents (mod-lemmas)
  :short "Linear: Useful forms of the fact that |(MOD x y)| &lt; |y|."
  :long  "<p>
 This lemma is also stored as a :GENERALIZE rule.
 </p>
 
 
 <p>
 </p>")

(defxdoc mod-lemmas
  :parents (quotient-remainder-lemmas)
  :short "Lemmas about MOD."
  :long  "<p></p>
 
 
 <p>
 </p>")

(defxdoc mod-minus
  :parents (mod-lemmas integer-ratio-lemmas)
  :short "Rewrite: (MOD (- x) y) =
         (IF (INTEGERP (/ x y))
             0
           (- y (MOD x y)));
         (MOD x (- y)) =
         (IF (INTEGERP (/ x y))
             0
           (- (MOD x y) y))."
  :long  "<p></p>
 
 
 <p>
 </p>")

(defxdoc mod-type
  :parents (mod-lemmas)
  :short "Various: Decide (MOD x y) &lt; 0 and (MOD x y) &gt; 0 based on the sign of
y and the INTEGERP-ness of x/y."
  :long  "<p>
 This rule is also stored as appropriate :REWRITE, :LINEAR, :GENERALIZE,
 and :TYPE-PRESCRIPTION rules.
 </p>
 
 
 <p>
 </p>")

(defxdoc mod-type-linear
  :parents (mod-lemmas)
  :short "A theory of the :LINEAR rules created by the lemma MOD-TYPE."
  :long  "<p>
 These rules are implicated in thrashing linear arithmetic, so we provide
 this theory which can be DISABLED if it becomes a problem.
 </p>
 
 
 <p>
 </p>")

(defxdoc mod-x+i*k-i*j
  :parents (mod-lemmas)
  :short "Rewrite: (MOD (+ x (* i k)) (* i j)) = (+ x (* i (MOD k j))), when
i,j &gt; 0 and 0 &lt;= x &lt; i."
  :long  "<p>
 This is a crucial lemma for certain kinds of reasoning about hardware
 specifications, for example, we can use this to prove that
 (MOD i (EXPT 2 n)) = (MOD i 2) + (MOD (FLOOR i 2) (EXPT 2 (1- n))), for 
 n &gt; 0, which justifies a recursive specification of hardware
 operations.
 </p>
 
 
 <p>
 </p>")

(defxdoc mod-x-y-=-x
  :parents (mod-lemmas)
  :short "Rewrite: (MOD x y) = x, when |x| &lt;= |y| and x and y have the same sign."
  :long  "<p>
 This rule is a corollary of a more general equality which is also stored as
 :REWRITE and :GENERALIZE rules.
 </p>
 
 
 <p>
 </p>")

(defxdoc mod-x-y-=-x+y
  :parents (mod-lemmas)
  :short "Rewrite: (MOD x y) = x + y, when |x| &lt;= |y| and x and y have different
signs and x /= 0."
  :long  "<p>
 This rule is a corollary of a more general equality which is also stored as
 :REWRITE and :GENERALIZE rules.
 </p>
 
 
 <p>
 </p>")

(defxdoc niq-bounds
  :parents (niq-lemmas)
  :short "Linear (D): i/j - 1 &lt; (NIQ i j) &lt;= i/j."
  :long  "<p>
 This lemma serves as a :LINEAR definition of NONNEGATIVE-INTEGER-QUOTIENT,
 and allows us to derive interesting properties of FLOOR and TRUNCATE by
 linear arithmetic.  This lemma is stored as a :LINEAR rule under NIQ 
 since we think of this as a property of NIQ, and not as a general property
 of (/ I J).
 </p>
 
 
 <p>
 </p>")

(defxdoc niq-guard
  :parents (qr-guard-macros)
  :short "Macro form of the guard for NONNEGATIVE-INTEGER-QUOTIENT (forced)."
  :long  "<p></p>
 
 
 <p>~
 </p>")

(defxdoc niq-lemmas
  :parents (quotient-remainder-lemmas)
  :short "Lemmas about nonnegative-integer-QUOTIENT (abbreviated NIQ)."
  :long  "<p></p>
 
 
 <p>
 </p>")

(defxdoc niq-type
  :parents (niq-lemmas)
  :short "Various : Decide (NIQ i j) = 0, (NIQ i j) &gt; 0, and
(NIQ i j) = i/j based on the inequalities of i and j, and the INTEGERP-ness
of i/j."
  :long  "<p></p>
 
 
 <p>
 </p>")

(defxdoc qr-guard
  :parents (qr-guard-macros)
  :short "Quotient/Remainder GUARD: Macro form of the guards for FLOOR, MOD, TRUNCATE,
and REM., or any ratio x/y of rationals (forced)."
  :long  "<p></p>
 
 
 <p>~
 </p>")

(defxdoc qr-guard-macros
  :parents (quotient-remainder-lemmas)
  :short "Macro forms of the guards for the quotient/remainder functions."
  :long  "<p>
 Without these macros, fully 25% of the text of the
 \"quotient-remainder-lemmas\" book is given over simply to expressing
 the guards!
 </p>
 
 
 <p>
 </p>")

(defxdoc quotient-remainder-functions
  :parents (quotient-remainder-theories)
  :short "A theory of the function symbols characterized by
\"quotient-remainder-lemmas\"."
  :long  "<p>
 You should DISASBLE this theory immediately after loading this book.
 </p>
 
 
 <p>
 </p>")

(defxdoc quotient-remainder-lemmas
  :parents (quotient-remainder-lemmas)
  :short "A book of facts about FLOOR, MOD, TRUNCATE and REM, and integer ratios.
Also enough of a theory of the Acl2 function NONNEGATIVE-INTEGER-QUOTIENT
to prove the rules."
  :long  "<p>
 Since NONNEGATIVE-INTEGER-QUOTIENT is the only one of these functions that
 is recursive, the others must be DISABLEd for this library to be of any
 use.  This can easily be done by DISABLEing the QUOTIENT-REMAINDER-FUNCTIONS
 theory (defined by this book):</p>
 
 <p>(IN-THEORY (DISABLE QUOTIENT-REMAINDER-FUNCTIONS))</p>
 
 <p>
 </p>
 
 
 <p>INTRODUCTION</p>
 
 <p>Common Lisp defines the quotient/remainder functions FLOOR/MOD and
 TRUNCATE/REM, which operate on any rational numbers (as long as the divisor
 is non-zero).  Both (TRUNCATE x y) and (FLOOR x y) are integers, and
 specify the `integer part' of the rational number x/y; they differ in the
 direction of rounding.  </p>
 
 <p>TRUNCATE is the `FORTRAN-style' quotient operation, rounding towards 0,
 i.e., (TRUNCATE x y) = (TRUNCATE (ABS x) (ABS y)).  This book provides a
 selected theory of TRUNCATE and REM.</p>
 
 <p>(FLOOR x y) is identical to TRUNCATE if x/y &gt; 0 or x/y is an integer,
 otherwise for negative non-integer ratios x/y, 
 (FLOOR x y) = (TRUNCATE x y) - 1.  (FLOOR i (EXPT 2 j)) is the
 specification of an `arithmetic shift' of the integer i by -j bits.  Since
 FLOOR and MOD are the foundations for integer descriptions of hardware,
 this book contains a very extensive theory of FLOOR and MOD.</p>
 
 <p>The formal definitions of the Common Lisp functions are made in terms of
 the Acl2 function NONNEGATIVE-INTEGER-QUOTIENT, which is simple recursive
 specification of division of nonnegative integers by repeated subtraction.
 We provide only enough of a theory of NONNEGATIVE-INTEGER-QUOTIENT to prove
 the desired properties of the Common Lisp functions. </p>
 
 <p>DOCUMENTATION</p>
 
 <p>The documentation for this library is divided into a number of sections.
 There is a section for the rules that apply to each function.  Some of the
 rules will appear in more than 1 section.  If a rule is exported DISABLEd,
 then you will see `(D)' after the rule class in the `one-liner' for the
 rule.  Note that we often abbreviate NONNEGATIVE-INTEGER-QUOTIENT as NIQ.</p>
 
 <p>APPROACH</p>
 
 <p>We have tried to capture the properties of the quotient/remainder functions
 with the smallest number of the most general rules possible.  This approach
 takes advantage of Acl2 type reasoning, and the assumed existence of a
 basic mathematics simplification library.  Several lemmas contain the
 hypothesis (INTEGERP (/ x y)), which we consider to be the simplest
 statement of the fact that (&lt;quotient&gt; x y) = x/y, e.g.</p>
 
 <p>(INTEGERP (/ x y)) ==&gt; (FLOOR x y) = (/ x y),
 (INTEGERP (/ x y)) ==&gt; (MOD x y) = 0.</p>
 
 <p>Thus, the first fact above obviates the need for a specials lemmas like
 (FLOOR i 1) = i for integers i, since (/ i 1) = i by simplification.</p>
 
 <p>In general, at most 2 of the many possible commutative forms of the rules are
 exported from this library.  If they aren't the ones you need, simply prove
 the appropriate corollary, or :USE an :INSTANCE of the library rule.
 Also, lemmas are generally exported DISABLEd if they seemed to interfere
 with the proofs of other lemmas, or could easily lead to infinite looping.
 Be careful when ENABLEing these lemmas.</p>
 
 <p>Questions, comments, and sugestions are welcome.  Contact brock@@cli.com.
 </p>")

(defxdoc quotient-remainder-rules
  :parents (quotient-remainder-theories)
  :short "A theory of all rules exported ENABLEd by the \"quotient-remainder-lemmas\"
book."
  :long  "<p></p>
 
 
 <p>
 </p>")

(defxdoc quotient-remainder-theories
  :parents (quotient-remainder-lemmas)
  :short "Logical theories supplied by the QUOTIENT-REMAINDER book."
  :long  "<p></p>
 
 
 <p>The QUOTIENT-REMAINDER book exports 2 theories:
 QUOTIENT-REMAINDER-FUNCTIONS and QUOTIENT-REMAINDER-RULES.  The former is
 simply a theory of the functions characterized by the book.  Since
 these functions are all ENABLEd by default, and most are non-recursive, one
 should immediately: </p>
 
 <p>(IN-THEORY (DISABLE QUOTIENT-REMAINDER-FUNCTIONS)) </p>
 
 <p>upon loading this book, or the lemmas may never be applied.</p>
 
 <p>QUOTIENT-REMAINDER-RULES is a theory of all of the lemmas exported by this
 book which are ENABLEd by default.  You can \"turn off\" this book
 after it is loaded by</p>
 
 <p>(IN-THEORY (DISABLE QUOTIENT-REMAINDER-RULES)).
 </p>")

(defxdoc rem-=-0
  :parents (rem-lemmas integer-ratio-lemmas)
  :short "Rewrite: (REM x y) = 0, when x/y is an integer;"
  :long  "<p>
 NB: This rule is a corollary of a more general equality.
 The equality is also stored as a :REWRITE and :GENERALIZE rule.
 </p>
 
 
 <p>
 </p>")

(defxdoc rem-bounds
  :parents (rem-lemmas)
  :short "Linear: Useful forms of the fact that |(REM x y)| &lt; |y|."
  :long  "<p>
 This lemma is also stored as a :GENERALIZE rules.
 </p>
 
 
 <p>
 </p>")

(defxdoc rem-lemmas
  :parents (quotient-remainder-lemmas)
  :short "Lemmas about REM."
  :long  "<p></p>
 
 
 <p>
 </p>")

(defxdoc rem-minus
  :parents (rem-lemmas)
  :short "Rewrite: (REM (- x) y) = (- (REM x y));
         (REM x (- y)) = (SIGNUM x) * (SIGNUM y) * (REM x y))."
  :long  "<p></p>
 
 
 <p>
 </p>")

(defxdoc rem-type
  :parents (rem-lemmas)
  :short "Various : Decide (REM x y) &lt; 0 and (REM x y) &gt; 0 based on the sign of
x and the INTEGERP-ness of x/y."
  :long  "<p>
 This rule is stored as appropriate :REWRITE, :LINEAR, :GENERALIZE, and
 :TYPE-PRESCRIPTION rules.
 </p>
 
 
 <p>
 </p>")

(defxdoc rem-x-y-=-x
  :parents (rem-lemmas)
  :short "Rewrite: (REM x y) = x, when |x| &lt; |y|."
  :long  "<p>
 This rule is a corollary of a more general equality which is also stored as
 a :REWRITE and :GENERALIZE rule.
 </p>
 
 
 <p>
 </p>")

(defxdoc rewrite-floor-mod
  :parents (floor-lemmas integer-ratio-lemmas)
  :short "Rewrite: (FLOOR (MOD x y) z) = (FLOOR x z) - i*(FLOOR x y), when i = y/z
is an integer."
  :long  "<p></p>
 
 
 <p>
 </p>")

(defxdoc rewrite-floor-x*y-z-left
  :parents (floor-lemmas)
  :short "Rewrite (D): (FLOOR (* x y) z) = (FLOOR y (/ z x)), when x /= 0."
  :long  "<p>
 Since we don't presume any rewriting strategy for / vis-a-vis *, this
 often useful rule is exported DISABLEd.
 </p>
 
 
 <p>
 </p>")

(defxdoc rewrite-floor-x*y-z-right
  :parents (floor-lemmas)
  :short "Rewrite: (FLOOR (* x y) z) = (FLOOR x (/ z y)), when y /= 0."
  :long  "<p>
 Since we don't presume any rewriting strategy for / vis-a-vis *, this
 often useful rule is exported DISABLEd.
 </p>
 
 
 <p>
 </p>")

(defxdoc rewrite-mod-mod
  :parents (mod-lemmas integer-ratio-lemmas)
  :short "Rewrite: (MOD (MOD x y) z) = (MOD x z), when y/z is an integer."
  :long  "<p></p>
 
 
 <p>
 </p>")

(defxdoc rewrite-truncate-x*y-z-left
  :parents (truncate-lemmas)
  :short "Rewrite (D): (TRUNCATE (* x y) z) = (TRUNCATE y (/ z x)), when x /= 0."
  :long  "<p>
 Since we don't presume any rewriting strategy for / vis-a-vis *, this
 often useful rule is exported DISABLEd.
 </p>
 
 
 <p>
 </p>")

(defxdoc rewrite-truncate-x*y-z-right
  :parents (truncate-lemmas)
  :short "Rewrite (D): (TRUNCATE (* x y) z) = (TRUNCATE x (/ z y)), when y /= 0."
  :long  "<p>
 Since we don't presume any rewriting strategy for / vis-a-vis *, this
 often useful rule is exported DISABLEd.
 </p>
 
 
 <p>
 </p>")

(defxdoc simplify-mod-+-mod
  :parents (mod-lemmas)
  :short "Rewrite: (MOD (+ w (MOD x y)) z) = (MOD (+ w x) z);
         (MOD (+ (MOD x y) w) z) = (MOD (+ w x) z));
         (MOD (- w (MOD x y)) z) = (MOD (- w x) z));
         (MOD (- (MOD x y) w) z) = (MOD (- x w) z)),
Provided that for each case y/z is an integer."
  :long  "<p></p>
 
 
 <p>
 </p>")

(defxdoc truncate-=-x/y
  :parents (truncate-lemmas integer-ratio-lemmas)
  :short "Rewrite: (TRUNCATE x y) = x/y, when x/y is an integer."
  :long  "<p>
 This rule is a corollary of a more general equality, which is also stored
 as a :REWRITE and :GENERALIZE rule.
 </p>
 
 
 <p>
 </p>")

(defxdoc truncate-bounds
  :parents (truncate-lemmas)
  :short "Linear (D) : x/y - 1 &lt; (TRUNCATE x y) &lt;= x/y, when x/y &gt;= 0;
             x/y &lt;= (TRUNCATE x y) &lt; x/y + 1, when x/y =&lt; 0."
  :long  "<p>
 This lemma `defines' TRUNCATE as a set of inequalties.  Many of the
 properties of TRUNCATE will be derived from this theorem.  Unfortunately,
 this lemma is implicated in thrashing in the linear arithmetic procedure
 unless the inequalties of X and Y can be decided, so it may need to be
 DISABLEd at times.  This lemma is stored as a :LINEAR rule for TRUNCATE
 exclusively since we consider it to be a property of TRUNCATE, and not a
 general property of (/ x y).</p>
 
 <p>The statement of the hypotheses of this lemma is critical for its
 proper application.  It is necessary for each inequality of x and y to
 stand alone in order to be relieveable by linear arithemetic.  
 </p>
 
 
 <p>
 </p>")

(defxdoc truncate-cancel-*
  :parents (truncate-lemmas)
  :short "Rewrite: (TRUNCATE (* x y) y) = (TRUNCATE x 1)."
  :long  "<p>
 NB: You get the commutted form as well.
 </p>
 
 
 <p>
 </p>")

(defxdoc truncate-lemmas
  :parents (quotient-remainder-lemmas)
  :short "Lemmas about TRUNCATE."
  :long  "<p></p>
 
 
 <p>
 </p>")

(defxdoc truncate-minus
  :parents (truncate-lemmas)
  :short "Rewrite: (TRUNCATE (- x) y) = (- (TRUNCATE x y));
         (TRUNCATE x (- y)) = (- (TRUNCATE x y))."
  :long  "<p></p>
 
 
 <p>
 </p>")

(defxdoc truncate-rem-elim
  :parents (truncate-lemmas rem-lemmas)
  :short "Rewrite: (+ (REM x y) (* y (TRUNCATE x y))) = x."
  :long  "<p>
 NB: This rule is also stored as an :ELIM rule.
 </p>
 
 
 <p>
 </p>")

(defxdoc truncate-type
  :parents (truncate-lemmas)
  :short "Various : Decide (TRUNCATE x y) &lt; 0, (TRUNCATE x y) &gt; 0, and
(TRUNCATE x y) = 0 based on inequalities of x and y."
  :long  "<p>
 This rule is available in various forms: :REWRITE, :LINEAR,
 :TYPE-PRESCRIPTION, and :GENERALIZE as appropriate.  Note that unless we
 can decide the inequalities of X and Y the :LINEAR forms may thrash.
 </p>
 
 
 <p>
 </p>")

