!{\src2tex{textfont=tt}}
!!****f* ABINIT/chkpawovlp
!! NAME
!! chkpawovlp
!!
!! FUNCTION
!! Verify that the paw spheres are not overlapping
!!
!! COPYRIGHT
!! Copyright (C) 1998-2007 ABINIT group (FJ, MT)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt.
!!
!! INPUTS
!!  natom=number of atoms in cell.
!!  ntypat=number of types of atoms in unit cell.
!!  pawovlp=percentage of voluminal overlap ratio allowed to continue execution
!!          (if negative value, execution always continues)
!!  pawtab(ntypat) <type(pawtab_type)>=paw tabulated starting data:
!!  rmet(3,3)=real space metric ($\textrm{bohr}^{2}$).
!!  typat(natom)=type (integer) for each atom
!!  xred(3,natom)=reduced dimensionless atomic coordinates
!!
!! OUTPUT
!!  (only checking)
!!
!! NOTES
!!
!! PARENTS
!!      scfcv
!!
!! CHILDREN
!!      leave_new,wrtout
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine chkpawovlp(natom,ntypat,pawovlp,pawtab,rmet,typat,xred)

 use defs_basis
 use defs_datatypes

!This section has been created automatically by the script Abilint (TD). Do not modify these by hand.
#ifdef HAVE_FORTRAN_INTERFACES
 use interfaces_01manage_mpi
#endif
!End of the abilint section

 implicit none

!Arguments ---------------------------------------------
!scalars
 integer,intent(in) :: natom,ntypat
 real(dp) :: pawovlp
!arrays
 integer,intent(in) :: typat(natom)
 real(dp),intent(in) :: rmet(3,3),xred(3,natom)
 type(pawtab_type),intent(in) :: pawtab(ntypat)

!Local variables ---------------------------------------
!scalars
 integer :: ia,iamax,ib,ibmax,iovl,t1,t2,t3
 real(dp) :: dd,dif1,dif2,dif3,ha,hb,norm2,norm2_min,r2cut,ratio_percent
 real(dp) :: ratio_percent_max,sqnrm,u1,u2,u3,va,vb,vv
 character(len=500) :: message

! *************************************************************************

!Statement function: squared norm of a vector
 sqnrm(u1,u2,u3)=rmet(1,1)*u1*u1+rmet(2,1)*u2*u1+rmet(3,1)*u3*u1&
&               +rmet(1,2)*u1*u2+rmet(2,2)*u2*u2+rmet(3,2)*u3*u2&
&               +rmet(1,3)*u1*u3+rmet(2,3)*u2*u3+rmet(3,3)*u3*u3

 iamax=-1;ibmax=-1
 norm2_min=-1.d0;ratio_percent_max=-1.d0
 iovl=0

!Loop on "overlapping" atoms with the maximum overlap
 do ia=1,natom
  do ib=ia,natom

   r2cut=(pawtab(typat(ia))%rpaw+pawtab(typat(ib))%rpaw)**2

!  Visit the box and its first images:
   do t3=-1,1
    do t2=-1,1
     do t1=-1,1

      dif1=xred(1,ia)-(xred(1,ib)+dble(t1))
      dif2=xred(2,ia)-(xred(2,ib)+dble(t2))
      dif3=xred(3,ia)-(xred(3,ib)+dble(t3))
      norm2=sqnrm(dif1,dif2,dif3)

      if(norm2>tol10.and.norm2<r2cut) then

       iovl=iovl+1

!      Compute the overlap ratio:
       dd=sqrt(norm2)
       va=4._dp/3._dp*pi*pawtab(typat(ia))%rpaw**3
       vb=4._dp/3._dp*pi*pawtab(typat(ib))%rpaw**3
       ha=(pawtab(typat(ib))%rpaw**2-(dd-pawtab(typat(ia))%rpaw)**2)/(two*dd)
       hb=(pawtab(typat(ia))%rpaw**2-(dd-pawtab(typat(ib))%rpaw)**2)/(two*dd)
       vv=pi/3.d0*(ha**2*(three*pawtab(typat(ia))%rpaw-ha)+hb**2*(three*pawtab(typat(ib))%rpaw-hb))
       ratio_percent=100._dp*min(vv/min(va,vb),one)
       if (ratio_percent>ratio_percent_max) then
        ratio_percent_max=ratio_percent
        norm2_min=norm2
        iamax=ia;ibmax=ib
       end if

      end if
     end do
    end do
   end do
  end do
 end do

 if (iovl>0) then

! Print adapted message with overlap value:
  if (abs(pawovlp)<=tol6.or.(pawovlp>tol6.and.ratio_percent_max>pawovlp)) then
   write(message, '(3a)' ) ch10,' chkpawovlp : ERROR -',ch10
  else
   write(message, '(3a)' ) ch10,' chkpawovlp : WARNING -',ch10
  end if
  write(message, '(3a,2(a,i3),a,f9.5,a,2(a,i3,a,f9.5,a),a,f5.2,a)' ) trim(message),&
&   '  PAW SPHERES ARE OVERLAPPING !',ch10,&
&   '   Distance between atoms ',iamax,' and ',ibmax,' is  : ',sqrt(norm2_min),ch10,&
&   '   Radius of the sphere around atom ',iamax,' is: ',pawtab(typat(iamax))%rpaw,ch10,&
&   '   Radius of the sphere around atom ',ibmax,' is: ',pawtab(typat(ibmax))%rpaw,ch10,&
&   '   This leads to a (voluminal) overlap ratio of ',ratio_percent_max,' %'
  if (abs(pawovlp)<=tol6.or.(pawovlp>tol6.and.ratio_percent_max>pawovlp)) then
   write(message, '(5a)' ) trim(message),ch10,&
&   '  Action: 1- decrease cutoff radius of pseudopotential(s)',ch10,&
&   '      OR  2- ajust "pawovlp" input variable to allow overlap'
   call wrtout(6,message,'COLL')
   call leave_new('COLL')
  else
   call wrtout(6,message,'COLL')
  end if
  if (iovl>1) then
   write(message, '(a)' ) '  => Note that other spheres are overlapping !'
   call wrtout(6,message,'COLL')
  end if

! Print last message if execution continues:
  if (pawovlp<tol6) then
   write(message, '(5a)' ) &
&   '       Results might be approximate,',ch10,&
&   '       and even inaccurate (if overlap is too big) !',ch10,&
&   '       Assume experienced user. Execution will continue.'
   call wrtout(6,message,'COLL')
  end if
  if (pawovlp>tol6.and.ratio_percent_max<=pawovlp) then
   write(message, '(7a)' ) &
&   '       Overlap ratio seems to be acceptable (less than value',ch10,&
&   '       of "pawovlp" input parameter): execution will continue.',ch10,&
&   '       But be aware that results might be approximate,',ch10,&
&   '       and even inaccurate (depending on your physical system) !'
   call wrtout(6,message,'COLL')
  end if

 end if !iovl>0

end subroutine chkpawovlp
!!***
