# -*- Autoconf -*-
#
# Copyright (c) 2005-2007 The ABINIT Group (Yann Pouillon)
# All rights reserved.
#
# This file is part of the ABINIT software package. For license information,
# please see the COPYING file in the top-level directory of the ABINIT source
# distribution.
#

#
# C++ compilers support
#



# _ABI_CHECK_CXX_COMPAQ(COMPILER)
# -------------------------------
#
# Checks whether the specified C++ compiler is the COMPAQ C++ compiler.
# If yes, tries to determine its version number and sets the cxx_type
# and cxx_version variables accordingly.
#
AC_DEFUN([_ABI_CHECK_CXX_COMPAQ],
[dnl Do some sanity checking of the arguments
 m4_if([$1], , [AC_FATAL([$0: missing argument 1])])dnl

 AC_MSG_CHECKING([if we are using the Compaq C++ compiler])

 cxx_info_string=`$1 -V 2>&1`
 abi_result=`echo "${cxx_info_string}" | grep '^Compaq C++'`
 if test "${abi_result}" = ""; then
  abi_result="no"
  cxx_info_string=""
  cxx_type="UNKNOWN"
  cxx_version="UNKNOWN"
 else
  AC_DEFINE([COMPAQ_CXX],1,[Define to 1 if you are using the COMPAQ C++ compiler])
  cxx_type="compaq"
  cxx_version=`echo "${cxx_info_string}" | grep '^Compiler Driver' | sed -e 's/Compiler Driver V//; s/-.*//'`
  if test "${cxx_version}" = "${cxx_info_string}"; then
   cxx_version="UNKNOWN"
  fi
  abi_result="yes"
 fi
 AC_MSG_RESULT(${abi_result})
]) # _ABI_CHECK_CXX_COMPAQ



# _ABI_CHECK_CXX_GNU(COMPILER)
# ----------------------------
#
# Checks whether the specified C++ compiler is the GNU C++ compiler.
# If yes, tries to determine its version number and sets the cxx_type
# and cxx_version variables accordingly.
#
AC_DEFUN([_ABI_CHECK_CXX_GNU],
[dnl Do some sanity checking of the arguments
 m4_if([$1], , [AC_FATAL([$0: missing argument 1])])dnl

 AC_MSG_CHECKING([if we are using the GNU C++ compiler])

 cxx_info_string=`$1 --version 2>&1 | head -1`
 if test "${ac_cv_cxx_compiler_gnu}" != "yes"; then
  cxx_info_string=""
  cxx_type="UNKNOWN"
  cxx_version="UNKNOWN"
  abi_result="no"
 else
  AC_DEFINE([GNU_CXX],1,[Define to 1 if you are using the GNU C++ compiler])
  cxx_type="gnu"
  cxx_version=`echo ${cxx_info_string} | sed -e 's/.*(GCC) //; s/ .*//'`
  if test "${cxx_version}" = "${cxx_info_string}"; then
   abi_result=`echo "${cxx_info_string}" | grep ' '`
   if test "${abi_result}" != ""; then
    cxx_version="UNKNOWN"
   fi
  fi
  abi_result="yes"
 fi
 AC_MSG_RESULT(${abi_result})
]) # _ABI_CHECK_CXX_GNU



# _ABI_CHECK_CXX_IBM(COMPILER)
# ----------------------------
#
# Checks whether the specified C++ compiler is the IBM XL C++ compiler.
# If yes, tries to determine its version number and sets the cxx_type
# and cxx_version variables accordingly.
#
AC_DEFUN([_ABI_CHECK_CXX_IBM],
[dnl Do some sanity checking of the arguments
 m4_if([$1], , [AC_FATAL([$0: missing argument 1])])dnl

 AC_MSG_CHECKING([if we are using the IBM XL C++ compiler])

 cxx_info_string=`$1 -qversion 2>&1 | head -1`
 cxx_garbage=`$1 -qversion 2>&1 | wc -l | sed -e 's/ //g'`
 abi_result=`echo "${cxx_info_string}" | grep 'IBM(R) XL C/C++'`
 if test "${abi_result}" = ""; then
  abi_result=`echo "${cxx_info_string}" | grep 'C for AIX'`
 fi
 if test "${abi_result}" = ""; then
  abi_result="no"
  cxx_info_string=""
  cxx_type="UNKNOWN"
  cxx_version="UNKNOWN"
  if test "${cxx_garbage}" -gt 50; then
   AC_DEFINE([IBM_CXX],1,[Define to 1 if you are using the IBM XL C++ compiler])
   cxx_type="ibm"
   cxx_version="UNKNOWN"
   abi_result="yes"
  fi
 else
  AC_DEFINE([IBM_CXX],1,[Define to 1 if you are using the IBM XL C++ compiler])
  cxx_type="ibm"
  cxx_version=`echo "${cxx_info_string}" | sed -e 's/.* V//; s/ .*//'`
  if test "${cxx_version}" = "${cxx_info_string}"; then
   cxx_version=`echo "${cxx_info_string}" | sed -e 's/C for AIX version //'`
  fi
  if test "${cxx_version}" = "${cxx_info_string}"; then
   cxx_version="UNKNOWN"
  fi
  abi_result="yes"
 fi
 AC_MSG_RESULT(${abi_result})
]) # _ABI_CHECK_CXX_IBM



# _ABI_CHECK_CXX_INTEL(COMPILER)
# ------------------------------
#
# Checks whether the specified C++ compiler is the Intel C++ compiler.
# If yes, tries to determine its version number and sets the cxx_type
# and cxx_version variables accordingly.
#
AC_DEFUN([_ABI_CHECK_CXX_INTEL],
[dnl Do some sanity checking of the arguments
 m4_if([$1], , [AC_FATAL([$0: missing argument 1])])dnl

 AC_MSG_CHECKING([if we are using the Intel C++ compiler])

 cxx_info_string=`$1 -v -V 2>&1`
 abi_result=`echo "${cxx_info_string}" | head -n 1 | grep 'Intel(R) C++ Compiler'`
 if test "${abi_result}" = ""; then
  abi_result="no"
  cxx_info_string=""
  cxx_type="UNKNOWN"
  cxx_version="UNKNOWN"
 else
  AC_DEFINE([INTEL_CXX],1,[Define to 1 if you are using the Intel C++ compiler])
  cxx_type="intel"
  cxx_version=`echo "${abi_result}" | sed -e 's/.*Version //; s/ .*//'`
  if test "${cxx_version}" = "${abi_result}"; then
   cxx_version="UNKNOWN"
  fi
  abi_result="yes"
 fi
 AC_MSG_RESULT(${abi_result})
]) # _ABI_CHECK_CXX_INTEL



# _ABI_CHECK_CXX_PATHSCALE(COMPILER)
# ----------------------------------
#
# Checks whether the specified C++ compiler is the PathScale C++ compiler.
# If yes, tries to determine its version number and sets the cxx_type
# and cxx_version variables accordingly.
#
AC_DEFUN([_ABI_CHECK_CXX_PATHSCALE],
[dnl Do some sanity checking of the arguments
 m4_if([$1], , [AC_FATAL([$0: missing argument 1])])dnl

 AC_MSG_CHECKING([if we are using the PathScale C++ compiler])

 cxx_info_string=`$1 --version 2>&1`
 abi_result=`echo "${cxx_info_string}" | grep '^PathScale'`
 if test "${abi_result}" = ""; then
  abi_result="no"
  cxx_info_string=""
  cxx_type="UNKNOWN"
  cxx_version="UNKNOWN"
 else
  AC_DEFINE([PATHSCALE_CXX],1,[Define to 1 if you are using the PathScale C++ compiler])
  cxx_type="pathscale"
  cxx_version=`echo "${abi_result}" | sed -e 's/.* Version //; s/ .*//'`
  if test "${cxx_version}" = "${abi_result}"; then
   cxx_version="UNKNOWN"
  fi
  abi_result="yes"
 fi
 AC_MSG_RESULT(${abi_result})
]) # _ABI_CHECK_CXX_PATHSCALE



# _ABI_CHECK_CXX_PGI(COMPILER)
# ----------------------------
#
# Checks whether the specified C++ compiler is the Portland Group C++
# compiler. If yes, tries to determine its version number and sets the
# cxx_type and cxx_version variables accordingly.
#
AC_DEFUN([_ABI_CHECK_CXX_PGI],
[dnl Do some sanity checking of the arguments
 m4_if([$1], , [AC_FATAL([$0: missing argument 1])])dnl

 AC_MSG_CHECKING([if we are using the Portland Group C++ compiler])

 cxx_info_string=`$1 -v -V 2>&1 | sed -e '/^$/d'`
 abi_result=`echo "${cxx_info_string}" | grep '^pgCC'`
 if test "${abi_result}" = ""; then
  abi_result="no"
  cxx_info_string=""
  cxx_type="UNKNOWN"
  cxx_version="UNKNOWN"
 else
  AC_DEFINE([PGI_CXX],1,[Define to 1 if you are using the Portland Group C++ compiler])
  cxx_type="pgi"
  cxx_version=`echo "${abi_result}" | sed -e 's/.* //; s/-.*//'`
  if test "${cxx_version}" = "${abi_result}"; then
   cxx_version="UNKNOWN"
  fi
  abi_result="yes"
 fi
 AC_MSG_RESULT(${abi_result})
]) # _ABI_CHECK_CXX_PGI



# ABI_PROG_CXX()
# --------------
#
# Tries to determine which type of C++ compiler is installed.
#
AC_DEFUN([ABI_PROG_CXX],
[dnl Init
 if test "${cxx_type}" = ""; then
  cxx_type="UNKNOWN"
 fi

 dnl Determine C++ compiler type (the order is important)
 if test "${cxx_type}" = "UNKNOWN"; then
  _ABI_CHECK_CXX_GNU(${CXX})
 fi
 if test "${cxx_type}" = "UNKNOWN"; then
  _ABI_CHECK_CXX_INTEL(${CXX})
 fi
 if test "${cxx_type}" = "UNKNOWN"; then
  _ABI_CHECK_CXX_COMPAQ(${CXX})
 fi
 if test "${cxx_type}" = "UNKNOWN"; then
  _ABI_CHECK_CXX_PATHSCALE(${CXX})
 fi
 if test "${cxx_type}" = "UNKNOWN"; then
  _ABI_CHECK_CXX_PGI(${CXX})
 fi
 if test "${cxx_type}" = "UNKNOWN"; then
  _ABI_CHECK_CXX_IBM(${CXX})
 fi

 dnl Schedule compiler info for substitution
 AC_SUBST(cxx_type)
 AC_SUBST(cxx_version)
]) # ABI_PROG_CXX
