/*
 * plus4memhannes256k.h - HANNES 256K EXPANSION emulation.
 *
 * Written by
 *  Marco van den Heuvel <blackystardust68@yahoo.com>
 *
 * This file is part of VICE, the Versatile Commodore Emulator.
 * See README for copyright notice.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 *  02111-1307  USA.
 *
 */

#ifndef VICE_H256K_H
#define VICE_H256K_H

#include "types.h"

#define H256K_DISABLED  0
#define H256K_256K      1
#define H256K_1024K     2
#define H256K_4096K     3

extern int h256k_enabled;

void h256k_init(void);
void h256k_reset(void);
void h256k_shutdown(void);

void h256k_store(uint16_t addr, uint8_t value);
uint8_t h256k_read(uint16_t addr);

void h256k_ram_inject(uint16_t addr, uint8_t value);

int set_h256k_enabled(int val);

#endif
