/* original parser id follows */
/* yysccsid[] = "@(#)yaccpar	1.9 (Berkeley) 02/21/93" */
/* (use YYMAJOR/YYMINOR for ifdefs dependent on parser version) */

#define YYBYACC 1
#define YYMAJOR 2
#define YYMINOR 0
#define YYPATCH 20220114

#define YYEMPTY        (-1)
#define yyclearin      (yychar = YYEMPTY)
#define yyerrok        (yyerrflag = 0)
#define YYRECOVERING() (yyerrflag != 0)
#define YYENOMEM       (-2)
#define YYEOF          0
#undef YYBTYACC
#define YYBTYACC 0
#define YYDEBUGSTR YYPREFIX "debug"
#define YYPREFIX "yy"

#define YYPURE 0

#line 2 "mon_parse.y"
/* -*- C -*-
 *
 * mon_parse.y - Parser for the VICE built-in monitor.
 *
 * Written by
 *  Daniel Sladic <sladic@eecg.toronto.edu>
 *  Andreas Boose <viceteam@t-online.de>
 *  Thomas Giesel <skoe@directbox.com>
 *
 * This file is part of VICE, the Versatile Commodore Emulator.
 * See README for copyright notice.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 *  02111-1307  USA.
 *
 */

#include "vice.h"

#ifdef __GNUC__
#undef alloca
#define        alloca(n)       __builtin_alloca (n)
#else /* not __GNUC__ */
#ifdef HAVE_ALLOCA_H
#include <alloca.h>
#else  /* Not HAVE_ALLOCA_H  */
char *alloca();
#endif /* HAVE_ALLOCA_H.  */
#endif /* __GNUC__ */

#include <assert.h>
#include <ctype.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include "asm.h"
#include "console.h"
#include "drive.h"
#include "interrupt.h"
#include "lib.h"
#include "machine.h"
#include "mon_breakpoint.h"
#include "mon_command.h"
#include "mon_disassemble.h"
#include "mon_drive.h"
#include "mon_file.h"
#include "mon_memmap.h"
#include "mon_memory.h"
#include "mon_register.h"
#include "mon_util.h"
#include "montypes.h"
#include "tapeport.h"
#include "resources.h"
#include "types.h"
#include "uimon.h"
#include "vsync.h"
#include "mon_profile.h"

#define join_ints(x,y) (LO16_TO_HI16(x)|y)
#define separate_int1(x) (HI16_TO_LO16(x))
#define separate_int2(x) (LO16(x))

static int yyerror(char *s);
static int temp;
static int resolve_datatype(unsigned guess_type, const char *num);
static int resolve_range(enum t_memspace memspace, MON_ADDR range[2],
                         const char *num);

/* Defined in the lexer */
extern int new_cmd, opt_asm;
extern int cur_len, last_len;

void free_buffer(void);
void make_buffer(char *str);
int yylex(void);

void set_yydebug(int val);

#define ERR_ILLEGAL_INPUT 1     /* Generic error as returned by yacc.  */
#define ERR_RANGE_BAD_START 2
#define ERR_RANGE_BAD_END 3
#define ERR_BAD_CMD 4
#define ERR_EXPECT_CHECKNUM 5
#define ERR_EXPECT_END_CMD 6
#define ERR_MISSING_CLOSE_PAREN 7
#define ERR_INCOMPLETE_COND_OP 8
#define ERR_EXPECT_FILENAME 9
#define ERR_ADDR_TOO_BIG 10
#define ERR_IMM_TOO_BIG 11
#define ERR_EXPECT_STRING 12
#define ERR_UNDEFINED_LABEL 13
#define ERR_EXPECT_DEVICE_NUM 14
#define ERR_EXPECT_ADDRESS 15
#define ERR_INVALID_REGISTER 16

#define BAD_ADDR (new_addr(e_invalid_space, 0))
#define CHECK_ADDR(x) ((x) == addr_mask(x))

/* set to YYDEBUG 1 to get parser debugging via "yydebug" command, requires to
   set_yydebug(1) in monitor.c:monitor_init */
#ifdef DEBUG
#define YYDEBUG 1
#else
#define YYDEBUG 0
#endif

#ifdef YYSTYPE
#undef  YYSTYPE_IS_DECLARED
#define YYSTYPE_IS_DECLARED 1
#endif
#ifndef YYSTYPE_IS_DECLARED
#define YYSTYPE_IS_DECLARED 1
#line 123 "mon_parse.y"
typedef union YYSTYPE {
    MON_ADDR a;
    MON_ADDR range[2];
    int i;
    REG_ID reg;
    CONDITIONAL cond_op;
    cond_node_t *cond_node;
    RADIXTYPE rt;
    ACTION action;
    char *str;
    asm_mode_addr_info_t mode;
} YYSTYPE;
#endif /* !YYSTYPE_IS_DECLARED */
#line 164 "mon_parse.c"

/* compatibility with bison */
#ifdef YYPARSE_PARAM
/* compatibility with FreeBSD */
# ifdef YYPARSE_PARAM_TYPE
#  define YYPARSE_DECL() yyparse(YYPARSE_PARAM_TYPE YYPARSE_PARAM)
# else
#  define YYPARSE_DECL() yyparse(void *YYPARSE_PARAM)
# endif
#else
# define YYPARSE_DECL() yyparse(void)
#endif

/* Parameters sent to lex. */
#ifdef YYLEX_PARAM
# define YYLEX_DECL() yylex(void *YYLEX_PARAM)
# define YYLEX yylex(YYLEX_PARAM)
#else
# define YYLEX_DECL() yylex(void)
# define YYLEX yylex()
#endif

#if !(defined(yylex) || defined(YYSTATE))
int YYLEX_DECL();
#endif

/* Parameters sent to yyerror. */
#ifndef YYERROR_DECL
#define YYERROR_DECL() yyerror(const char *s)
#endif
#ifndef YYERROR_CALL
#define YYERROR_CALL(msg) yyerror(msg)
#endif

extern int YYPARSE_DECL();

#define H_NUMBER 257
#define D_NUMBER 258
#define O_NUMBER 259
#define B_NUMBER 260
#define CONVERT_OP 261
#define B_DATA 262
#define H_RANGE_GUESS 263
#define D_NUMBER_GUESS 264
#define O_NUMBER_GUESS 265
#define B_NUMBER_GUESS 266
#define BAD_CMD 267
#define MEM_OP 268
#define IF 269
#define MEM_COMP 270
#define MEM_DISK8 271
#define MEM_DISK9 272
#define MEM_DISK10 273
#define MEM_DISK11 274
#define EQUALS 275
#define TRAIL 276
#define CMD_SEP 277
#define LABEL_ASGN_COMMENT 278
#define CMD_LOG 279
#define CMD_LOGNAME 280
#define CMD_SIDEFX 281
#define CMD_DUMMY 282
#define CMD_RETURN 283
#define CMD_BLOCK_READ 284
#define CMD_BLOCK_WRITE 285
#define CMD_UP 286
#define CMD_DOWN 287
#define CMD_LOAD 288
#define CMD_BASICLOAD 289
#define CMD_SAVE 290
#define CMD_VERIFY 291
#define CMD_BVERIFY 292
#define CMD_IGNORE 293
#define CMD_HUNT 294
#define CMD_FILL 295
#define CMD_MOVE 296
#define CMD_GOTO 297
#define CMD_REGISTERS 298
#define CMD_READSPACE 299
#define CMD_WRITESPACE 300
#define CMD_RADIX 301
#define CMD_MEM_DISPLAY 302
#define CMD_BREAK 303
#define CMD_TRACE 304
#define CMD_IO 305
#define CMD_BRMON 306
#define CMD_COMPARE 307
#define CMD_DUMP 308
#define CMD_UNDUMP 309
#define CMD_EXIT 310
#define CMD_DELETE 311
#define CMD_CONDITION 312
#define CMD_COMMAND 313
#define CMD_ASSEMBLE 314
#define CMD_DISASSEMBLE 315
#define CMD_NEXT 316
#define CMD_STEP 317
#define CMD_PRINT 318
#define CMD_DEVICE 319
#define CMD_HELP 320
#define CMD_WATCH 321
#define CMD_DISK 322
#define CMD_QUIT 323
#define CMD_CHDIR 324
#define CMD_BANK 325
#define CMD_LOAD_LABELS 326
#define CMD_SAVE_LABELS 327
#define CMD_ADD_LABEL 328
#define CMD_DEL_LABEL 329
#define CMD_SHOW_LABELS 330
#define CMD_CLEAR_LABELS 331
#define CMD_RECORD 332
#define CMD_MON_STOP 333
#define CMD_PLAYBACK 334
#define CMD_CHAR_DISPLAY 335
#define CMD_SPRITE_DISPLAY 336
#define CMD_TEXT_DISPLAY 337
#define CMD_SCREENCODE_DISPLAY 338
#define CMD_ENTER_DATA 339
#define CMD_ENTER_BIN_DATA 340
#define CMD_KEYBUF 341
#define CMD_BLOAD 342
#define CMD_BSAVE 343
#define CMD_SCREEN 344
#define CMD_UNTIL 345
#define CMD_CPU 346
#define CMD_YYDEBUG 347
#define CMD_BACKTRACE 348
#define CMD_SCREENSHOT 349
#define CMD_PWD 350
#define CMD_DIR 351
#define CMD_MKDIR 352
#define CMD_RMDIR 353
#define CMD_RESOURCE_GET 354
#define CMD_RESOURCE_SET 355
#define CMD_LOAD_RESOURCES 356
#define CMD_SAVE_RESOURCES 357
#define CMD_ATTACH 358
#define CMD_DETACH 359
#define CMD_MON_RESET 360
#define CMD_TAPECTRL 361
#define CMD_CARTFREEZE 362
#define CMD_UPDB 363
#define CMD_JPDB 364
#define CMD_CPUHISTORY 365
#define CMD_MEMMAPZAP 366
#define CMD_MEMMAPSHOW 367
#define CMD_MEMMAPSAVE 368
#define CMD_COMMENT 369
#define CMD_LIST 370
#define CMD_STOPWATCH 371
#define RESET 372
#define CMD_EXPORT 373
#define CMD_AUTOSTART 374
#define CMD_AUTOLOAD 375
#define CMD_MAINCPU_TRACE 376
#define CMD_WARP 377
#define CMD_PROFILE 378
#define FLAT 379
#define GRAPH 380
#define FUNC 381
#define DEPTH 382
#define DISASS 383
#define PROFILE_CONTEXT 384
#define CLEAR 385
#define CMD_LABEL_ASGN 386
#define L_PAREN 387
#define R_PAREN 388
#define ARG_IMMEDIATE 389
#define REG_A 390
#define REG_X 391
#define REG_Y 392
#define COMMA 393
#define INST_SEP 394
#define L_BRACKET 395
#define R_BRACKET 396
#define LESS_THAN 397
#define REG_U 398
#define REG_S 399
#define REG_PC 400
#define REG_PCR 401
#define REG_B 402
#define REG_C 403
#define REG_D 404
#define REG_E 405
#define REG_H 406
#define REG_L 407
#define REG_AF 408
#define REG_BC 409
#define REG_DE 410
#define REG_HL 411
#define REG_IX 412
#define REG_IY 413
#define REG_SP 414
#define REG_IXH 415
#define REG_IXL 416
#define REG_IYH 417
#define REG_IYL 418
#define PLUS 419
#define MINUS 420
#define STRING 421
#define FILENAME 422
#define R_O_L 423
#define R_O_L_Q 424
#define OPCODE 425
#define LABEL 426
#define BANKNAME 427
#define CPUTYPE 428
#define MON_REGISTER 429
#define COND_OP 430
#define RADIX_TYPE 431
#define INPUT_SPEC 432
#define CMD_CHECKPT_ON 433
#define CMD_CHECKPT_OFF 434
#define TOGGLE 435
#define MASK 436
#define YYERRCODE 256
typedef int YYINT;
static const YYINT yylhs[] = {                           -1,
    0,    0,    0,   35,   35,   37,   37,   37,   36,   36,
   36,   36,   36,   36,   36,   36,   36,   36,   36,   36,
   36,   38,   38,   38,   38,   38,   38,   38,   38,   38,
   38,   38,   38,   38,   38,   38,   38,   38,   38,   38,
   38,   38,   38,   38,   38,   38,   38,   38,   38,   38,
   38,   38,   38,   38,   38,   38,   38,   38,   38,   51,
   51,   51,   39,   39,   39,   39,   39,   39,   39,   39,
   39,   39,   39,   39,   39,   54,   41,   41,   41,   41,
   40,   40,   40,   40,   40,   40,   40,   40,   40,   40,
   40,   40,   40,   40,   40,   40,   40,   40,   40,   40,
   42,   42,   42,   42,   42,   42,   42,   42,   43,   43,
   43,   43,   43,   43,   43,   43,   43,   43,   43,   44,
   44,   44,   44,   44,   44,   44,   44,   44,   44,   44,
   44,   44,   44,   44,   44,   45,   45,   45,   45,   45,
   45,   45,   45,   45,   45,   45,   45,   45,   45,   45,
   45,   45,   45,   45,   45,   45,   45,   45,   45,   45,
   45,   45,   45,   45,   45,   45,   45,   45,   45,   45,
   45,   46,   46,   46,   46,   46,   46,   46,   46,   46,
   46,   46,   46,   46,   46,   46,   46,   46,   46,   46,
   46,   46,   46,   47,   47,   47,   48,   48,   49,   24,
   25,   25,   26,   29,   29,   14,   14,   19,   19,   20,
   20,   23,   23,   52,   52,   55,   18,   18,   12,   12,
    2,    2,    1,    1,    1,    4,    4,    3,    3,    3,
   50,   50,   15,   15,   15,   15,   15,   16,   17,    9,
    9,    9,    9,    9,    9,    9,    5,    5,    6,    6,
    6,    6,    6,    7,    7,    7,    7,   27,   27,   28,
   28,   30,   30,   31,   31,   31,   21,   21,   10,   10,
   10,   10,   11,   11,   13,   13,   13,    8,    8,    8,
    8,    8,   56,   56,   56,   22,   53,   53,   32,   32,
   32,   32,   32,   32,   32,   32,   32,   32,   32,   32,
   32,   32,   32,   32,   32,   32,   32,   32,   32,   32,
   32,   32,   32,   32,   32,   32,   32,   32,   32,   32,
   32,   32,   32,   32,   32,   32,   32,   32,   32,   32,
   32,   32,   32,   32,   32,   32,   32,   32,   32,   32,
   32,   32,   32,   32,   32,   32,   32,   32,   32,   32,
   33,   33,   33,   33,   34,
};
static const YYINT yylen[] = {                            2,
    1,    2,    1,    1,    2,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    2,    3,    3,    5,    3,    2,    2,    3,    2,
    3,    2,    4,    6,    8,   10,   12,    4,    6,    8,
   10,   12,   14,    2,    3,    3,    2,    4,    2,    4,
    2,    4,    2,    4,    2,    3,    2,    3,    1,    2,
    3,    3,    5,    3,    5,    3,    5,    3,    5,    3,
    2,    3,    2,    4,    5,    0,    5,    3,    3,    2,
    5,    5,    5,    5,    5,    3,    2,    3,    2,    3,
    2,    3,    2,    3,    2,    2,    2,    4,    5,    5,
    5,    2,    3,    2,    5,    2,    5,    2,    3,    2,
    3,    2,    3,    5,    3,    2,    5,    5,    4,    3,
    2,    3,    2,    3,    2,    3,    3,    2,    2,    3,
    2,    2,    2,    2,    3,    3,    3,    2,    3,    3,
    3,    3,    2,    3,    2,    3,    3,    3,    5,    3,
    4,    3,    3,    2,    4,    4,    2,    3,    4,    3,
    3,    2,    3,    2,    4,    4,    6,    4,    4,    4,
    4,    5,    5,    5,    4,    5,    3,    4,    5,    4,
    5,    5,    4,    5,    5,    2,    3,    4,    3,    3,
    5,    3,    5,    3,    2,    3,    4,    2,    2,    1,
    1,    0,    1,    1,    1,    1,    1,    2,    1,    1,
    0,    1,    2,    3,    1,    3,    1,    1,    1,    0,
    1,    1,    3,    1,    3,    2,    0,    1,    3,    1,
    1,    0,    1,    1,    1,    1,    1,    1,    1,    3,
    3,    3,    3,    3,    3,    1,    2,    0,    3,    3,
    3,    3,    1,    1,    1,    6,    4,    3,    1,    1,
    1,    2,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    0,    1,    1,    1,    1,    1,    1,
    1,    1,    3,    3,    2,    2,    1,    1,    2,    1,
    3,    3,    3,    3,    3,    5,    7,    5,    3,    3,
    3,    3,    3,    3,    5,    5,    5,    5,    0,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    2,    3,    3,
    4,    3,    4,    2,    3,    3,    3,    3,    5,    5,
    6,    5,    6,    4,    5,    5,    5,    5,    3,    5,
    1,    1,    1,    1,    1,
};
static const YYINT yydefred[] = {                         0,
    0,   21,    3,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    4,    9,   10,   11,
   12,   13,   14,   15,   16,   17,   18,   19,   20,   59,
  278,  280,  281,  279,  276,  277,  275,  233,  234,  235,
  236,  237,  212,    0,  267,    0,  282,    0,  246,  268,
    8,    7,    6,    0,  125,  205,  204,    0,    0,  121,
    0,  123,   44,    0,    0,  231,   51,    0,   53,    0,
    0,    0,    0,    0,    0,  218,  269,  271,  272,  270,
  217,    0,  224,  230,    0,    0,  239,    0,  228,  238,
    0,    0,    0,    0,   27,    0,    0,   60,    0,  215,
    0,  128,    0,  221,    0,    0,   87,  209,    0,    0,
  102,    0,  108,    0,   28,    0,    0,    0,  133,    0,
    0,  116,    0,    0,    0,    0,   80,   49,    0,   47,
    0,    0,    0,  129,  200,    0,  138,    0,  106,    0,
  132,  203,    0,    0,    0,   22,    0,    0,    0,    0,
    0,    0,    0,    0,   71,    0,   73,    0,  195,    0,
    0,   89,    0,   91,    0,   93,    0,   95,    0,  198,
    0,    0,    0,    0,   55,    0,  104,    0,   30,  199,
  143,    0,  145,  201,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  154,    0,    0,  157,    0,    0,   32,
    0,   96,   97,    0,    0,    0,    0,  206,    0,  186,
    0,  162,  131,    0,    0,    0,  134,    0,   57,    0,
    0,    0,    0,    0,    0,    0,  164,    0,    0,    0,
    0,    0,    0,    0,    0,  312,    0,  314,  315,  318,
  321,  322,  323,  324,  325,  326,  327,  316,  319,  317,
  320,    0,  286,    0,  110,    0,  112,    2,    5,    0,
    0,    0,    0,    0,  140,  213,  124,  126,  120,  122,
    0,    0,    0,    0,  207,    0,    0,    0,    0,    0,
    0,  113,    0,    0,    0,    0,    0,    0,   26,    0,
   61,    0,    0,   62,  127,    0,   86,  208,    0,    0,
   29,    0,   45,   46,  115,    0,    0,    0,   78,    0,
   79,    0,    0,  137,  130,  139,    0,  136,  141,   24,
   23,    0,    0,   64,    0,   66,    0,   68,    0,   70,
   72,  194,  196,   88,   90,   92,   94,  261,  260,    0,
  259,  142,    0,    0,   56,  103,   31,  148,    0,  144,
  146,  147,  150,    0,  152,  153,    0,  189,    0,    0,
  158,    0,    0,    0,    0,    0,  160,  187,  161,  190,
    0,  192,    0,  135,   58,  273,    0,  219,    0,    0,
    0,    0,    0,  163,    0,    0,    0,    0,    0,    0,
    0,    0,  289,    0,  351,  352,  355,  354,    0,    0,
  353,    0,    0,    0,    0,    0,  328,    0,    0,    0,
  109,  111,  245,  244,    0,    0,  242,  243,    0,    0,
    0,   52,   54,    0,    0,  178,    0,    0,  183,    0,
    0,  266,  265,  264,    0,  263,  223,  225,  229,    0,
    0,  216,  214,    0,    0,    0,    0,    0,    0,    0,
    0,  253,  255,  254,  119,    0,    0,    0,    0,   50,
   48,    0,    0,    0,    0,    0,    0,  197,    0,  175,
    0,  180,    0,    0,  151,  188,  155,  156,  159,   38,
    0,   33,    0,    0,   98,    0,    0,    0,  165,    0,
  166,  168,  169,  171,  170,    0,   74,  299,  300,  301,
  302,  303,  304,    0,    0,  336,    0,  332,    0,    0,
    0,    0,    0,    0,    0,    0,  335,  337,  291,  292,
  293,  338,  294,  329,  184,  226,  185,  172,  173,  176,
  181,  182,  114,  262,   84,   83,   81,   85,    0,  101,
  107,   82,    0,    0,    0,  117,  118,    0,   77,    0,
  105,   25,   63,   65,   67,   69,  258,  174,  179,  149,
    0,    0,   99,  100,  191,  193,    0,   75,    0,    0,
    0,  333,  331,    0,    0,    0,  344,    0,    0,    0,
    0,    0,    0,  252,  251,    0,  250,  249,  284,  283,
   39,    0,   34,    0,  167,  305,  298,  306,  307,  308,
  296,    0,  346,    0,  342,  340,    0,  345,  347,  348,
  339,  350,    0,  257,    0,    0,    0,  343,  341,    0,
   40,    0,   35,    0,  297,  256,    0,    0,   41,    0,
   36,    0,    0,    0,   42,    0,   37,    0,   43,
};
#if defined(YYDESTRUCT_CALL) || defined(YYSTYPE_TOSTRING)
static const YYINT yystos[] = {                           0,
  261,  267,  276,  279,  280,  281,  282,  283,  284,  285,
  286,  287,  288,  289,  290,  291,  292,  293,  294,  295,
  296,  297,  298,  301,  302,  303,  304,  305,  307,  308,
  309,  310,  311,  312,  313,  314,  315,  316,  317,  318,
  319,  320,  321,  322,  323,  324,  325,  326,  327,  328,
  329,  330,  331,  332,  333,  334,  335,  336,  337,  338,
  339,  340,  341,  342,  343,  344,  345,  346,  347,  348,
  349,  350,  351,  352,  353,  354,  355,  356,  357,  358,
  359,  360,  361,  362,  363,  364,  365,  366,  367,  368,
  369,  370,  371,  373,  374,  375,  376,  377,  378,  386,
  425,  433,  434,  438,  460,  473,  474,  476,  477,  478,
  479,  480,  481,  482,  483,  484,  485,  486,  487,  489,
  257,  258,  259,  260,  264,  265,  266,  270,  271,  272,
  273,  274,  429,   40,  446,  447,  451,  453,  459,  461,
  256,  276,  277,  435,  475,  256,  422,  467,  435,  475,
  435,  475,  475,  447,  447,  393,  475,  488,  475,  488,
  467,  467,  467,  467,  467,  256,  258,  264,  265,  266,
  448,  456,  263,  426,  439,  441,  446,  453,  454,  455,
  439,  439,  441,  453,  475,  453,  461,  475,  490,  493,
  431,  475,  431,  439,  440,  441,  475,  268,  457,  458,
  475,  458,  475,  441,  475,  439,  467,  467,  475,  256,
  456,  475,  456,  456,  441,  440,  475,  475,  488,  475,
  488,  447,  453,  475,  423,  462,  475,  458,  475,  462,
  475,  424,  464,  427,  453,  475,  453,  467,  453,  467,
  441,  426,  453,  453,  475,  453,  475,  467,  475,  467,
  440,  475,  440,  475,  440,  475,  440,  475,  441,  475,
  462,  467,  467,  441,  475,  440,  475,  428,  475,  475,
  475,  467,  475,  423,  463,  464,  464,  421,  421,  467,
  467,  467,  447,  475,  488,  488,  475,  446,  446,  475,
  488,  475,  475,  488,  467,  463,  256,  448,  452,  475,
  372,  475,  475,  467,  467,  435,  475,  435,  475,  379,
  380,  381,  383,  384,  385,  435,  475,  275,  387,  389,
  390,  393,  395,  397,  402,  403,  404,  405,  406,  407,
  408,  409,  410,  411,  412,  413,  414,  415,  416,  417,
  418,  446,  470,  456,  475,  456,  475,  276,  474,  447,
   43,   45,   42,   47,  475,  429,  475,  475,  475,  475,
  447,  447,  447,  447,  256,  452,  452,  256,  452,  452,
  452,  475,  488,  488,  488,  488,  488,  488,  475,  488,
  475,  275,  393,  475,  475,  488,  475,  268,  440,  440,
  475,  488,  475,  475,  475,  269,  256,  488,  475,  492,
  475,  447,  447,  475,  475,  475,  440,  475,  475,  475,
  475,  488,  488,  475,  488,  475,  488,  475,  488,  475,
  475,  475,  475,  475,  475,  475,  475,  421,  446,  465,
  466,  475,  452,  452,  475,  475,  475,  475,  488,  475,
  475,  475,  475,  421,  475,  475,  447,  475,  447,  447,
  475,  446,  448,  453,  447,  488,  475,  475,  475,  475,
  488,  475,  488,  475,  475,  448,  449,  448,  450,  441,
  441,  448,  441,  475,  441,  409,  410,  411,  412,  413,
  414,  446,  446,  393,  391,  392,  398,  399,  420,  471,
  472,  390,  393,  402,  404,  446,  446,  393,  393,  393,
  475,  475,  256,   41,  447,  447,  447,  447,  442,  488,
  441,  475,  475,  442,  442,  256,  439,  442,  256,  441,
  447,  421,  436,  446,  468,  469,  441,  263,  454,  465,
  441,  446,  493,  440,  269,  443,  443,  441,  387,   64,
  444,  445,  446,  461,  475,  421,  460,  491,  494,  475,
  475,  443,  427,  467,  467,  426,  426,  475,  488,  256,
  441,  256,  439,  447,  475,  475,  475,  475,  475,  475,
  488,  475,  488,  440,  475,  447,  446,  446,  475,  382,
  475,  475,  475,  475,  475,  278,  475,  388,  388,  388,
  388,  388,  388,  388,  393,  471,  420,  471,  419,  393,
  420,  471,  393,  393,  393,  396,  471,  471,  391,  392,
  399,  400,  446,  472,  475,  441,  475,  475,  475,  475,
  475,  475,  475,  469,  475,  475,  475,  475,  444,  475,
  475,  475,  444,  427,  430,  475,  475,  394,  475,  394,
  475,  475,  475,  475,  475,  475,  466,  475,  475,  475,
  453,  453,  475,  475,  475,  475,  448,  475,  393,  391,
  399,  471,  419,  471,  420,  471,  396,  419,  471,  471,
  400,  471,  393,  256,  388,   58,  256,  444,  460,  460,
  475,  488,  475,  488,  475,  390,  392,  411,  412,  413,
  388,  388,  396,  471,  396,  396,  419,  396,  396,  396,
  396,  392,  387,  441,  453,  453,  393,  396,  396,  444,
  475,  488,  475,  488,  392,  388,  453,  453,  475,  488,
  475,  488,  453,  453,  475,  488,  475,  453,  475,
};
#endif /* YYDESTRUCT_CALL || YYSTYPE_TOSTRING */
static const YYINT yydgoto[] = {                        104,
  194,  195,  196,  509,  536,  541,  542,  177,  136,  298,
  467,  469,  137,  299,  138,  179,  180,  172,  199,  200,
  139,  105,  140,  226,  275,  233,  430,  431,  148,  525,
  526,  343,  490,  491,  106,  107,  145,  108,  109,  110,
  111,  112,  113,  114,  115,  116,  117,  118,  119,  510,
  120,  189,  548,  400,  190,  549,
};
static const YYINT yysindex[] = {                      1681,
  163,    0,    0, -253, -241, -182, -149,  250,  163,  163,
 -154, -154, -241, -241, -241, -241, -241,  822,  999,  999,
  999, 1299,  -98, -115, 1136,  332,  332, 1299,  999, -241,
 -241,  250,  827,  822,  822, 2056, 1026, -154, -154,  163,
  774,  -69,  332, -409,  250, -369,  132,  465,  465, 2056,
  113,  774,  774, -241,  250, -241, 1026, 1026, 1026, 1026,
 2056,  250, -409, -241, -241, 1299, 1026,  -86,  250,  250,
 -241,  250, -358, -369, -369, -336, -332, -241, -241, -241,
  163, -154, -293,  250, 1163, 1163, -154,  250, -154, -241,
 -358, 1075,   53,  250, -241, -241, -117, -109,   72, -135,
 1329,  827,  827,    0, -130, 1837,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  163,    0,   56,    0, -277,    0,    0,
    0,    0,    0,  250,    0,    0,    0,  250,  250,    0,
  250,    0,    0,  108,  108,    0,    0,  163,    0,  163,
  844,  844,  857,  844,  844,    0,    0,    0,    0,    0,
    0, -154,    0,    0, -293, -293,    0, -293,    0,    0,
 -293, -293,  250, -293,    0, -145, -121,    0,   94,    0,
  250,    0, -293,    0,  250, -293,    0,    0,  -99,  999,
    0,  999,    0,  250,    0, -293,  250,  250,    0,    0,
  250,    0,  -85, -222,  250,  250,    0,    0,  163,    0,
  163,   56,  250,    0,    0,  250,    0,  999,    0,  250,
    0,    0,  250,  250, -154,    0, -293,  250, -293,  250,
 -293,  250, -293,  250,    0,  250,    0,  250,    0,  250,
  250,    0,  250,    0,  250,    0,  250,    0,  450,    0,
  250,  844,  844,  250,    0,  250,    0,  250,    0,    0,
    0, -154,    0,    0,  250,  250,  250,  250, -228,  250,
  250,  163,   56,    0,  163,  163,    0,  250, 1163,    0,
  882,    0,    0,  163, -293,  250,    0,    0,  250,    0,
  250,    0,    0, -154, -154,  250,    0,  250,    0,  356,
  356, 2056, 2056,  356, 2056,  250,    0, 2056, 1340, 1163,
 -189,  368,  739, 1163, -171,    0, -168,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0, -167,    0,  250,    0,  250,    0,    0,    0,   63,
  163,  163,  163,  163,    0,    0,    0,    0,    0,    0,
  -34,  520,   56,   56,    0, -293, -293,    0, 1523, -293,
 1829,    0,  163,  235, 2056, 1102,  450, 2056,    0, 1163,
    0, 1163,  200,    0,    0,  999,    0,    0,  -58,  -58,
    0, 2056,    0,    0,    0,  670,  250, -198,    0, -195,
    0,   56,   56,    0,    0,    0,  -58,    0,    0,    0,
    0, -196, -241,    0, -241,    0, -193,    0, -191,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0, -154,
    0,    0, 1962, 1805,    0,    0,    0,    0,  163,    0,
    0,    0,    0,  250,    0,    0,   56,    0,   56,   56,
    0,  250, -154, -154,  978,  163,    0,    0,    0,    0,
 1163,    0, 1163,    0,    0,    0,  250,    0,  -13,  250,
  250,  250,  250,    0,  267, -151, -142, -136, -134, -132,
 -131, -194,    0, -235,    0,    0,    0,    0,  415, -158,
    0, -128,  453, -126, -125, -175,    0, -235, -235,  428,
    0,    0,    0,    0,  172,  172,    0,    0,  250, 2056,
  250,    0,    0,  250,  250,    0,  250,  250,    0,  250,
   56,    0,    0,    0, -140,    0,    0,    0,    0, -154,
  250,    0,    0,  250,  670,  250,  250,  250,  670, -138,
 -218,    0,    0,    0,    0,  250, -118,  250, -116,    0,
    0,  250,  250,  250,  250,  250,  250,    0,  450,    0,
  250,    0,  250,   56,    0,    0,    0,    0,    0,    0,
  476,    0,  476,  250,    0,   56,  250,  250,    0,  356,
    0,    0,    0,    0,    0,  250,    0,    0,    0,    0,
    0,    0,    0, -120, -270,    0, -235,    0, -127, -235,
  519, -389, -235, -235,  478, -106,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0, -139,    0,
    0,    0, -244,  236,  626,    0,    0, -195,    0, -195,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
 -154, -154,    0,    0,    0,    0,  250,    0,  589,  -91,
  -84,    0,    0,  -93, -235,  -83,    0, -371,  -79,  -73,
  -71,  -62,  -81,    0,    0, 1980,    0,    0,    0,    0,
    0,  476,    0,  476,    0,    0,    0,    0,    0,    0,
    0,  -66,    0,  -61,    0,    0,  -59,    0,    0,    0,
    0,    0,  670,    0, -154, -154,  -53,    0,    0, -346,
    0,  476,    0,  476,    0,    0, -154, -154,    0,  476,
    0,  476, -154,  250,    0,  476,    0,  250,    0,
};
static const YYINT yyrindex[] = {                         0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  353,  353,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0, 2002, 2002,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  353,  353,    0,
    0,    0, 2002,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  298,    0,    0,    0,    0,    0,    0,    0,
    0,  353,  353,    0,    0,    0, 1084,    0,  353,    0,
  298,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  139,    0,    0,    0,    0,  341,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  353,    0,    0,  417, 2074,    0, 1118,    0,    0,
  699, 2074,    0, 1541,    0,    0,    0,    0,    0,    0,
    0,    0, 2020,    0,    0, 1048,    0,    0, 2038,    0,
    0,    0,    0,    0,    0, 2074,    0,    0,    0, 1335,
    0,    0,    0,  -78,  -80,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  -76,    0, -227,    0, -227,    0,
  -37,    0,  -37,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  353,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  353,    0, 1547,    0,    0,    0,
    0,    0,    0, 1541, 1541,    0,    0,    0,    0,  376,
   99,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  241,    0,    0,    0,  310,    0,  393,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  403,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
 1500,    0,    0,    0,    0, 1500, 1500, 1175,    0, 1500,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,  391,  391,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  391,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  699,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  919,  919,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  581,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  908,  945,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  699,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  548,    0,  553,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  584,    0,    0,    0,    0,  612,    0,
    0,    0,    0,    0,    0,  637,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,  618,    0,
    0,    0,    0,    0,    0,    0,    0,  649,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  919,  919,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  919,  919,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  919,  919,    0,    0,
    0,    0,  919,    0,    0,    0,    0,    0,    0,
};
#if YYBTYACC
static const YYINT yycindex[] = {                         0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,
};
#endif
static const YYINT yygindex[] = {                         0,
   48,   13,  286, -170, -350, -347,    0,  688,  125,   10,
    0,    0,    0,  871,  704, -301,    0,  328,    0,  106,
    0, -390,  -19,   46,  262,   40,  -17, -169,  785,    0,
 -133,    0,  319, -102,    0,  288,   -6,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  401,
    0,    0,    0,    0,   17,    0,
};
#define YYTABLESIZE 2500
static const YYINT yytable[] = {                        150,
  152,  153,  141,  187,  157,  159,  667,  353,  351,  547,
  352,  674,  354,  225,  146,  185,  188,  192,  197,  201,
  203,  205,  142,  143,  696,  209,  212,  171,  232,  668,
  217,  218,  220,  397,  224,  227,  229,  141,  231,  537,
  236,  716,  171,  171,  171,  245,  247,  697,  249,  216,
  252,  254,  256,  258,  232,  260,  552,  142,  143,  265,
  267,  269,  270,  271,  274,  273,  175,  181,  182,  251,
  253,  255,  257,  141,  529,  284,  206,  287,  529,  266,
  290,  292,  293,  635,  278,  300,  302,  303,  279,  230,
  307,  309,  317,  142,  143,  345,  347,  353,  351,  156,
  352,  141,  354,  504,  353,  351,  141,  352,  261,  354,
  141,  171,  171,  276,  277,  141,  121,  122,  123,  124,
  660,  142,  143,  125,  126,  127,  142,  143,  661,  355,
  142,  143,  202,  154,  155,  142,  143,  357,  141,  318,
  141,  358,  359,  675,  360,  348,  141,  134,  228,  353,
  351,  356,  352,  382,  354,  485,  486,  141,  142,  143,
  142,  143,  487,  488,  222,  372,  142,  143,  388,  141,
  156,  128,  129,  130,  131,  132,  379,  142,  143,  381,
  147,  144,  384,  396,  385,  635,  141,  629,  387,  142,
  143,  633,  444,  594,  232,  514,  515,  391,  595,  518,
  393,  394,  134,  484,  395,  283,  142,  143,  399,  401,
  535,  635,  389,  353,  390,  404,  405,  605,  354,  406,
  606,  498,  546,  408,  499,  500,  409,  410,  411,  101,
  553,  414,  556,  416,  557,  418,  588,  420,  156,  421,
  407,  422,  141,  423,  424,  589,  425,  679,  426,  680,
  427,  590,  149,  591,  432,  592,  593,  435,  350,  436,
  599,  437,  142,  143,  600,  438,  603,  604,  440,  441,
  442,  443,  659,  445,  446,  638,  448,  640,  361,  362,
  522,  451,  363,  356,  364,  151,  673,  678,  634,  457,
  635,  663,  458,  676,  459,  523,  691,  460,  462,  464,
  453,  465,  693,  692,  176,  176,  176,  183,  141,  474,
  702,  141,  695,  204,  176,  191,  698,  306,  503,  466,
  468,  215,  699,  472,  700,  308,  707,  141,  142,  143,
  133,  142,  143,  701,  708,  241,  709,  501,  715,  502,
    1,  268,  232,  402,   76,  403,  259,  142,  143,  141,
  232,  264,  296,  225,  220,  710,  512,  513,  156,  530,
  211,  213,  214,  187,  121,  122,  123,  124,  580,  142,
  143,  125,  126,  127,  220,  220,  544,  128,  129,  130,
  131,  132,  128,  129,  130,  131,  132,  141,  232,  647,
  545,  624,  232,  349,  309,  550,  551,  614,  534,  533,
    0,  128,  129,  130,  131,  132,  447,  142,  143,  449,
  450,  158,  160,    0,  309,  309,  517,    0,  455,  121,
  122,  123,  124,  558,  301,    0,  125,  126,  127,  344,
  346,    0,  128,  129,  130,  131,  132,  565,  219,  221,
  566,    0,  567,  568,    0,  569,  570,  572,  575,    0,
  310,  311,  312,    0,  313,  314,  315,    0,    0,    0,
  579,    0,  581,  582,  583,  584,  585,  574,  587,  128,
  129,  130,  131,  132,    0,  505,  506,  507,  508,    0,
  220,  563,  285,  286,    0,    0,  383,  291,    0,  294,
    0,  121,  122,  123,  124,    0,  310,  521,  125,  126,
  127,    0,  615,    0,  617,  141,  316,  618,  619,    0,
  620,  621,    0,  622,  623,  544,  310,  310,  625,  544,
    0,    0,  141,  626,  627,  142,  143,  628,    0,  630,
  631,  632,  309,    0,  636,    0,  133,    0,  242,  637,
    0,  639,  142,  143,  586,  641,  642,  643,  644,  645,
  646,    0,    0,  202,  648,    0,  649,  650,  234,    0,
    0,  353,  351,  564,  352,  311,  354,  653,    0,  654,
  655,  656,  373,  202,  202,  374,  375,    0,  376,  658,
  576,  377,  378,    0,  380,  311,  311,  141,    0,  657,
    0,  133,    0,  386,    0,    0,  375,  470,  471,  198,
  473,    0,    0,  475,    0,    0,  392,  142,  143,  232,
  232,  232,  232,  167,  398,  544,  232,  232,  232,  168,
  169,  170,  232,  232,  232,  232,  232,    0,  133,    0,
    0,  274,    0,    0,  310,  412,    0,  413,    0,  415,
    0,  417,    0,  419,  681,  683,  248,  511,  313,    0,
  685,  274,  274,    0,  176,  522,  520,    0,  290,    0,
  527,    0,    0,  531,    0,    0,  248,  248,  313,  313,
  523,    0,  439,  232,  232,  232,  232,  538,  290,  290,
  232,  232,  232,  544,  121,  122,  123,  124,  135,  540,
    0,  125,  126,  127,    0,  456,  135,  135,  711,  713,
    0,    0,    0,  311,  461,  463,  121,  122,  123,  124,
  719,  721,    0,  125,  126,  127,  725,  727,  561,  176,
  146,  729,  178,  178,  178,  184,  186,  135,  178,    0,
    0,  184,  178,  540,  128,  129,  130,  131,  132,  184,
  178,    0,    0,    0,  223,  128,  129,  130,  131,  132,
  235,  237,  239,  184,  243,  244,  246,    0,  485,  486,
  178,  178,  178,  178,  184,  487,  488,    0,  135,  184,
  178,    0,  288,  289,    0,    0,  121,  122,  123,  124,
    0,  232,    0,  125,  126,  127,  313,  489,  342,  128,
  129,  130,  131,  132,    0,  616,  290,  161,  162,  163,
  164,  165,  596,  287,    0,  485,  486,  598,  288,    0,
    0,  602,  487,  488,  207,  208,  607,  608,  609,  610,
    0,  135,    0,  287,  287,  487,  611,  612,  288,  288,
  559,    0,  238,  240,  597,    0,  334,  232,  248,  295,
  250,  135,  135,  485,  486,  135,    0,  135,  262,  263,
  487,  488,  232,  571,  573,  272,  334,  334,    0,  295,
  295,    0,  280,  281,  282,    0,    0,  330,  485,  486,
  428,    0,  601,  247,  295,  487,  488,  671,    0,  304,
  305,  677,  121,  122,  123,  124,  147,  330,  330,  125,
  126,  127,  349,  247,  247,  128,  129,  130,  131,  132,
    0,    0,    0,  178,  285,  178,  135,    0,  135,  485,
  486,    0,  349,  349,    0,  662,  487,  488,  664,  666,
    0,  669,  670,  672,  285,  285,  121,  122,  123,  124,
  559,  178,    0,  125,  126,  127,    0,    0,  665,  128,
  129,  130,  131,  132,    0,  174,  429,  240,  240,    0,
  240,    0,  240,    0,    0,  232,  232,  232,  232,    0,
    0,  704,  232,  232,  232,    0,    0,    0,    0,  135,
    0,    0,  135,  135,  334,    0,  452,  295,  686,    0,
  687,  135,    0,  694,  241,  241,    0,  241,    0,  241,
    0,    0,    0,    0,  454,  121,  122,  123,  124,  688,
  689,  690,  125,  126,  127,  330,  482,  483,    0,    0,
  496,  497,  539,    0,    0,  184,  184,    0,  184,  353,
  351,  184,  352,    0,  354,    0,    0,    0,    0,  141,
  349,  366,  367,  369,  370,  371,    0,    0,  135,  135,
  135,  135,  285,  128,  129,  130,  131,  132,    0,  142,
  143,  682,  684,    0,  133,    0,  539,    0,    0,    0,
  135,  524,    0,    0,  429,  184,    0,    0,    0,  532,
    0,    0,  178,    0,  184,    0,    0,  166,  184,  167,
    0,  184,  210,  543,  167,  168,  169,  170,    0,  178,
  168,  169,  170,    0,    0,  184,    0,    0,  133,  365,
    0,  167,  142,  143,    0,  712,  714,  168,  169,  170,
    0,    0,  368,    0,  167,    0,    0,  720,  722,  232,
  168,  169,  170,  726,    0,    0,  135,    0,  492,    0,
    0,  493,  433,  434,    0,    0,  184,  178,    0,  167,
  494,    0,  495,  135,    0,  168,  169,  170,  577,    0,
  578,  128,  129,  130,  131,  132,    0,    0,  178,    0,
    0,    0,    0,  240,  240,  240,  240,  240,    0,    0,
  240,  240,  240,  240,  177,    0,    0,  240,  240,  240,
  240,  240,    0,  240,  240,    0,    0,  613,  232,  232,
  232,  232,  232,    0,    0,    0,    0,  554,    0,  555,
  241,  241,  241,  241,  241,    0,    0,  241,  241,  241,
  241,    0,  524,  184,  241,  241,  241,  241,  241,    0,
  241,  241,  543,    0,    0,    0,  543,    0,    0,    0,
    0,    0,    0,  141,  121,  122,  123,  124,    0,    0,
  173,  125,  126,  127,    0,    0,  429,  128,  129,  130,
  131,  132,    0,  142,  143,  121,  122,  123,  124,    0,
    0,  173,  125,  126,  127,    0,    0,    0,  128,  129,
  130,  131,  132,    0,  651,    0,  652,    0,    0,    0,
    0,  141,  121,  122,  123,  124,    0,    0,  173,  125,
  126,  127,    0,    0,    0,  128,  129,  130,  131,  132,
  240,  142,  143,  222,  232,  232,  232,  232,    0,    0,
    0,  232,  232,  232,    0,    0,  222,  232,  232,  232,
  232,  232,  543,  222,  222,    0,    0,    0,    0,    0,
  297,    0,  167,  240,    8,    0,  240,  241,  168,  169,
  170,  232,    0,    0,    0,    0,    0,  232,  232,  232,
  142,  143,    0,  232,  232,  232,  232,  232,  121,  122,
  123,  124,    0,    0,  528,  125,  126,  127,    0,    0,
  241,    0,    0,  241,  232,  232,  232,  232,    0,  184,
  232,  232,  232,  232,    0,  705,    0,  706,    0,    0,
  543,  141,  121,  122,  123,  124,    0,    0,  173,  125,
  126,  127,    0,  174,    0,  128,  129,  130,  131,  132,
    0,  142,  143,    0,    0,  717,    0,  718,    0,  121,
  122,  123,  124,  723,  174,  724,  125,  126,  127,  728,
  207,  207,  207,  207,  207,  177,    0,  207,  207,  207,
  207,  177,    0,    0,  207,  207,  207,  207,  207,    0,
    0,  174,    0,  177,  177,  177,  177,  177,  177,  177,
  177,  177,  177,  177,  177,  177,  177,  177,  177,  177,
  177,  177,  177,  232,    0,  177,  177,  177,  177,  177,
    0,  177,  177,  177,  177,  177,  177,  177,  177,  177,
  177,  177,  177,  177,  177,  177,  177,  177,  177,  177,
  177,  177,  177,  177,  177,  177,  177,  177,  177,  177,
  177,  177,  177,  177,  177,  177,  177,  177,  177,  177,
  177,  177,  177,  177,  177,  177,  177,  177,  177,  177,
  177,  177,  177,  177,  177,  177,  177,  177,  177,  177,
  177,  177,  177,  177,  177,  177,    8,  177,  177,  177,
  177,  177,  177,    0,  141,  121,  122,  123,  124,    0,
  177,  174,  125,  126,  127,    0,  193,    0,  128,  129,
  130,  131,  132,    0,  142,  143,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  121,  122,  123,  124,    0,
  218,    0,  125,  126,  127,    8,  121,  122,  123,  124,
  207,    8,    0,  125,  126,  127,    0,  177,  177,    0,
  218,  218,    0,    8,    8,    8,    8,    8,    8,    8,
    8,    8,    8,    8,    8,    8,    8,    8,    8,    8,
    8,    8,    8,    0,    0,    8,    8,    8,    8,    8,
    0,    8,    8,    8,    8,    8,    8,    8,    8,    8,
    8,    8,    8,    8,    8,    8,    8,    8,    8,    8,
    8,    8,    8,    8,    8,    8,    8,    8,    8,    8,
    8,    8,    8,    8,    8,    8,    8,    8,    8,    8,
    8,    8,    8,    8,    8,    8,    8,    8,    8,    8,
    8,    8,    8,    8,    8,    8,    8,    8,    8,    8,
    8,    8,    8,    8,    8,    8,    0,    8,    8,    8,
    8,    8,    8,    0,    0,  319,    0,  320,  321,    0,
    8,  322,    0,  323,  174,  324,    0,    0,    0,    0,
  325,  326,  327,  328,  329,  330,  331,  332,  333,  334,
  335,  336,  337,  338,  339,  340,  341,    0,  476,  477,
  478,  479,  480,  481,    0,  227,  232,  232,  232,  232,
    0,    0,    0,  232,  232,  232,    0,    8,    8,  232,
  232,  232,  232,  232,    0,  227,  227,    0,  516,  121,
  122,  123,  124,    0,    0,  173,  125,  126,  127,    0,
    0,    0,  128,  129,  130,  131,  132,  232,  232,  232,
  232,    0,  207,    0,  232,  232,  232,    8,    0,    0,
    0,    0,    0,    8,    0,    0,    0,    0,    0,    0,
    0,    0,  207,  207,    0,    8,    8,    8,    8,    8,
    8,    8,    8,    8,    8,    8,    8,    8,    8,    8,
    8,    8,    8,    8,    8,    0,    0,    8,    8,    8,
    8,    8,    0,    8,    8,    8,    8,    8,    8,    8,
    8,    8,    8,    8,    8,    8,    8,    8,    8,    8,
    8,    8,    8,    8,    8,    8,    8,    8,    8,    8,
    8,    8,    8,    8,    8,    8,    8,    8,    8,    8,
    8,    8,    8,    8,    8,    8,    8,    8,    8,    8,
    8,    8,    8,    8,    8,    8,    8,    8,    8,    8,
    8,    8,    8,    8,    8,    8,    8,    8,    0,    8,
    8,    8,    8,    8,    8,  232,    0,    0,    0,    0,
    0,    0,    8,    0,    0,    0,    0,    0,    0,    0,
    0,    1,    0,    0,    0,    0,    0,    2,  174,    0,
    0,    0,    0,    0,    0,    0,    3,    0,    0,    4,
    5,    6,    7,    8,    9,   10,   11,   12,   13,   14,
   15,   16,   17,   18,   19,   20,   21,   22,   23,    8,
    8,   24,   25,   26,   27,   28,    0,   29,   30,   31,
   32,   33,   34,   35,   36,   37,   38,   39,   40,   41,
   42,   43,   44,   45,   46,   47,   48,   49,   50,   51,
   52,   53,   54,   55,   56,   57,   58,   59,   60,   61,
   62,   63,   64,   65,   66,   67,   68,   69,   70,   71,
   72,   73,   74,   75,   76,   77,   78,   79,   80,   81,
   82,   83,   84,   85,   86,   87,   88,   89,   90,   91,
   92,   93,    0,   94,   95,   96,   97,   98,   99,    0,
  562,  121,  122,  123,  124,    0,  100,  173,  125,  126,
  127,    0,    0,    0,  128,  129,  130,  131,  132,    0,
    0,    0,    0,    0,  519,  121,  122,  123,  124,    0,
    0,    0,  125,  126,  127,    0,    0,    1,  128,  129,
  130,  131,  132,    2,    0,  101,    0,    0,    0,    0,
    0,    0,    0,  102,  103,    4,    5,    6,    7,    8,
    9,   10,   11,   12,   13,   14,   15,   16,   17,   18,
   19,   20,   21,   22,   23,    0,    0,   24,   25,   26,
   27,   28,    0,   29,   30,   31,   32,   33,   34,   35,
   36,   37,   38,   39,   40,   41,   42,   43,   44,   45,
   46,   47,   48,   49,   50,   51,   52,   53,   54,   55,
   56,   57,   58,   59,   60,   61,   62,   63,   64,   65,
   66,   67,   68,   69,   70,   71,   72,   73,   74,   75,
   76,   77,   78,   79,   80,   81,   82,   83,   84,   85,
   86,   87,   88,   89,   90,   91,   92,   93,    0,   94,
   95,   96,   97,   98,   99,    0,    0,  560,  121,  122,
  123,  124,  100,    0,    0,  125,  126,  127,    0,    0,
  174,  128,  129,  130,  131,  132,  121,  122,  123,  124,
    0,    0,    0,  125,  126,  127,    0,    0,    0,  128,
  129,  130,  131,  132,  174,    0,    0,    0,  211,  211,
  211,  211,    0,    0,  211,  211,  211,  211,    0,  102,
  103,  211,  211,  211,  211,  211,  232,  232,  232,  232,
    0,    0,  232,  232,  232,  232,    0,    0,    0,  232,
  232,  232,  232,  232,  210,  210,  210,  210,    0,    0,
  210,  210,  210,  210,    0,    0,    0,  210,  210,  210,
  210,  210,  121,  122,  123,  124,    0,    0,    0,  125,
  126,  127,    0,    0,    0,  128,  129,  130,  131,  132,
  232,  232,  232,  232,    0,    0,    0,  232,  232,  232,
    0,    0,    0,  232,  232,  232,  232,  232,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  703,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  174,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  174,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  211,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  232,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  210,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  174,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  232,
};
static const YYINT yycheck[] = {                          6,
    7,    8,  256,   23,   11,   12,  396,   42,   43,  400,
   45,  256,   47,  423,  256,   22,   23,   24,   25,   26,
   27,   28,  276,  277,  396,   32,   33,   18,  256,  419,
   37,   38,   39,  256,   41,   42,   43,  256,   45,  390,
   47,  388,   33,   34,   35,   52,   53,  419,   55,   37,
   57,   58,   59,   60,  424,   62,  407,  276,  277,   66,
   67,   68,   69,   70,  423,   72,   19,   20,   21,   57,
   58,   59,   60,  256,  376,   82,   29,   84,  380,   67,
   87,   88,   89,  430,  421,   92,   93,   94,  421,   44,
   97,   98,   99,  276,  277,  102,  103,   42,   43,  393,
   45,  256,   47,   41,   42,   43,  256,   45,   63,   47,
  256,  102,  103,   74,   75,  256,  257,  258,  259,  260,
  391,  276,  277,  264,  265,  266,  276,  277,  399,  136,
  276,  277,   27,    9,   10,  276,  277,  144,  256,  275,
  256,  148,  149,  388,  151,  276,  256,   40,   43,   42,
   43,  429,   45,  275,   47,  391,  392,  256,  276,  277,
  276,  277,  398,  399,   40,  172,  276,  277,  268,  256,
  393,  270,  271,  272,  273,  274,  183,  276,  277,  186,
  422,  435,  189,  269,  191,  430,  256,  535,  195,  276,
  277,  539,  421,  388,  422,  366,  367,  204,  393,  370,
  207,  208,   40,  393,  211,   81,  276,  277,  215,  216,
  269,  430,  200,   42,  202,  222,  223,  393,   47,  226,
  396,  393,  421,  230,  393,  393,  233,  234,  235,  425,
  427,  238,  426,  240,  426,  242,  388,  244,  393,  246,
  228,  248,  256,  250,  251,  388,  253,  638,  255,  640,
  257,  388,  435,  388,  261,  388,  388,  264,  134,  266,
  419,  268,  276,  277,  393,  272,  393,  393,  275,  276,
  277,  278,  393,  280,  281,  394,  283,  394,  154,  155,
  421,  288,  158,  429,  160,  435,  393,  635,  427,  296,
  430,  419,  299,   58,  301,  436,  388,  304,  305,  306,
  291,  308,  396,  388,   19,   20,   21,   22,  256,  316,
  392,  256,  396,   28,   29,  431,  396,  435,  256,  310,
  311,   36,  396,  314,  396,  435,  393,  256,  276,  277,
  429,  276,  277,  396,  396,   50,  396,  344,  392,  346,
    0,  428,  421,  219,  425,  221,   61,  276,  277,  256,
  427,   66,   91,  423,  256,  703,  363,  364,  393,  377,
   33,   34,   35,  383,  257,  258,  259,  260,  382,  276,
  277,  264,  265,  266,  276,  277,  396,  270,  271,  272,
  273,  274,  270,  271,  272,  273,  274,  256,  426,  559,
  397,  525,   40,  106,  256,  402,  403,  500,  386,  383,
   -1,  270,  271,  272,  273,  274,  282,  276,  277,  285,
  286,   11,   12,   -1,  276,  277,  369,   -1,  294,  257,
  258,  259,  260,  430,  372,   -1,  264,  265,  266,  102,
  103,   -1,  270,  271,  272,  273,  274,  444,   38,   39,
  447,   -1,  449,  450,   -1,  452,  453,  454,  455,   -1,
  379,  380,  381,   -1,  383,  384,  385,   -1,   -1,   -1,
  467,   -1,  469,  470,  471,  472,  473,  455,  475,  270,
  271,  272,  273,  274,   -1,  351,  352,  353,  354,   -1,
  382,  434,   82,   83,   -1,   -1,  393,   87,   -1,   89,
   -1,  257,  258,  259,  260,   -1,  256,  373,  264,  265,
  266,   -1,  509,   -1,  511,  256,  435,  514,  515,   -1,
  517,  518,   -1,  520,  521,  535,  276,  277,  525,  539,
   -1,   -1,  256,  530,  531,  276,  277,  534,   -1,  536,
  537,  538,  394,   -1,  541,   -1,  429,   -1,  426,  546,
   -1,  548,  276,  277,  278,  552,  553,  554,  555,  556,
  557,   -1,   -1,  256,  561,   -1,  563,  564,  427,   -1,
   -1,   42,   43,  439,   45,  256,   47,  574,   -1,  576,
  577,  578,  172,  276,  277,  175,  176,   -1,  178,  586,
  456,  181,  182,   -1,  184,  276,  277,  256,   -1,  580,
   -1,  429,   -1,  193,   -1,   -1,  196,  312,  313,  268,
  315,   -1,   -1,  318,   -1,   -1,  206,  276,  277,  257,
  258,  259,  260,  258,  214,  635,  264,  265,  266,  264,
  265,  266,  270,  271,  272,  273,  274,   -1,  429,   -1,
   -1,  256,   -1,   -1,  394,  235,   -1,  237,   -1,  239,
   -1,  241,   -1,  243,  651,  652,  256,  362,  256,   -1,
  657,  276,  277,   -1,  369,  421,  371,   -1,  256,   -1,
  375,   -1,   -1,  378,   -1,   -1,  276,  277,  276,  277,
  436,   -1,  272,  257,  258,  259,  260,  392,  276,  277,
  264,  265,  266,  703,  257,  258,  259,  260,    1,   64,
   -1,  264,  265,  266,   -1,  295,    9,   10,  705,  706,
   -1,   -1,   -1,  394,  304,  305,  257,  258,  259,  260,
  717,  718,   -1,  264,  265,  266,  723,  724,  433,  434,
  256,  728,   19,   20,   21,   22,   23,   40,   25,   -1,
   -1,   28,   29,   64,  270,  271,  272,  273,  274,   36,
   37,   -1,   -1,   -1,   41,  270,  271,  272,  273,  274,
   47,   48,   49,   50,   51,   52,   53,   -1,  391,  392,
   57,   58,   59,   60,   61,  398,  399,   -1,   81,   66,
   67,   -1,   85,   86,   -1,   -1,  257,  258,  259,  260,
   -1,  429,   -1,  264,  265,  266,  394,  420,  101,  270,
  271,  272,  273,  274,   -1,  510,  394,   13,   14,   15,
   16,   17,  484,  256,   -1,  391,  392,  489,  256,   -1,
   -1,  493,  398,  399,   30,   31,  498,  499,  391,  392,
   -1,  134,   -1,  276,  277,  398,  399,  400,  276,  277,
  430,   -1,   48,   49,  420,   -1,  256,  421,   54,  256,
   56,  154,  155,  391,  392,  158,   -1,  160,   64,   65,
  398,  399,  436,  453,  454,   71,  276,  277,   -1,  276,
  277,   -1,   78,   79,   80,   -1,   -1,  256,  391,  392,
  421,   -1,  420,  256,   90,  398,  399,  400,   -1,   95,
   96,  256,  257,  258,  259,  260,  422,  276,  277,  264,
  265,  266,  256,  276,  277,  270,  271,  272,  273,  274,
   -1,   -1,   -1,  200,  256,  202,  219,   -1,  221,  391,
  392,   -1,  276,  277,   -1,  597,  398,  399,  600,  601,
   -1,  603,  604,  605,  276,  277,  257,  258,  259,  260,
  530,  228,   -1,  264,  265,  266,   -1,   -1,  420,  270,
  271,  272,  273,  274,   -1,  426,  259,   40,   41,   -1,
   43,   -1,   45,   -1,   -1,  257,  258,  259,  260,   -1,
   -1,  676,  264,  265,  266,   -1,   -1,   -1,   -1,  282,
   -1,   -1,  285,  286,  394,   -1,  289,  394,  390,   -1,
  392,  294,   -1,  665,   40,   41,   -1,   43,   -1,   45,
   -1,   -1,   -1,   -1,  291,  257,  258,  259,  260,  411,
  412,  413,  264,  265,  266,  394,  319,  320,   -1,   -1,
  323,  324,  387,   -1,   -1,  312,  313,   -1,  315,   42,
   43,  318,   45,   -1,   47,   -1,   -1,   -1,   -1,  256,
  394,  161,  162,  163,  164,  165,   -1,   -1,  351,  352,
  353,  354,  394,  270,  271,  272,  273,  274,   -1,  276,
  277,  651,  652,   -1,  429,   -1,  387,   -1,   -1,   -1,
  373,  374,   -1,   -1,  377,  362,   -1,   -1,   -1,  382,
   -1,   -1,  369,   -1,  371,   -1,   -1,  256,  375,  258,
   -1,  378,  256,  396,  258,  264,  265,  266,   -1,  386,
  264,  265,  266,   -1,   -1,  392,   -1,   -1,  429,  256,
   -1,  258,  276,  277,   -1,  705,  706,  264,  265,  266,
   -1,   -1,  256,   -1,  258,   -1,   -1,  717,  718,  421,
  264,  265,  266,  723,   -1,   -1,  439,   -1,  390,   -1,
   -1,  393,  262,  263,   -1,   -1,  433,  434,   -1,  258,
  402,   -1,  404,  456,   -1,  264,  265,  266,  461,   -1,
  463,  270,  271,  272,  273,  274,   -1,   -1,  455,   -1,
   -1,   -1,   -1,  256,  257,  258,  259,  260,   -1,   -1,
  263,  264,  265,  266,    0,   -1,   -1,  270,  271,  272,
  273,  274,   -1,  276,  277,   -1,   -1,  500,  270,  271,
  272,  273,  274,   -1,   -1,   -1,   -1,  413,   -1,  415,
  256,  257,  258,  259,  260,   -1,   -1,  263,  264,  265,
  266,   -1,  525,  510,  270,  271,  272,  273,  274,   -1,
  276,  277,  535,   -1,   -1,   -1,  539,   -1,   -1,   -1,
   -1,   -1,   -1,  256,  257,  258,  259,  260,   -1,   -1,
  263,  264,  265,  266,   -1,   -1,  559,  270,  271,  272,
  273,  274,   -1,  276,  277,  257,  258,  259,  260,   -1,
   -1,  263,  264,  265,  266,   -1,   -1,   -1,  270,  271,
  272,  273,  274,   -1,  571,   -1,  573,   -1,   -1,   -1,
   -1,  256,  257,  258,  259,  260,   -1,   -1,  263,  264,
  265,  266,   -1,   -1,   -1,  270,  271,  272,  273,  274,
  393,  276,  277,  256,  257,  258,  259,  260,   -1,   -1,
   -1,  264,  265,  266,   -1,   -1,  269,  270,  271,  272,
  273,  274,  635,  276,  277,   -1,   -1,   -1,   -1,   -1,
  256,   -1,  258,  426,    0,   -1,  429,  393,  264,  265,
  266,  258,   -1,   -1,   -1,   -1,   -1,  264,  265,  266,
  276,  277,   -1,  270,  271,  272,  273,  274,  257,  258,
  259,  260,   -1,   -1,  263,  264,  265,  266,   -1,   -1,
  426,   -1,   -1,  429,  257,  258,  259,  260,   -1,  676,
  263,  264,  265,  266,   -1,  682,   -1,  684,   -1,   -1,
  703,  256,  257,  258,  259,  260,   -1,   -1,  263,  264,
  265,  266,   -1,  426,   -1,  270,  271,  272,  273,  274,
   -1,  276,  277,   -1,   -1,  712,   -1,  714,   -1,  257,
  258,  259,  260,  720,  426,  722,  264,  265,  266,  726,
  256,  257,  258,  259,  260,  261,   -1,  263,  264,  265,
  266,  267,   -1,   -1,  270,  271,  272,  273,  274,   -1,
   -1,  426,   -1,  279,  280,  281,  282,  283,  284,  285,
  286,  287,  288,  289,  290,  291,  292,  293,  294,  295,
  296,  297,  298,  426,   -1,  301,  302,  303,  304,  305,
   -1,  307,  308,  309,  310,  311,  312,  313,  314,  315,
  316,  317,  318,  319,  320,  321,  322,  323,  324,  325,
  326,  327,  328,  329,  330,  331,  332,  333,  334,  335,
  336,  337,  338,  339,  340,  341,  342,  343,  344,  345,
  346,  347,  348,  349,  350,  351,  352,  353,  354,  355,
  356,  357,  358,  359,  360,  361,  362,  363,  364,  365,
  366,  367,  368,  369,  370,  371,    0,  373,  374,  375,
  376,  377,  378,   -1,  256,  257,  258,  259,  260,   -1,
  386,  426,  264,  265,  266,   -1,  431,   -1,  270,  271,
  272,  273,  274,   -1,  276,  277,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  257,  258,  259,  260,   -1,
  256,   -1,  264,  265,  266,  261,  257,  258,  259,  260,
  426,  267,   -1,  264,  265,  266,   -1,  433,  434,   -1,
  276,  277,   -1,  279,  280,  281,  282,  283,  284,  285,
  286,  287,  288,  289,  290,  291,  292,  293,  294,  295,
  296,  297,  298,   -1,   -1,  301,  302,  303,  304,  305,
   -1,  307,  308,  309,  310,  311,  312,  313,  314,  315,
  316,  317,  318,  319,  320,  321,  322,  323,  324,  325,
  326,  327,  328,  329,  330,  331,  332,  333,  334,  335,
  336,  337,  338,  339,  340,  341,  342,  343,  344,  345,
  346,  347,  348,  349,  350,  351,  352,  353,  354,  355,
  356,  357,  358,  359,  360,  361,  362,  363,  364,  365,
  366,  367,  368,  369,  370,  371,   -1,  373,  374,  375,
  376,  377,  378,   -1,   -1,  387,   -1,  389,  390,   -1,
  386,  393,   -1,  395,  426,  397,   -1,   -1,   -1,   -1,
  402,  403,  404,  405,  406,  407,  408,  409,  410,  411,
  412,  413,  414,  415,  416,  417,  418,   -1,  409,  410,
  411,  412,  413,  414,   -1,  256,  257,  258,  259,  260,
   -1,   -1,   -1,  264,  265,  266,   -1,  433,  434,  270,
  271,  272,  273,  274,   -1,  276,  277,   -1,  256,  257,
  258,  259,  260,   -1,   -1,  263,  264,  265,  266,   -1,
   -1,   -1,  270,  271,  272,  273,  274,  257,  258,  259,
  260,   -1,  256,   -1,  264,  265,  266,  261,   -1,   -1,
   -1,   -1,   -1,  267,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  276,  277,   -1,  279,  280,  281,  282,  283,
  284,  285,  286,  287,  288,  289,  290,  291,  292,  293,
  294,  295,  296,  297,  298,   -1,   -1,  301,  302,  303,
  304,  305,   -1,  307,  308,  309,  310,  311,  312,  313,
  314,  315,  316,  317,  318,  319,  320,  321,  322,  323,
  324,  325,  326,  327,  328,  329,  330,  331,  332,  333,
  334,  335,  336,  337,  338,  339,  340,  341,  342,  343,
  344,  345,  346,  347,  348,  349,  350,  351,  352,  353,
  354,  355,  356,  357,  358,  359,  360,  361,  362,  363,
  364,  365,  366,  367,  368,  369,  370,  371,   -1,  373,
  374,  375,  376,  377,  378,  426,   -1,   -1,   -1,   -1,
   -1,   -1,  386,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  261,   -1,   -1,   -1,   -1,   -1,  267,  426,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  276,   -1,   -1,  279,
  280,  281,  282,  283,  284,  285,  286,  287,  288,  289,
  290,  291,  292,  293,  294,  295,  296,  297,  298,  433,
  434,  301,  302,  303,  304,  305,   -1,  307,  308,  309,
  310,  311,  312,  313,  314,  315,  316,  317,  318,  319,
  320,  321,  322,  323,  324,  325,  326,  327,  328,  329,
  330,  331,  332,  333,  334,  335,  336,  337,  338,  339,
  340,  341,  342,  343,  344,  345,  346,  347,  348,  349,
  350,  351,  352,  353,  354,  355,  356,  357,  358,  359,
  360,  361,  362,  363,  364,  365,  366,  367,  368,  369,
  370,  371,   -1,  373,  374,  375,  376,  377,  378,   -1,
  256,  257,  258,  259,  260,   -1,  386,  263,  264,  265,
  266,   -1,   -1,   -1,  270,  271,  272,  273,  274,   -1,
   -1,   -1,   -1,   -1,  256,  257,  258,  259,  260,   -1,
   -1,   -1,  264,  265,  266,   -1,   -1,  261,  270,  271,
  272,  273,  274,  267,   -1,  425,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  433,  434,  279,  280,  281,  282,  283,
  284,  285,  286,  287,  288,  289,  290,  291,  292,  293,
  294,  295,  296,  297,  298,   -1,   -1,  301,  302,  303,
  304,  305,   -1,  307,  308,  309,  310,  311,  312,  313,
  314,  315,  316,  317,  318,  319,  320,  321,  322,  323,
  324,  325,  326,  327,  328,  329,  330,  331,  332,  333,
  334,  335,  336,  337,  338,  339,  340,  341,  342,  343,
  344,  345,  346,  347,  348,  349,  350,  351,  352,  353,
  354,  355,  356,  357,  358,  359,  360,  361,  362,  363,
  364,  365,  366,  367,  368,  369,  370,  371,   -1,  373,
  374,  375,  376,  377,  378,   -1,   -1,  256,  257,  258,
  259,  260,  386,   -1,   -1,  264,  265,  266,   -1,   -1,
  426,  270,  271,  272,  273,  274,  257,  258,  259,  260,
   -1,   -1,   -1,  264,  265,  266,   -1,   -1,   -1,  270,
  271,  272,  273,  274,  426,   -1,   -1,   -1,  257,  258,
  259,  260,   -1,   -1,  263,  264,  265,  266,   -1,  433,
  434,  270,  271,  272,  273,  274,  257,  258,  259,  260,
   -1,   -1,  263,  264,  265,  266,   -1,   -1,   -1,  270,
  271,  272,  273,  274,  257,  258,  259,  260,   -1,   -1,
  263,  264,  265,  266,   -1,   -1,   -1,  270,  271,  272,
  273,  274,  257,  258,  259,  260,   -1,   -1,   -1,  264,
  265,  266,   -1,   -1,   -1,  270,  271,  272,  273,  274,
  257,  258,  259,  260,   -1,   -1,   -1,  264,  265,  266,
   -1,   -1,   -1,  270,  271,  272,  273,  274,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  387,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  426,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  426,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  426,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  426,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  426,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  426,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  426,
};
#if YYBTYACC
static const YYINT yyctable[] = {                        -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
};
#endif
#define YYFINAL 104
#ifndef YYDEBUG
#define YYDEBUG 1
#endif
#define YYMAXTOKEN 436
#define YYUNDFTOKEN 495
#define YYTRANSLATE(a) ((a) > YYMAXTOKEN ? YYUNDFTOKEN : (a))
#if YYDEBUG
static const char *const yyname[] = {

"$end",0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,"'('","')'","'*'","'+'",0,"'-'",0,"'/'",0,0,0,0,0,0,0,0,0,0,"':'",0,0,0,0,
0,"'@'",0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,"error",
"H_NUMBER","D_NUMBER","O_NUMBER","B_NUMBER","CONVERT_OP","B_DATA",
"H_RANGE_GUESS","D_NUMBER_GUESS","O_NUMBER_GUESS","B_NUMBER_GUESS","BAD_CMD",
"MEM_OP","IF","MEM_COMP","MEM_DISK8","MEM_DISK9","MEM_DISK10","MEM_DISK11",
"EQUALS","TRAIL","CMD_SEP","LABEL_ASGN_COMMENT","CMD_LOG","CMD_LOGNAME",
"CMD_SIDEFX","CMD_DUMMY","CMD_RETURN","CMD_BLOCK_READ","CMD_BLOCK_WRITE",
"CMD_UP","CMD_DOWN","CMD_LOAD","CMD_BASICLOAD","CMD_SAVE","CMD_VERIFY",
"CMD_BVERIFY","CMD_IGNORE","CMD_HUNT","CMD_FILL","CMD_MOVE","CMD_GOTO",
"CMD_REGISTERS","CMD_READSPACE","CMD_WRITESPACE","CMD_RADIX","CMD_MEM_DISPLAY",
"CMD_BREAK","CMD_TRACE","CMD_IO","CMD_BRMON","CMD_COMPARE","CMD_DUMP",
"CMD_UNDUMP","CMD_EXIT","CMD_DELETE","CMD_CONDITION","CMD_COMMAND",
"CMD_ASSEMBLE","CMD_DISASSEMBLE","CMD_NEXT","CMD_STEP","CMD_PRINT","CMD_DEVICE",
"CMD_HELP","CMD_WATCH","CMD_DISK","CMD_QUIT","CMD_CHDIR","CMD_BANK",
"CMD_LOAD_LABELS","CMD_SAVE_LABELS","CMD_ADD_LABEL","CMD_DEL_LABEL",
"CMD_SHOW_LABELS","CMD_CLEAR_LABELS","CMD_RECORD","CMD_MON_STOP","CMD_PLAYBACK",
"CMD_CHAR_DISPLAY","CMD_SPRITE_DISPLAY","CMD_TEXT_DISPLAY",
"CMD_SCREENCODE_DISPLAY","CMD_ENTER_DATA","CMD_ENTER_BIN_DATA","CMD_KEYBUF",
"CMD_BLOAD","CMD_BSAVE","CMD_SCREEN","CMD_UNTIL","CMD_CPU","CMD_YYDEBUG",
"CMD_BACKTRACE","CMD_SCREENSHOT","CMD_PWD","CMD_DIR","CMD_MKDIR","CMD_RMDIR",
"CMD_RESOURCE_GET","CMD_RESOURCE_SET","CMD_LOAD_RESOURCES","CMD_SAVE_RESOURCES",
"CMD_ATTACH","CMD_DETACH","CMD_MON_RESET","CMD_TAPECTRL","CMD_CARTFREEZE",
"CMD_UPDB","CMD_JPDB","CMD_CPUHISTORY","CMD_MEMMAPZAP","CMD_MEMMAPSHOW",
"CMD_MEMMAPSAVE","CMD_COMMENT","CMD_LIST","CMD_STOPWATCH","RESET","CMD_EXPORT",
"CMD_AUTOSTART","CMD_AUTOLOAD","CMD_MAINCPU_TRACE","CMD_WARP","CMD_PROFILE",
"FLAT","GRAPH","FUNC","DEPTH","DISASS","PROFILE_CONTEXT","CLEAR",
"CMD_LABEL_ASGN","L_PAREN","R_PAREN","ARG_IMMEDIATE","REG_A","REG_X","REG_Y",
"COMMA","INST_SEP","L_BRACKET","R_BRACKET","LESS_THAN","REG_U","REG_S","REG_PC",
"REG_PCR","REG_B","REG_C","REG_D","REG_E","REG_H","REG_L","REG_AF","REG_BC",
"REG_DE","REG_HL","REG_IX","REG_IY","REG_SP","REG_IXH","REG_IXL","REG_IYH",
"REG_IYL","PLUS","MINUS","STRING","FILENAME","R_O_L","R_O_L_Q","OPCODE","LABEL",
"BANKNAME","CPUTYPE","MON_REGISTER","COND_OP","RADIX_TYPE","INPUT_SPEC",
"CMD_CHECKPT_ON","CMD_CHECKPT_OFF","TOGGLE","MASK","$accept","top_level",
"address_range","address_opt_range","address","opt_address","opt_if_cond_expr",
"cond_expr","cond_operand","number","expression","d_number","opt_d_number",
"opt_context_num","guess_default","device_num","memspace","memloc","memaddr",
"checkpt_num","mem_op","opt_mem_op","value","assembly_instruction","register",
"rest_of_line","opt_rest_of_line","rest_of_line_or_quoted","data_list",
"data_element","filename","hunt_list","hunt_element","asm_operand_mode",
"index_reg","index_ureg","command_list","command","end_cmd",
"machine_state_rules","symbol_table_rules","memory_rules","asm_rules",
"checkpoint_rules","checkpoint_control_rules","monitor_state_rules",
"monitor_misc_rules","disk_rules","cmd_file_rules","data_entry_rules",
"monitor_debug_rules","opt_sep","register_mod","reg_list","post_assemble","$$1",
"reg_asgn","assembly_instr_list","illegal-symbol",
};
static const char *const yyrule[] = {
"$accept : top_level",
"top_level : command_list",
"top_level : assembly_instruction TRAIL",
"top_level : TRAIL",
"command_list : command",
"command_list : command_list command",
"end_cmd : CMD_SEP",
"end_cmd : TRAIL",
"end_cmd : error",
"command : machine_state_rules",
"command : symbol_table_rules",
"command : memory_rules",
"command : asm_rules",
"command : checkpoint_rules",
"command : checkpoint_control_rules",
"command : monitor_state_rules",
"command : monitor_misc_rules",
"command : disk_rules",
"command : cmd_file_rules",
"command : data_entry_rules",
"command : monitor_debug_rules",
"command : BAD_CMD",
"machine_state_rules : CMD_BANK end_cmd",
"machine_state_rules : CMD_BANK memspace end_cmd",
"machine_state_rules : CMD_BANK BANKNAME end_cmd",
"machine_state_rules : CMD_BANK memspace opt_sep BANKNAME end_cmd",
"machine_state_rules : CMD_GOTO address end_cmd",
"machine_state_rules : CMD_GOTO end_cmd",
"machine_state_rules : CMD_IO end_cmd",
"machine_state_rules : CMD_IO address end_cmd",
"machine_state_rules : CMD_CPU end_cmd",
"machine_state_rules : CMD_CPU CPUTYPE end_cmd",
"machine_state_rules : CMD_CPUHISTORY end_cmd",
"machine_state_rules : CMD_CPUHISTORY opt_sep memspace end_cmd",
"machine_state_rules : CMD_CPUHISTORY opt_sep memspace opt_sep memspace end_cmd",
"machine_state_rules : CMD_CPUHISTORY opt_sep memspace opt_sep memspace opt_sep memspace end_cmd",
"machine_state_rules : CMD_CPUHISTORY opt_sep memspace opt_sep memspace opt_sep memspace opt_sep memspace end_cmd",
"machine_state_rules : CMD_CPUHISTORY opt_sep memspace opt_sep memspace opt_sep memspace opt_sep memspace opt_sep memspace end_cmd",
"machine_state_rules : CMD_CPUHISTORY opt_sep d_number end_cmd",
"machine_state_rules : CMD_CPUHISTORY opt_sep d_number opt_sep memspace end_cmd",
"machine_state_rules : CMD_CPUHISTORY opt_sep d_number opt_sep memspace opt_sep memspace end_cmd",
"machine_state_rules : CMD_CPUHISTORY opt_sep d_number opt_sep memspace opt_sep memspace opt_sep memspace end_cmd",
"machine_state_rules : CMD_CPUHISTORY opt_sep d_number opt_sep memspace opt_sep memspace opt_sep memspace opt_sep memspace end_cmd",
"machine_state_rules : CMD_CPUHISTORY opt_sep d_number opt_sep memspace opt_sep memspace opt_sep memspace opt_sep memspace opt_sep memspace end_cmd",
"machine_state_rules : CMD_RETURN end_cmd",
"machine_state_rules : CMD_DUMP filename end_cmd",
"machine_state_rules : CMD_UNDUMP filename end_cmd",
"machine_state_rules : CMD_STEP end_cmd",
"machine_state_rules : CMD_STEP opt_sep expression end_cmd",
"machine_state_rules : CMD_NEXT end_cmd",
"machine_state_rules : CMD_NEXT opt_sep expression end_cmd",
"machine_state_rules : CMD_UP end_cmd",
"machine_state_rules : CMD_UP opt_sep expression end_cmd",
"machine_state_rules : CMD_DOWN end_cmd",
"machine_state_rules : CMD_DOWN opt_sep expression end_cmd",
"machine_state_rules : CMD_SCREEN end_cmd",
"machine_state_rules : CMD_SCREEN address end_cmd",
"machine_state_rules : CMD_WARP end_cmd",
"machine_state_rules : CMD_WARP TOGGLE end_cmd",
"machine_state_rules : register_mod",
"register_mod : CMD_REGISTERS end_cmd",
"register_mod : CMD_REGISTERS memspace end_cmd",
"register_mod : CMD_REGISTERS reg_list end_cmd",
"symbol_table_rules : CMD_LOAD_LABELS memspace opt_sep filename end_cmd",
"symbol_table_rules : CMD_LOAD_LABELS filename end_cmd",
"symbol_table_rules : CMD_SAVE_LABELS memspace opt_sep filename end_cmd",
"symbol_table_rules : CMD_SAVE_LABELS filename end_cmd",
"symbol_table_rules : CMD_ADD_LABEL address opt_sep LABEL end_cmd",
"symbol_table_rules : CMD_DEL_LABEL LABEL end_cmd",
"symbol_table_rules : CMD_DEL_LABEL memspace opt_sep LABEL end_cmd",
"symbol_table_rules : CMD_SHOW_LABELS memspace end_cmd",
"symbol_table_rules : CMD_SHOW_LABELS end_cmd",
"symbol_table_rules : CMD_CLEAR_LABELS memspace end_cmd",
"symbol_table_rules : CMD_CLEAR_LABELS end_cmd",
"symbol_table_rules : CMD_LABEL_ASGN EQUALS address end_cmd",
"symbol_table_rules : CMD_LABEL_ASGN EQUALS address LABEL_ASGN_COMMENT end_cmd",
"$$1 :",
"asm_rules : CMD_ASSEMBLE address $$1 post_assemble end_cmd",
"asm_rules : CMD_ASSEMBLE address end_cmd",
"asm_rules : CMD_DISASSEMBLE address_opt_range end_cmd",
"asm_rules : CMD_DISASSEMBLE end_cmd",
"memory_rules : CMD_MOVE address_range opt_sep address end_cmd",
"memory_rules : CMD_COMPARE address_range opt_sep address end_cmd",
"memory_rules : CMD_FILL address_range opt_sep data_list end_cmd",
"memory_rules : CMD_HUNT address_range opt_sep hunt_list end_cmd",
"memory_rules : CMD_MEM_DISPLAY RADIX_TYPE opt_sep address_opt_range end_cmd",
"memory_rules : CMD_MEM_DISPLAY address_opt_range end_cmd",
"memory_rules : CMD_MEM_DISPLAY end_cmd",
"memory_rules : CMD_CHAR_DISPLAY address_opt_range end_cmd",
"memory_rules : CMD_CHAR_DISPLAY end_cmd",
"memory_rules : CMD_SPRITE_DISPLAY address_opt_range end_cmd",
"memory_rules : CMD_SPRITE_DISPLAY end_cmd",
"memory_rules : CMD_TEXT_DISPLAY address_opt_range end_cmd",
"memory_rules : CMD_TEXT_DISPLAY end_cmd",
"memory_rules : CMD_SCREENCODE_DISPLAY address_opt_range end_cmd",
"memory_rules : CMD_SCREENCODE_DISPLAY end_cmd",
"memory_rules : CMD_MEMMAPZAP end_cmd",
"memory_rules : CMD_MEMMAPSHOW end_cmd",
"memory_rules : CMD_MEMMAPSHOW opt_sep expression end_cmd",
"memory_rules : CMD_MEMMAPSHOW opt_sep expression address_opt_range end_cmd",
"memory_rules : CMD_MEMMAPSAVE filename opt_sep expression end_cmd",
"checkpoint_rules : CMD_BREAK opt_mem_op address_opt_range opt_if_cond_expr end_cmd",
"checkpoint_rules : CMD_BREAK end_cmd",
"checkpoint_rules : CMD_UNTIL address_opt_range end_cmd",
"checkpoint_rules : CMD_UNTIL end_cmd",
"checkpoint_rules : CMD_WATCH opt_mem_op address_opt_range opt_if_cond_expr end_cmd",
"checkpoint_rules : CMD_WATCH end_cmd",
"checkpoint_rules : CMD_TRACE opt_mem_op address_opt_range opt_if_cond_expr end_cmd",
"checkpoint_rules : CMD_TRACE end_cmd",
"checkpoint_control_rules : CMD_CHECKPT_ON checkpt_num end_cmd",
"checkpoint_control_rules : CMD_CHECKPT_ON end_cmd",
"checkpoint_control_rules : CMD_CHECKPT_OFF checkpt_num end_cmd",
"checkpoint_control_rules : CMD_CHECKPT_OFF end_cmd",
"checkpoint_control_rules : CMD_IGNORE checkpt_num end_cmd",
"checkpoint_control_rules : CMD_IGNORE checkpt_num opt_sep expression end_cmd",
"checkpoint_control_rules : CMD_DELETE checkpt_num end_cmd",
"checkpoint_control_rules : CMD_DELETE end_cmd",
"checkpoint_control_rules : CMD_CONDITION checkpt_num IF cond_expr end_cmd",
"checkpoint_control_rules : CMD_COMMAND checkpt_num opt_sep STRING end_cmd",
"checkpoint_control_rules : CMD_COMMAND checkpt_num error end_cmd",
"monitor_state_rules : CMD_SIDEFX TOGGLE end_cmd",
"monitor_state_rules : CMD_SIDEFX end_cmd",
"monitor_state_rules : CMD_DUMMY TOGGLE end_cmd",
"monitor_state_rules : CMD_DUMMY end_cmd",
"monitor_state_rules : CMD_LOG TOGGLE end_cmd",
"monitor_state_rules : CMD_LOG end_cmd",
"monitor_state_rules : CMD_LOGNAME filename end_cmd",
"monitor_state_rules : CMD_RADIX RADIX_TYPE end_cmd",
"monitor_state_rules : CMD_RADIX end_cmd",
"monitor_state_rules : CMD_DEVICE end_cmd",
"monitor_state_rules : CMD_DEVICE memspace end_cmd",
"monitor_state_rules : CMD_EXPORT end_cmd",
"monitor_state_rules : CMD_QUIT end_cmd",
"monitor_state_rules : CMD_EXIT end_cmd",
"monitor_state_rules : CMD_MAINCPU_TRACE end_cmd",
"monitor_state_rules : CMD_MAINCPU_TRACE TOGGLE end_cmd",
"monitor_misc_rules : CMD_DISK rest_of_line end_cmd",
"monitor_misc_rules : CMD_PRINT expression end_cmd",
"monitor_misc_rules : CMD_HELP end_cmd",
"monitor_misc_rules : CMD_HELP rest_of_line end_cmd",
"monitor_misc_rules : CONVERT_OP expression end_cmd",
"monitor_misc_rules : CMD_CHDIR rest_of_line_or_quoted end_cmd",
"monitor_misc_rules : CMD_KEYBUF rest_of_line end_cmd",
"monitor_misc_rules : CMD_BACKTRACE end_cmd",
"monitor_misc_rules : CMD_DIR opt_rest_of_line end_cmd",
"monitor_misc_rules : CMD_PWD end_cmd",
"monitor_misc_rules : CMD_MKDIR rest_of_line_or_quoted end_cmd",
"monitor_misc_rules : CMD_RMDIR rest_of_line_or_quoted end_cmd",
"monitor_misc_rules : CMD_SCREENSHOT filename end_cmd",
"monitor_misc_rules : CMD_SCREENSHOT filename opt_sep expression end_cmd",
"monitor_misc_rules : CMD_RESOURCE_GET STRING end_cmd",
"monitor_misc_rules : CMD_RESOURCE_SET STRING STRING end_cmd",
"monitor_misc_rules : CMD_LOAD_RESOURCES filename end_cmd",
"monitor_misc_rules : CMD_SAVE_RESOURCES filename end_cmd",
"monitor_misc_rules : CMD_MON_RESET end_cmd",
"monitor_misc_rules : CMD_MON_RESET opt_sep expression end_cmd",
"monitor_misc_rules : CMD_TAPECTRL opt_sep expression end_cmd",
"monitor_misc_rules : CMD_CARTFREEZE end_cmd",
"monitor_misc_rules : CMD_UPDB number end_cmd",
"monitor_misc_rules : CMD_JPDB number number end_cmd",
"monitor_misc_rules : CMD_COMMENT opt_rest_of_line end_cmd",
"monitor_misc_rules : CMD_STOPWATCH RESET end_cmd",
"monitor_misc_rules : CMD_STOPWATCH end_cmd",
"monitor_misc_rules : CMD_PROFILE TOGGLE end_cmd",
"monitor_misc_rules : CMD_PROFILE end_cmd",
"monitor_misc_rules : CMD_PROFILE FLAT opt_d_number end_cmd",
"monitor_misc_rules : CMD_PROFILE GRAPH opt_context_num end_cmd",
"monitor_misc_rules : CMD_PROFILE GRAPH opt_context_num DEPTH d_number end_cmd",
"monitor_misc_rules : CMD_PROFILE FUNC address end_cmd",
"monitor_misc_rules : CMD_PROFILE DISASS address end_cmd",
"monitor_misc_rules : CMD_PROFILE CLEAR address end_cmd",
"monitor_misc_rules : CMD_PROFILE PROFILE_CONTEXT d_number end_cmd",
"disk_rules : CMD_LOAD filename device_num opt_address end_cmd",
"disk_rules : CMD_BASICLOAD filename device_num opt_address end_cmd",
"disk_rules : CMD_BLOAD filename device_num address end_cmd",
"disk_rules : CMD_BLOAD filename device_num error",
"disk_rules : CMD_SAVE filename device_num address_range end_cmd",
"disk_rules : CMD_SAVE filename error",
"disk_rules : CMD_SAVE filename device_num error",
"disk_rules : CMD_BSAVE filename device_num address_range end_cmd",
"disk_rules : CMD_BSAVE filename device_num error",
"disk_rules : CMD_VERIFY filename device_num opt_address end_cmd",
"disk_rules : CMD_BVERIFY filename device_num address end_cmd",
"disk_rules : CMD_BVERIFY filename device_num error",
"disk_rules : CMD_BLOCK_READ expression expression opt_address end_cmd",
"disk_rules : CMD_BLOCK_WRITE expression expression address end_cmd",
"disk_rules : CMD_LIST end_cmd",
"disk_rules : CMD_LIST device_num end_cmd",
"disk_rules : CMD_ATTACH filename expression end_cmd",
"disk_rules : CMD_DETACH expression end_cmd",
"disk_rules : CMD_AUTOSTART filename end_cmd",
"disk_rules : CMD_AUTOSTART filename opt_sep number end_cmd",
"disk_rules : CMD_AUTOLOAD filename end_cmd",
"disk_rules : CMD_AUTOLOAD filename opt_sep number end_cmd",
"cmd_file_rules : CMD_RECORD filename end_cmd",
"cmd_file_rules : CMD_MON_STOP end_cmd",
"cmd_file_rules : CMD_PLAYBACK filename end_cmd",
"data_entry_rules : CMD_ENTER_DATA address data_list end_cmd",
"data_entry_rules : CMD_ENTER_BIN_DATA end_cmd",
"monitor_debug_rules : CMD_YYDEBUG end_cmd",
"rest_of_line : R_O_L",
"opt_rest_of_line : R_O_L",
"opt_rest_of_line :",
"rest_of_line_or_quoted : R_O_L_Q",
"filename : FILENAME",
"filename : error",
"device_num : d_number",
"device_num : error",
"mem_op : mem_op MEM_OP",
"mem_op : MEM_OP",
"opt_mem_op : mem_op",
"opt_mem_op :",
"register : MON_REGISTER",
"register : memspace MON_REGISTER",
"reg_list : reg_list COMMA reg_asgn",
"reg_list : reg_asgn",
"reg_asgn : register EQUALS number",
"checkpt_num : d_number",
"checkpt_num : error",
"opt_context_num : d_number",
"opt_context_num :",
"address_opt_range : address_range",
"address_opt_range : address",
"address_range : address opt_sep address",
"address_range : H_RANGE_GUESS",
"address_range : memspace opt_sep H_RANGE_GUESS",
"opt_address : opt_sep address",
"opt_address :",
"address : memloc",
"address : memspace opt_sep memloc",
"address : LABEL",
"opt_sep : COMMA",
"opt_sep :",
"memspace : MEM_COMP",
"memspace : MEM_DISK8",
"memspace : MEM_DISK9",
"memspace : MEM_DISK10",
"memspace : MEM_DISK11",
"memloc : memaddr",
"memaddr : number",
"expression : expression '+' expression",
"expression : expression '-' expression",
"expression : expression '*' expression",
"expression : expression '/' expression",
"expression : '(' expression ')'",
"expression : '(' expression error",
"expression : value",
"opt_if_cond_expr : IF cond_expr",
"opt_if_cond_expr :",
"cond_expr : cond_expr COND_OP cond_expr",
"cond_expr : cond_expr COND_OP error",
"cond_expr : L_PAREN cond_expr R_PAREN",
"cond_expr : L_PAREN cond_expr error",
"cond_expr : cond_operand",
"cond_operand : register",
"cond_operand : number",
"cond_operand : '@' BANKNAME ':' L_PAREN cond_expr R_PAREN",
"cond_operand : '@' BANKNAME ':' address",
"data_list : data_list opt_sep data_element",
"data_list : data_element",
"data_element : number",
"data_element : STRING",
"hunt_list : hunt_list hunt_element",
"hunt_list : hunt_element",
"hunt_element : number",
"hunt_element : MASK",
"hunt_element : STRING",
"value : number",
"value : register",
"d_number : D_NUMBER",
"d_number : B_NUMBER_GUESS",
"d_number : D_NUMBER_GUESS",
"d_number : O_NUMBER_GUESS",
"opt_d_number : d_number",
"opt_d_number :",
"guess_default : B_NUMBER_GUESS",
"guess_default : D_NUMBER_GUESS",
"guess_default : O_NUMBER_GUESS",
"number : H_NUMBER",
"number : B_NUMBER",
"number : D_NUMBER",
"number : O_NUMBER",
"number : guess_default",
"assembly_instr_list : assembly_instr_list INST_SEP assembly_instruction",
"assembly_instr_list : assembly_instruction INST_SEP assembly_instruction",
"assembly_instr_list : assembly_instruction INST_SEP",
"assembly_instruction : OPCODE asm_operand_mode",
"post_assemble : assembly_instruction",
"post_assemble : assembly_instr_list",
"asm_operand_mode : ARG_IMMEDIATE number",
"asm_operand_mode : number",
"asm_operand_mode : number COMMA REG_X",
"asm_operand_mode : number COMMA REG_Y",
"asm_operand_mode : number COMMA REG_S",
"asm_operand_mode : number COMMA number",
"asm_operand_mode : L_PAREN number R_PAREN",
"asm_operand_mode : L_PAREN number COMMA REG_X R_PAREN",
"asm_operand_mode : L_PAREN number COMMA REG_S R_PAREN COMMA REG_Y",
"asm_operand_mode : L_PAREN number R_PAREN COMMA REG_Y",
"asm_operand_mode : L_PAREN REG_BC R_PAREN",
"asm_operand_mode : L_PAREN REG_DE R_PAREN",
"asm_operand_mode : L_PAREN REG_HL R_PAREN",
"asm_operand_mode : L_PAREN REG_IX R_PAREN",
"asm_operand_mode : L_PAREN REG_IY R_PAREN",
"asm_operand_mode : L_PAREN REG_SP R_PAREN",
"asm_operand_mode : L_PAREN number R_PAREN COMMA REG_A",
"asm_operand_mode : L_PAREN number R_PAREN COMMA REG_HL",
"asm_operand_mode : L_PAREN number R_PAREN COMMA REG_IX",
"asm_operand_mode : L_PAREN number R_PAREN COMMA REG_IY",
"asm_operand_mode :",
"asm_operand_mode : REG_A",
"asm_operand_mode : REG_B",
"asm_operand_mode : REG_C",
"asm_operand_mode : REG_D",
"asm_operand_mode : REG_E",
"asm_operand_mode : REG_H",
"asm_operand_mode : REG_IXH",
"asm_operand_mode : REG_IYH",
"asm_operand_mode : REG_L",
"asm_operand_mode : REG_IXL",
"asm_operand_mode : REG_IYL",
"asm_operand_mode : REG_AF",
"asm_operand_mode : REG_BC",
"asm_operand_mode : REG_DE",
"asm_operand_mode : REG_HL",
"asm_operand_mode : REG_IX",
"asm_operand_mode : REG_IY",
"asm_operand_mode : REG_SP",
"asm_operand_mode : LESS_THAN number",
"asm_operand_mode : number COMMA index_ureg",
"asm_operand_mode : COMMA index_reg PLUS",
"asm_operand_mode : COMMA index_reg PLUS PLUS",
"asm_operand_mode : COMMA MINUS index_reg",
"asm_operand_mode : COMMA MINUS MINUS index_reg",
"asm_operand_mode : COMMA index_reg",
"asm_operand_mode : REG_B COMMA index_reg",
"asm_operand_mode : REG_A COMMA index_reg",
"asm_operand_mode : REG_D COMMA index_reg",
"asm_operand_mode : number COMMA REG_PC",
"asm_operand_mode : L_BRACKET number COMMA index_reg R_BRACKET",
"asm_operand_mode : L_BRACKET COMMA index_reg PLUS R_BRACKET",
"asm_operand_mode : L_BRACKET COMMA index_reg PLUS PLUS R_BRACKET",
"asm_operand_mode : L_BRACKET COMMA MINUS index_reg R_BRACKET",
"asm_operand_mode : L_BRACKET COMMA MINUS MINUS index_reg R_BRACKET",
"asm_operand_mode : L_BRACKET COMMA index_reg R_BRACKET",
"asm_operand_mode : L_BRACKET REG_B COMMA index_reg R_BRACKET",
"asm_operand_mode : L_BRACKET REG_A COMMA index_reg R_BRACKET",
"asm_operand_mode : L_BRACKET REG_D COMMA index_reg R_BRACKET",
"asm_operand_mode : L_BRACKET number COMMA REG_PC R_BRACKET",
"asm_operand_mode : L_BRACKET number R_BRACKET",
"asm_operand_mode : L_BRACKET number R_BRACKET COMMA REG_Y",
"index_reg : REG_X",
"index_reg : REG_Y",
"index_reg : index_ureg",
"index_reg : REG_S",
"index_ureg : REG_U",

};
#endif

#if YYDEBUG
int      yydebug;
#endif

int      yyerrflag;
int      yychar;
YYSTYPE  yyval;
YYSTYPE  yylval;
int      yynerrs;

#if defined(YYLTYPE) || defined(YYLTYPE_IS_DECLARED)
YYLTYPE  yyloc; /* position returned by actions */
YYLTYPE  yylloc; /* position from the lexer */
#endif

#if defined(YYLTYPE) || defined(YYLTYPE_IS_DECLARED)
#ifndef YYLLOC_DEFAULT
#define YYLLOC_DEFAULT(loc, rhs, n) \
do \
{ \
    if (n == 0) \
    { \
        (loc).first_line   = YYRHSLOC(rhs, 0).last_line; \
        (loc).first_column = YYRHSLOC(rhs, 0).last_column; \
        (loc).last_line    = YYRHSLOC(rhs, 0).last_line; \
        (loc).last_column  = YYRHSLOC(rhs, 0).last_column; \
    } \
    else \
    { \
        (loc).first_line   = YYRHSLOC(rhs, 1).first_line; \
        (loc).first_column = YYRHSLOC(rhs, 1).first_column; \
        (loc).last_line    = YYRHSLOC(rhs, n).last_line; \
        (loc).last_column  = YYRHSLOC(rhs, n).last_column; \
    } \
} while (0)
#endif /* YYLLOC_DEFAULT */
#endif /* defined(YYLTYPE) || defined(YYLTYPE_IS_DECLARED) */
#if YYBTYACC

#ifndef YYLVQUEUEGROWTH
#define YYLVQUEUEGROWTH 32
#endif
#endif /* YYBTYACC */

/* define the initial stack-sizes */
#ifdef YYSTACKSIZE
#undef YYMAXDEPTH
#define YYMAXDEPTH  YYSTACKSIZE
#else
#ifdef YYMAXDEPTH
#define YYSTACKSIZE YYMAXDEPTH
#else
#define YYSTACKSIZE 10000
#define YYMAXDEPTH  10000
#endif
#endif

#ifndef YYINITSTACKSIZE
#define YYINITSTACKSIZE 200
#endif

typedef struct {
    unsigned stacksize;
    YYINT    *s_base;
    YYINT    *s_mark;
    YYINT    *s_last;
    YYSTYPE  *l_base;
    YYSTYPE  *l_mark;
#if defined(YYLTYPE) || defined(YYLTYPE_IS_DECLARED)
    YYLTYPE  *p_base;
    YYLTYPE  *p_mark;
#endif
} YYSTACKDATA;
#if YYBTYACC

struct YYParseState_s
{
    struct YYParseState_s *save;    /* Previously saved parser state */
    YYSTACKDATA            yystack; /* saved parser stack */
    int                    state;   /* saved parser state */
    int                    errflag; /* saved error recovery status */
    int                    lexeme;  /* saved index of the conflict lexeme in the lexical queue */
    YYINT                  ctry;    /* saved index in yyctable[] for this conflict */
};
typedef struct YYParseState_s YYParseState;
#endif /* YYBTYACC */
/* variables for the parser stack */
static YYSTACKDATA yystack;
#if YYBTYACC

/* Current parser state */
static YYParseState *yyps = 0;

/* yypath != NULL: do the full parse, starting at *yypath parser state. */
static YYParseState *yypath = 0;

/* Base of the lexical value queue */
static YYSTYPE *yylvals = 0;

/* Current position at lexical value queue */
static YYSTYPE *yylvp = 0;

/* End position of lexical value queue */
static YYSTYPE *yylve = 0;

/* The last allocated position at the lexical value queue */
static YYSTYPE *yylvlim = 0;

#if defined(YYLTYPE) || defined(YYLTYPE_IS_DECLARED)
/* Base of the lexical position queue */
static YYLTYPE *yylpsns = 0;

/* Current position at lexical position queue */
static YYLTYPE *yylpp = 0;

/* End position of lexical position queue */
static YYLTYPE *yylpe = 0;

/* The last allocated position at the lexical position queue */
static YYLTYPE *yylplim = 0;
#endif

/* Current position at lexical token queue */
static YYINT  *yylexp = 0;

static YYINT  *yylexemes = 0;
#endif /* YYBTYACC */
#line 1185 "mon_parse.y"

int parse_and_execute_line(char *input)
{
   char *temp_buf;
   int i, rc;

   if (default_memspace == e_comp_space) {
       /*
        * If the command is to be executed when the default address space is the main cpu,
        * Ensure drive CPU emulation is up to date with main cpu CLOCK.
        */
       drive_cpu_execute_all(maincpu_clk);
   }

   temp_buf = lib_malloc(strlen(input) + 3);
   strcpy(temp_buf,input);
   i = (int)strlen(input);
   temp_buf[i++] = '\n';
   temp_buf[i++] = '\0';
   temp_buf[i++] = '\0';

   make_buffer(temp_buf);
   mon_clear_buffer();
   if ( (rc =yyparse()) != 0) {
       mon_out("ERROR -- ");
       switch(rc) {
         case ERR_BAD_CMD:
           mon_out("Bad command:\n");
           break;
         case ERR_RANGE_BAD_START:
           mon_out("Bad first address in range:\n");
           break;
         case ERR_RANGE_BAD_END:
           mon_out("Bad second address in range:\n");
           break;
         case ERR_EXPECT_CHECKNUM:
           mon_out("Checkpoint number expected:\n");
           break;
         case ERR_EXPECT_END_CMD:
           mon_out("Unexpected token:\n");
           break;
         case ERR_MISSING_CLOSE_PAREN:
           mon_out("')' expected:\n");
           break;
         case ERR_INCOMPLETE_COND_OP:
           mon_out("Conditional operation missing an operand:\n");
           break;
         case ERR_EXPECT_FILENAME:
           mon_out("Expecting a filename:\n");
           break;
         case ERR_ADDR_TOO_BIG:
           mon_out("Address too large:\n");
           break;
         case ERR_IMM_TOO_BIG:
           mon_out("Immediate argument too large:\n");
           break;
         case ERR_EXPECT_STRING:
           mon_out("Expecting a string.\n");
           break;
         case ERR_UNDEFINED_LABEL:
           mon_out("Found an undefined label.\n");
           break;
         case ERR_EXPECT_DEVICE_NUM:
           mon_out("Expecting a device number.\n");
           break;
         case ERR_EXPECT_ADDRESS:
           mon_out("Expecting an address.\n");
           break;
         case ERR_INVALID_REGISTER:
           mon_out("Invalid register.\n");
           break;
         case ERR_ILLEGAL_INPUT:
         default:
           mon_out("Wrong syntax:\n");
       }
       mon_out("  %s\n", input);
       for (i = 0; i < last_len; i++)
           mon_out(" ");
       mon_out("  ^\n");
       asm_mode = 0;
       new_cmd = 1;
   }
   lib_free(temp_buf);
   free_buffer();

   return rc;
}

void set_yydebug(int val)
{
#if YYDEBUG
    yydebug = val;
#else
#endif
}

static int yyerror(char *s)
{
#if 0
   fprintf(stderr, "ERR:%s\n", s);
#endif
   return 0;
}

/* convert the string in "num" to a numeric value, depending on radix. this 
   function does some magic conversion on addresses when radix is not hex.
*/
static int resolve_datatype(unsigned guess_type, const char *num)
{
    int binary = 1, hex = 0, octal = 0, decimal = 1;
    const char *c;

    /* FIXME: Handle cases when default type is non-numerical */
    if (default_radix == e_hexadecimal) {
        return (int)strtol(num, NULL, 16);
    }

    /* we do some educated guessing on what type of number we have here */
    if (num[0] == '0') {
        /* might be octal with leading zero */
        octal = 1;
    }
    /* a string containing any digits not 0 or 1 can't be a binary number */
    c = num;
    while (*c) {
        if ((*c != '0') && (*c != '1')) {
            binary = 0;
            break;
        }
        c++;
    }
    /* a string containing 8 or 9 can't be an octal number */
    c = num;
    while (*c) {
        if ((*c == '8') && (*c == '9')) {
            octal = 0;
            break;
        }
        c++;
    }
    /* a string containing any of A-F can only be a hex number */
    c = num;
    while (*c) {
        if ((tolower((unsigned char)*c) >= 'a') && (tolower((unsigned char)*c) <= 'f')) {
            hex = 1;
            octal = 0;
            binary = 0;
            decimal = 0;
            break;
        }
        c++;
    }

    /* a hex number can only be hex no matter what */
    if (hex) {
        return (int)strtol(num, NULL, 16);
    }

    /* first, if default radix and detected number matches, just do it */
    if (binary && (default_radix == e_binary)) {
        return (int)strtol(num, NULL, 2);
    }
    if (decimal && (default_radix == e_decimal)) {
        return (int)strtol(num, NULL, 10);
    }
    if (octal && (default_radix == e_octal)) {
        return (int)strtol(num, NULL, 8);
    }

    /* second, if detected number matches guess type, do it */
    if (binary && (guess_type == B_NUMBER)) {
        return (int)strtol(num, NULL, 2);
    }
    if (decimal && (guess_type == D_NUMBER)) {
        return (int)strtol(num, NULL, 10);
    }
    if (octal && (guess_type == O_NUMBER)) {
        return (int)strtol(num, NULL, 8);
    }

    /* third only use the detected type */
    if (binary) {
        return (int)strtol(num, NULL, 2);
    }
    if (decimal) {
        return (int)strtol(num, NULL, 10);
    }
    if (octal) {
        return (int)strtol(num, NULL, 8);
    }

    /* use hex as default, should we ever come here */
    return (int)strtol(num, NULL, 16);
}

/*
 * Resolve a character sequence containing 8 hex digits like "08001000".
 * This could be a lazy version of "0800 1000". If the default radix is not
 * hexadecimal, we handle it like a ordinary number, in the latter case there
 * is only one number in the range.
 */
static int resolve_range(enum t_memspace memspace, MON_ADDR range[2],
                         const char *num)
{
    char start[5];
    char end[5];
    long sa;

    range[1] = BAD_ADDR;

    switch (default_radix)
    {
    case e_hexadecimal:
        /* checked twice, but as the code must have exactly 8 digits: */
        if (strlen(num) == 8) {
            memcpy(start, num, 4);
            start[4] = '\0';
            memcpy(end, num + 4, 4);
            end[4] = '\0';
            sa = strtol(start, NULL, 16);
            range[1] = (int)new_addr(memspace, strtol(end, NULL, 16));
        }
        else
            sa = strtol(num, NULL, 16);
        break;

    case e_decimal:
       sa = strtol(num, NULL, 10);
       break;

    case e_octal:
       sa = strtol(num, NULL, 8);
       break;

    default:
       sa = strtol(num, NULL, 2);
    }

    if (!CHECK_ADDR(sa))
        return ERR_ADDR_TOO_BIG;

    range[0] = (int)new_addr(memspace, sa);
    return 0;
}
#line 2407 "mon_parse.c"

/* For use in generated program */
#define yydepth (int)(yystack.s_mark - yystack.s_base)
#if YYBTYACC
#define yytrial (yyps->save)
#endif /* YYBTYACC */

#if YYDEBUG
#include <stdio.h>	/* needed for printf */
#endif

#include <stdlib.h>	/* needed for malloc, etc */
#include <string.h>	/* needed for memset */

/* allocate initial stack or double stack size, up to YYMAXDEPTH */
static int yygrowstack(YYSTACKDATA *data)
{
    int i;
    unsigned newsize;
    YYINT *newss;
    YYSTYPE *newvs;
#if defined(YYLTYPE) || defined(YYLTYPE_IS_DECLARED)
    YYLTYPE *newps;
#endif

    if ((newsize = data->stacksize) == 0)
        newsize = YYINITSTACKSIZE;
    else if (newsize >= YYMAXDEPTH)
        return YYENOMEM;
    else if ((newsize *= 2) > YYMAXDEPTH)
        newsize = YYMAXDEPTH;

    i = (int) (data->s_mark - data->s_base);
    newss = (YYINT *)realloc(data->s_base, newsize * sizeof(*newss));
    if (newss == 0)
        return YYENOMEM;

    data->s_base = newss;
    data->s_mark = newss + i;

    newvs = (YYSTYPE *)realloc(data->l_base, newsize * sizeof(*newvs));
    if (newvs == 0)
        return YYENOMEM;

    data->l_base = newvs;
    data->l_mark = newvs + i;

#if defined(YYLTYPE) || defined(YYLTYPE_IS_DECLARED)
    newps = (YYLTYPE *)realloc(data->p_base, newsize * sizeof(*newps));
    if (newps == 0)
        return YYENOMEM;

    data->p_base = newps;
    data->p_mark = newps + i;
#endif

    data->stacksize = newsize;
    data->s_last = data->s_base + newsize - 1;

#if YYDEBUG
    if (yydebug)
        fprintf(stderr, "%sdebug: stack size increased to %d\n", YYPREFIX, newsize);
#endif
    return 0;
}

#if YYPURE || defined(YY_NO_LEAKS)
static void yyfreestack(YYSTACKDATA *data)
{
    free(data->s_base);
    free(data->l_base);
#if defined(YYLTYPE) || defined(YYLTYPE_IS_DECLARED)
    free(data->p_base);
#endif
    memset(data, 0, sizeof(*data));
}
#else
#define yyfreestack(data) /* nothing */
#endif /* YYPURE || defined(YY_NO_LEAKS) */
#if YYBTYACC

static YYParseState *
yyNewState(unsigned size)
{
    YYParseState *p = (YYParseState *) malloc(sizeof(YYParseState));
    if (p == NULL) return NULL;

    p->yystack.stacksize = size;
    if (size == 0)
    {
        p->yystack.s_base = NULL;
        p->yystack.l_base = NULL;
#if defined(YYLTYPE) || defined(YYLTYPE_IS_DECLARED)
        p->yystack.p_base = NULL;
#endif
        return p;
    }
    p->yystack.s_base    = (YYINT *) malloc(size * sizeof(YYINT));
    if (p->yystack.s_base == NULL) return NULL;
    p->yystack.l_base    = (YYSTYPE *) malloc(size * sizeof(YYSTYPE));
    if (p->yystack.l_base == NULL) return NULL;
    memset(p->yystack.l_base, 0, size * sizeof(YYSTYPE));
#if defined(YYLTYPE) || defined(YYLTYPE_IS_DECLARED)
    p->yystack.p_base    = (YYLTYPE *) malloc(size * sizeof(YYLTYPE));
    if (p->yystack.p_base == NULL) return NULL;
    memset(p->yystack.p_base, 0, size * sizeof(YYLTYPE));
#endif

    return p;
}

static void
yyFreeState(YYParseState *p)
{
    yyfreestack(&p->yystack);
    free(p);
}
#endif /* YYBTYACC */

#define YYABORT  goto yyabort
#define YYREJECT goto yyabort
#define YYACCEPT goto yyaccept
#define YYERROR  goto yyerrlab
#if YYBTYACC
#define YYVALID        do { if (yyps->save)            goto yyvalid; } while(0)
#define YYVALID_NESTED do { if (yyps->save && \
                                yyps->save->save == 0) goto yyvalid; } while(0)
#endif /* YYBTYACC */

int
YYPARSE_DECL()
{
    int yym, yyn, yystate, yyresult;
#if YYBTYACC
    int yynewerrflag;
    YYParseState *yyerrctx = NULL;
#endif /* YYBTYACC */
#if defined(YYLTYPE) || defined(YYLTYPE_IS_DECLARED)
    YYLTYPE  yyerror_loc_range[3]; /* position of error start/end (0 unused) */
#endif
#if YYDEBUG
    const char *yys;

    if ((yys = getenv("YYDEBUG")) != 0)
    {
        yyn = *yys;
        if (yyn >= '0' && yyn <= '9')
            yydebug = yyn - '0';
    }
    if (yydebug)
        fprintf(stderr, "%sdebug[<# of symbols on state stack>]\n", YYPREFIX);
#endif
#if defined(YYLTYPE) || defined(YYLTYPE_IS_DECLARED)
    memset(yyerror_loc_range, 0, sizeof(yyerror_loc_range));
#endif

#if YYBTYACC
    yyps = yyNewState(0); if (yyps == 0) goto yyenomem;
    yyps->save = 0;
#endif /* YYBTYACC */
    yym = 0;
    /* yyn is set below */
    yynerrs = 0;
    yyerrflag = 0;
    yychar = YYEMPTY;
    yystate = 0;

#if YYPURE
    memset(&yystack, 0, sizeof(yystack));
#endif

    if (yystack.s_base == NULL && yygrowstack(&yystack) == YYENOMEM) goto yyoverflow;
    yystack.s_mark = yystack.s_base;
    yystack.l_mark = yystack.l_base;
#if defined(YYLTYPE) || defined(YYLTYPE_IS_DECLARED)
    yystack.p_mark = yystack.p_base;
#endif
    yystate = 0;
    *yystack.s_mark = 0;

yyloop:
    if ((yyn = yydefred[yystate]) != 0) goto yyreduce;
    if (yychar < 0)
    {
#if YYBTYACC
        do {
        if (yylvp < yylve)
        {
            /* we're currently re-reading tokens */
            yylval = *yylvp++;
#if defined(YYLTYPE) || defined(YYLTYPE_IS_DECLARED)
            yylloc = *yylpp++;
#endif
            yychar = *yylexp++;
            break;
        }
        if (yyps->save)
        {
            /* in trial mode; save scanner results for future parse attempts */
            if (yylvp == yylvlim)
            {   /* Enlarge lexical value queue */
                size_t p = (size_t) (yylvp - yylvals);
                size_t s = (size_t) (yylvlim - yylvals);

                s += YYLVQUEUEGROWTH;
                if ((yylexemes = (YYINT *)realloc(yylexemes, s * sizeof(YYINT))) == NULL) goto yyenomem;
                if ((yylvals   = (YYSTYPE *)realloc(yylvals, s * sizeof(YYSTYPE))) == NULL) goto yyenomem;
#if defined(YYLTYPE) || defined(YYLTYPE_IS_DECLARED)
                if ((yylpsns   = (YYLTYPE *)realloc(yylpsns, s * sizeof(YYLTYPE))) == NULL) goto yyenomem;
#endif
                yylvp   = yylve = yylvals + p;
                yylvlim = yylvals + s;
#if defined(YYLTYPE) || defined(YYLTYPE_IS_DECLARED)
                yylpp   = yylpe = yylpsns + p;
                yylplim = yylpsns + s;
#endif
                yylexp  = yylexemes + p;
            }
            *yylexp = (YYINT) YYLEX;
            *yylvp++ = yylval;
            yylve++;
#if defined(YYLTYPE) || defined(YYLTYPE_IS_DECLARED)
            *yylpp++ = yylloc;
            yylpe++;
#endif
            yychar = *yylexp++;
            break;
        }
        /* normal operation, no conflict encountered */
#endif /* YYBTYACC */
        yychar = YYLEX;
#if YYBTYACC
        } while (0);
#endif /* YYBTYACC */
        if (yychar < 0) yychar = YYEOF;
#if YYDEBUG
        if (yydebug)
        {
            if ((yys = yyname[YYTRANSLATE(yychar)]) == NULL) yys = yyname[YYUNDFTOKEN];
            fprintf(stderr, "%s[%d]: state %d, reading token %d (%s)",
                            YYDEBUGSTR, yydepth, yystate, yychar, yys);
#ifdef YYSTYPE_TOSTRING
#if YYBTYACC
            if (!yytrial)
#endif /* YYBTYACC */
                fprintf(stderr, " <%s>", YYSTYPE_TOSTRING(yychar, yylval));
#endif
            fputc('\n', stderr);
        }
#endif
    }
#if YYBTYACC

    /* Do we have a conflict? */
    if (((yyn = yycindex[yystate]) != 0) && (yyn += yychar) >= 0 &&
        yyn <= YYTABLESIZE && yycheck[yyn] == (YYINT) yychar)
    {
        YYINT ctry;

        if (yypath)
        {
            YYParseState *save;
#if YYDEBUG
            if (yydebug)
                fprintf(stderr, "%s[%d]: CONFLICT in state %d: following successful trial parse\n",
                                YYDEBUGSTR, yydepth, yystate);
#endif
            /* Switch to the next conflict context */
            save = yypath;
            yypath = save->save;
            save->save = NULL;
            ctry = save->ctry;
            if (save->state != yystate) YYABORT;
            yyFreeState(save);

        }
        else
        {

            /* Unresolved conflict - start/continue trial parse */
            YYParseState *save;
#if YYDEBUG
            if (yydebug)
            {
                fprintf(stderr, "%s[%d]: CONFLICT in state %d. ", YYDEBUGSTR, yydepth, yystate);
                if (yyps->save)
                    fputs("ALREADY in conflict, continuing trial parse.\n", stderr);
                else
                    fputs("Starting trial parse.\n", stderr);
            }
#endif
            save                  = yyNewState((unsigned)(yystack.s_mark - yystack.s_base + 1));
            if (save == NULL) goto yyenomem;
            save->save            = yyps->save;
            save->state           = yystate;
            save->errflag         = yyerrflag;
            save->yystack.s_mark  = save->yystack.s_base + (yystack.s_mark - yystack.s_base);
            memcpy (save->yystack.s_base, yystack.s_base, (size_t) (yystack.s_mark - yystack.s_base + 1) * sizeof(YYINT));
            save->yystack.l_mark  = save->yystack.l_base + (yystack.l_mark - yystack.l_base);
            memcpy (save->yystack.l_base, yystack.l_base, (size_t) (yystack.l_mark - yystack.l_base + 1) * sizeof(YYSTYPE));
#if defined(YYLTYPE) || defined(YYLTYPE_IS_DECLARED)
            save->yystack.p_mark  = save->yystack.p_base + (yystack.p_mark - yystack.p_base);
            memcpy (save->yystack.p_base, yystack.p_base, (size_t) (yystack.p_mark - yystack.p_base + 1) * sizeof(YYLTYPE));
#endif
            ctry                  = yytable[yyn];
            if (yyctable[ctry] == -1)
            {
#if YYDEBUG
                if (yydebug && yychar >= YYEOF)
                    fprintf(stderr, "%s[%d]: backtracking 1 token\n", YYDEBUGSTR, yydepth);
#endif
                ctry++;
            }
            save->ctry = ctry;
            if (yyps->save == NULL)
            {
                /* If this is a first conflict in the stack, start saving lexemes */
                if (!yylexemes)
                {
                    yylexemes = (YYINT *) malloc((YYLVQUEUEGROWTH) * sizeof(YYINT));
                    if (yylexemes == NULL) goto yyenomem;
                    yylvals   = (YYSTYPE *) malloc((YYLVQUEUEGROWTH) * sizeof(YYSTYPE));
                    if (yylvals == NULL) goto yyenomem;
                    yylvlim   = yylvals + YYLVQUEUEGROWTH;
#if defined(YYLTYPE) || defined(YYLTYPE_IS_DECLARED)
                    yylpsns   = (YYLTYPE *) malloc((YYLVQUEUEGROWTH) * sizeof(YYLTYPE));
                    if (yylpsns == NULL) goto yyenomem;
                    yylplim   = yylpsns + YYLVQUEUEGROWTH;
#endif
                }
                if (yylvp == yylve)
                {
                    yylvp  = yylve = yylvals;
#if defined(YYLTYPE) || defined(YYLTYPE_IS_DECLARED)
                    yylpp  = yylpe = yylpsns;
#endif
                    yylexp = yylexemes;
                    if (yychar >= YYEOF)
                    {
                        *yylve++ = yylval;
#if defined(YYLTYPE) || defined(YYLTYPE_IS_DECLARED)
                        *yylpe++ = yylloc;
#endif
                        *yylexp  = (YYINT) yychar;
                        yychar   = YYEMPTY;
                    }
                }
            }
            if (yychar >= YYEOF)
            {
                yylvp--;
#if defined(YYLTYPE) || defined(YYLTYPE_IS_DECLARED)
                yylpp--;
#endif
                yylexp--;
                yychar = YYEMPTY;
            }
            save->lexeme = (int) (yylvp - yylvals);
            yyps->save   = save;
        }
        if (yytable[yyn] == ctry)
        {
#if YYDEBUG
            if (yydebug)
                fprintf(stderr, "%s[%d]: state %d, shifting to state %d\n",
                                YYDEBUGSTR, yydepth, yystate, yyctable[ctry]);
#endif
            if (yychar < 0)
            {
                yylvp++;
#if defined(YYLTYPE) || defined(YYLTYPE_IS_DECLARED)
                yylpp++;
#endif
                yylexp++;
            }
            if (yystack.s_mark >= yystack.s_last && yygrowstack(&yystack) == YYENOMEM)
                goto yyoverflow;
            yystate = yyctable[ctry];
            *++yystack.s_mark = (YYINT) yystate;
            *++yystack.l_mark = yylval;
#if defined(YYLTYPE) || defined(YYLTYPE_IS_DECLARED)
            *++yystack.p_mark = yylloc;
#endif
            yychar  = YYEMPTY;
            if (yyerrflag > 0) --yyerrflag;
            goto yyloop;
        }
        else
        {
            yyn = yyctable[ctry];
            goto yyreduce;
        }
    } /* End of code dealing with conflicts */
#endif /* YYBTYACC */
    if (((yyn = yysindex[yystate]) != 0) && (yyn += yychar) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == (YYINT) yychar)
    {
#if YYDEBUG
        if (yydebug)
            fprintf(stderr, "%s[%d]: state %d, shifting to state %d\n",
                            YYDEBUGSTR, yydepth, yystate, yytable[yyn]);
#endif
        if (yystack.s_mark >= yystack.s_last && yygrowstack(&yystack) == YYENOMEM) goto yyoverflow;
        yystate = yytable[yyn];
        *++yystack.s_mark = yytable[yyn];
        *++yystack.l_mark = yylval;
#if defined(YYLTYPE) || defined(YYLTYPE_IS_DECLARED)
        *++yystack.p_mark = yylloc;
#endif
        yychar = YYEMPTY;
        if (yyerrflag > 0)  --yyerrflag;
        goto yyloop;
    }
    if (((yyn = yyrindex[yystate]) != 0) && (yyn += yychar) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == (YYINT) yychar)
    {
        yyn = yytable[yyn];
        goto yyreduce;
    }
    if (yyerrflag != 0) goto yyinrecovery;
#if YYBTYACC

    yynewerrflag = 1;
    goto yyerrhandler;
    goto yyerrlab; /* redundant goto avoids 'unused label' warning */

yyerrlab:
    /* explicit YYERROR from an action -- pop the rhs of the rule reduced
     * before looking for error recovery */
    yystack.s_mark -= yym;
    yystate = *yystack.s_mark;
    yystack.l_mark -= yym;
#if defined(YYLTYPE) || defined(YYLTYPE_IS_DECLARED)
    yystack.p_mark -= yym;
#endif

    yynewerrflag = 0;
yyerrhandler:
    while (yyps->save)
    {
        int ctry;
        YYParseState *save = yyps->save;
#if YYDEBUG
        if (yydebug)
            fprintf(stderr, "%s[%d]: ERROR in state %d, CONFLICT BACKTRACKING to state %d, %d tokens\n",
                            YYDEBUGSTR, yydepth, yystate, yyps->save->state,
                    (int)(yylvp - yylvals - yyps->save->lexeme));
#endif
        /* Memorize most forward-looking error state in case it's really an error. */
        if (yyerrctx == NULL || yyerrctx->lexeme < yylvp - yylvals)
        {
            /* Free old saved error context state */
            if (yyerrctx) yyFreeState(yyerrctx);
            /* Create and fill out new saved error context state */
            yyerrctx                 = yyNewState((unsigned)(yystack.s_mark - yystack.s_base + 1));
            if (yyerrctx == NULL) goto yyenomem;
            yyerrctx->save           = yyps->save;
            yyerrctx->state          = yystate;
            yyerrctx->errflag        = yyerrflag;
            yyerrctx->yystack.s_mark = yyerrctx->yystack.s_base + (yystack.s_mark - yystack.s_base);
            memcpy (yyerrctx->yystack.s_base, yystack.s_base, (size_t) (yystack.s_mark - yystack.s_base + 1) * sizeof(YYINT));
            yyerrctx->yystack.l_mark = yyerrctx->yystack.l_base + (yystack.l_mark - yystack.l_base);
            memcpy (yyerrctx->yystack.l_base, yystack.l_base, (size_t) (yystack.l_mark - yystack.l_base + 1) * sizeof(YYSTYPE));
#if defined(YYLTYPE) || defined(YYLTYPE_IS_DECLARED)
            yyerrctx->yystack.p_mark = yyerrctx->yystack.p_base + (yystack.p_mark - yystack.p_base);
            memcpy (yyerrctx->yystack.p_base, yystack.p_base, (size_t) (yystack.p_mark - yystack.p_base + 1) * sizeof(YYLTYPE));
#endif
            yyerrctx->lexeme         = (int) (yylvp - yylvals);
        }
        yylvp          = yylvals   + save->lexeme;
#if defined(YYLTYPE) || defined(YYLTYPE_IS_DECLARED)
        yylpp          = yylpsns   + save->lexeme;
#endif
        yylexp         = yylexemes + save->lexeme;
        yychar         = YYEMPTY;
        yystack.s_mark = yystack.s_base + (save->yystack.s_mark - save->yystack.s_base);
        memcpy (yystack.s_base, save->yystack.s_base, (size_t) (yystack.s_mark - yystack.s_base + 1) * sizeof(YYINT));
        yystack.l_mark = yystack.l_base + (save->yystack.l_mark - save->yystack.l_base);
        memcpy (yystack.l_base, save->yystack.l_base, (size_t) (yystack.l_mark - yystack.l_base + 1) * sizeof(YYSTYPE));
#if defined(YYLTYPE) || defined(YYLTYPE_IS_DECLARED)
        yystack.p_mark = yystack.p_base + (save->yystack.p_mark - save->yystack.p_base);
        memcpy (yystack.p_base, save->yystack.p_base, (size_t) (yystack.p_mark - yystack.p_base + 1) * sizeof(YYLTYPE));
#endif
        ctry           = ++save->ctry;
        yystate        = save->state;
        /* We tried shift, try reduce now */
        if ((yyn = yyctable[ctry]) >= 0) goto yyreduce;
        yyps->save     = save->save;
        save->save     = NULL;
        yyFreeState(save);

        /* Nothing left on the stack -- error */
        if (!yyps->save)
        {
#if YYDEBUG
            if (yydebug)
                fprintf(stderr, "%sdebug[%d,trial]: trial parse FAILED, entering ERROR mode\n",
                                YYPREFIX, yydepth);
#endif
            /* Restore state as it was in the most forward-advanced error */
            yylvp          = yylvals   + yyerrctx->lexeme;
#if defined(YYLTYPE) || defined(YYLTYPE_IS_DECLARED)
            yylpp          = yylpsns   + yyerrctx->lexeme;
#endif
            yylexp         = yylexemes + yyerrctx->lexeme;
            yychar         = yylexp[-1];
            yylval         = yylvp[-1];
#if defined(YYLTYPE) || defined(YYLTYPE_IS_DECLARED)
            yylloc         = yylpp[-1];
#endif
            yystack.s_mark = yystack.s_base + (yyerrctx->yystack.s_mark - yyerrctx->yystack.s_base);
            memcpy (yystack.s_base, yyerrctx->yystack.s_base, (size_t) (yystack.s_mark - yystack.s_base + 1) * sizeof(YYINT));
            yystack.l_mark = yystack.l_base + (yyerrctx->yystack.l_mark - yyerrctx->yystack.l_base);
            memcpy (yystack.l_base, yyerrctx->yystack.l_base, (size_t) (yystack.l_mark - yystack.l_base + 1) * sizeof(YYSTYPE));
#if defined(YYLTYPE) || defined(YYLTYPE_IS_DECLARED)
            yystack.p_mark = yystack.p_base + (yyerrctx->yystack.p_mark - yyerrctx->yystack.p_base);
            memcpy (yystack.p_base, yyerrctx->yystack.p_base, (size_t) (yystack.p_mark - yystack.p_base + 1) * sizeof(YYLTYPE));
#endif
            yystate        = yyerrctx->state;
            yyFreeState(yyerrctx);
            yyerrctx       = NULL;
        }
        yynewerrflag = 1;
    }
    if (yynewerrflag == 0) goto yyinrecovery;
#endif /* YYBTYACC */

    YYERROR_CALL("syntax error");
#if defined(YYLTYPE) || defined(YYLTYPE_IS_DECLARED)
    yyerror_loc_range[1] = yylloc; /* lookahead position is error start position */
#endif

#if !YYBTYACC
    goto yyerrlab; /* redundant goto avoids 'unused label' warning */
yyerrlab:
#endif
    ++yynerrs;

yyinrecovery:
    if (yyerrflag < 3)
    {
        yyerrflag = 3;
        for (;;)
        {
            if (((yyn = yysindex[*yystack.s_mark]) != 0) && (yyn += YYERRCODE) >= 0 &&
                    yyn <= YYTABLESIZE && yycheck[yyn] == (YYINT) YYERRCODE)
            {
#if YYDEBUG
                if (yydebug)
                    fprintf(stderr, "%s[%d]: state %d, error recovery shifting to state %d\n",
                                    YYDEBUGSTR, yydepth, *yystack.s_mark, yytable[yyn]);
#endif
                if (yystack.s_mark >= yystack.s_last && yygrowstack(&yystack) == YYENOMEM) goto yyoverflow;
                yystate = yytable[yyn];
                *++yystack.s_mark = yytable[yyn];
                *++yystack.l_mark = yylval;
#if defined(YYLTYPE) || defined(YYLTYPE_IS_DECLARED)
                /* lookahead position is error end position */
                yyerror_loc_range[2] = yylloc;
                YYLLOC_DEFAULT(yyloc, yyerror_loc_range, 2); /* position of error span */
                *++yystack.p_mark = yyloc;
#endif
                goto yyloop;
            }
            else
            {
#if YYDEBUG
                if (yydebug)
                    fprintf(stderr, "%s[%d]: error recovery discarding state %d\n",
                                    YYDEBUGSTR, yydepth, *yystack.s_mark);
#endif
                if (yystack.s_mark <= yystack.s_base) goto yyabort;
#if defined(YYLTYPE) || defined(YYLTYPE_IS_DECLARED)
                /* the current TOS position is the error start position */
                yyerror_loc_range[1] = *yystack.p_mark;
#endif
#if defined(YYDESTRUCT_CALL)
#if YYBTYACC
                if (!yytrial)
#endif /* YYBTYACC */
#if defined(YYLTYPE) || defined(YYLTYPE_IS_DECLARED)
                    YYDESTRUCT_CALL("error: discarding state",
                                    yystos[*yystack.s_mark], yystack.l_mark, yystack.p_mark);
#else
                    YYDESTRUCT_CALL("error: discarding state",
                                    yystos[*yystack.s_mark], yystack.l_mark);
#endif /* defined(YYLTYPE) || defined(YYLTYPE_IS_DECLARED) */
#endif /* defined(YYDESTRUCT_CALL) */
                --yystack.s_mark;
                --yystack.l_mark;
#if defined(YYLTYPE) || defined(YYLTYPE_IS_DECLARED)
                --yystack.p_mark;
#endif
            }
        }
    }
    else
    {
        if (yychar == YYEOF) goto yyabort;
#if YYDEBUG
        if (yydebug)
        {
            if ((yys = yyname[YYTRANSLATE(yychar)]) == NULL) yys = yyname[YYUNDFTOKEN];
            fprintf(stderr, "%s[%d]: state %d, error recovery discarding token %d (%s)\n",
                            YYDEBUGSTR, yydepth, yystate, yychar, yys);
        }
#endif
#if defined(YYDESTRUCT_CALL)
#if YYBTYACC
        if (!yytrial)
#endif /* YYBTYACC */
#if defined(YYLTYPE) || defined(YYLTYPE_IS_DECLARED)
            YYDESTRUCT_CALL("error: discarding token", yychar, &yylval, &yylloc);
#else
            YYDESTRUCT_CALL("error: discarding token", yychar, &yylval);
#endif /* defined(YYLTYPE) || defined(YYLTYPE_IS_DECLARED) */
#endif /* defined(YYDESTRUCT_CALL) */
        yychar = YYEMPTY;
        goto yyloop;
    }

yyreduce:
    yym = yylen[yyn];
#if YYDEBUG
    if (yydebug)
    {
        fprintf(stderr, "%s[%d]: state %d, reducing by rule %d (%s)",
                        YYDEBUGSTR, yydepth, yystate, yyn, yyrule[yyn]);
#ifdef YYSTYPE_TOSTRING
#if YYBTYACC
        if (!yytrial)
#endif /* YYBTYACC */
            if (yym > 0)
            {
                int i;
                fputc('<', stderr);
                for (i = yym; i > 0; i--)
                {
                    if (i != yym) fputs(", ", stderr);
                    fputs(YYSTYPE_TOSTRING(yystos[yystack.s_mark[1-i]],
                                           yystack.l_mark[1-i]), stderr);
                }
                fputc('>', stderr);
            }
#endif
        fputc('\n', stderr);
    }
#endif
    if (yym > 0)
        yyval = yystack.l_mark[1-yym];
    else
        memset(&yyval, 0, sizeof yyval);
#if defined(YYLTYPE) || defined(YYLTYPE_IS_DECLARED)

    /* Perform position reduction */
    memset(&yyloc, 0, sizeof(yyloc));
#if YYBTYACC
    if (!yytrial)
#endif /* YYBTYACC */
    {
        YYLLOC_DEFAULT(yyloc, &yystack.p_mark[-yym], yym);
        /* just in case YYERROR is invoked within the action, save
           the start of the rhs as the error start position */
        yyerror_loc_range[1] = yystack.p_mark[1-yym];
    }
#endif

    switch (yyn)
    {
case 1:
#line 189 "mon_parse.y"
	{ yyval.i = 0; }
#line 3080 "mon_parse.c"
break;
case 2:
#line 190 "mon_parse.y"
	{ yyval.i = 0; }
#line 3085 "mon_parse.c"
break;
case 3:
#line 191 "mon_parse.y"
	{ new_cmd = 1; asm_mode = 0;  yyval.i = 0; }
#line 3090 "mon_parse.c"
break;
case 8:
#line 200 "mon_parse.y"
	{ return ERR_EXPECT_END_CMD; }
#line 3095 "mon_parse.c"
break;
case 21:
#line 215 "mon_parse.y"
	{ return ERR_BAD_CMD; }
#line 3100 "mon_parse.c"
break;
case 22:
#line 219 "mon_parse.y"
	{ mon_bank(e_default_space, NULL); }
#line 3105 "mon_parse.c"
break;
case 23:
#line 221 "mon_parse.y"
	{ mon_bank(yystack.l_mark[-1].i, NULL); }
#line 3110 "mon_parse.c"
break;
case 24:
#line 223 "mon_parse.y"
	{ mon_bank(e_default_space, yystack.l_mark[-1].str); }
#line 3115 "mon_parse.c"
break;
case 25:
#line 225 "mon_parse.y"
	{ mon_bank(yystack.l_mark[-3].i, yystack.l_mark[-1].str); }
#line 3120 "mon_parse.c"
break;
case 26:
#line 227 "mon_parse.y"
	{ mon_jump(yystack.l_mark[-1].a); }
#line 3125 "mon_parse.c"
break;
case 27:
#line 229 "mon_parse.y"
	{ mon_go(); }
#line 3130 "mon_parse.c"
break;
case 28:
#line 231 "mon_parse.y"
	{ mon_display_io_regs(0); }
#line 3135 "mon_parse.c"
break;
case 29:
#line 233 "mon_parse.y"
	{ mon_display_io_regs(yystack.l_mark[-1].a); }
#line 3140 "mon_parse.c"
break;
case 30:
#line 235 "mon_parse.y"
	{ monitor_cpu_type_set(""); }
#line 3145 "mon_parse.c"
break;
case 31:
#line 237 "mon_parse.y"
	{ monitor_cpu_type_set(yystack.l_mark[-1].str); }
#line 3150 "mon_parse.c"
break;
case 32:
#line 239 "mon_parse.y"
	{ mon_cpuhistory(-1,  0,  0,  0,   0,   0); }
#line 3155 "mon_parse.c"
break;
case 33:
#line 241 "mon_parse.y"
	{ mon_cpuhistory(-1, yystack.l_mark[-1].i,  0,  0,   0,   0); }
#line 3160 "mon_parse.c"
break;
case 34:
#line 243 "mon_parse.y"
	{ mon_cpuhistory(-1, yystack.l_mark[-3].i, yystack.l_mark[-1].i,  0,   0,   0); }
#line 3165 "mon_parse.c"
break;
case 35:
#line 245 "mon_parse.y"
	{ mon_cpuhistory(-1, yystack.l_mark[-5].i, yystack.l_mark[-3].i, yystack.l_mark[-1].i,   0,   0); }
#line 3170 "mon_parse.c"
break;
case 36:
#line 247 "mon_parse.y"
	{ mon_cpuhistory(-1, yystack.l_mark[-7].i, yystack.l_mark[-5].i, yystack.l_mark[-3].i,  yystack.l_mark[-1].i,   0); }
#line 3175 "mon_parse.c"
break;
case 37:
#line 249 "mon_parse.y"
	{ mon_cpuhistory(-1, yystack.l_mark[-9].i, yystack.l_mark[-7].i, yystack.l_mark[-5].i,  yystack.l_mark[-3].i, yystack.l_mark[-1].i); }
#line 3180 "mon_parse.c"
break;
case 38:
#line 251 "mon_parse.y"
	{ mon_cpuhistory(yystack.l_mark[-1].i,  0,  0,  0,   0,   0); }
#line 3185 "mon_parse.c"
break;
case 39:
#line 253 "mon_parse.y"
	{ mon_cpuhistory(yystack.l_mark[-3].i, yystack.l_mark[-1].i,  0,  0,   0,   0); }
#line 3190 "mon_parse.c"
break;
case 40:
#line 255 "mon_parse.y"
	{ mon_cpuhistory(yystack.l_mark[-5].i, yystack.l_mark[-3].i, yystack.l_mark[-1].i,  0,   0,   0); }
#line 3195 "mon_parse.c"
break;
case 41:
#line 257 "mon_parse.y"
	{ mon_cpuhistory(yystack.l_mark[-7].i, yystack.l_mark[-5].i, yystack.l_mark[-3].i, yystack.l_mark[-1].i,   0,   0); }
#line 3200 "mon_parse.c"
break;
case 42:
#line 259 "mon_parse.y"
	{ mon_cpuhistory(yystack.l_mark[-9].i, yystack.l_mark[-7].i, yystack.l_mark[-5].i, yystack.l_mark[-3].i, yystack.l_mark[-1].i,   0); }
#line 3205 "mon_parse.c"
break;
case 43:
#line 261 "mon_parse.y"
	{ mon_cpuhistory(yystack.l_mark[-11].i, yystack.l_mark[-9].i, yystack.l_mark[-7].i, yystack.l_mark[-5].i, yystack.l_mark[-3].i, yystack.l_mark[-1].i); }
#line 3210 "mon_parse.c"
break;
case 44:
#line 263 "mon_parse.y"
	{ mon_instruction_return(); }
#line 3215 "mon_parse.c"
break;
case 45:
#line 265 "mon_parse.y"
	{ mon_write_snapshot(yystack.l_mark[-1].str,0,0,0); /* FIXME */ }
#line 3220 "mon_parse.c"
break;
case 46:
#line 267 "mon_parse.y"
	{ mon_read_snapshot(yystack.l_mark[-1].str, 0); }
#line 3225 "mon_parse.c"
break;
case 47:
#line 269 "mon_parse.y"
	{ mon_instructions_step(-1); }
#line 3230 "mon_parse.c"
break;
case 48:
#line 271 "mon_parse.y"
	{ mon_instructions_step(yystack.l_mark[-1].i); }
#line 3235 "mon_parse.c"
break;
case 49:
#line 273 "mon_parse.y"
	{ mon_instructions_next(-1); }
#line 3240 "mon_parse.c"
break;
case 50:
#line 275 "mon_parse.y"
	{ mon_instructions_next(yystack.l_mark[-1].i); }
#line 3245 "mon_parse.c"
break;
case 51:
#line 277 "mon_parse.y"
	{ mon_stack_up(-1); }
#line 3250 "mon_parse.c"
break;
case 52:
#line 279 "mon_parse.y"
	{ mon_stack_up(yystack.l_mark[-1].i); }
#line 3255 "mon_parse.c"
break;
case 53:
#line 281 "mon_parse.y"
	{ mon_stack_down(-1); }
#line 3260 "mon_parse.c"
break;
case 54:
#line 283 "mon_parse.y"
	{ mon_stack_down(yystack.l_mark[-1].i); }
#line 3265 "mon_parse.c"
break;
case 55:
#line 285 "mon_parse.y"
	{ mon_display_screen(-1); }
#line 3270 "mon_parse.c"
break;
case 56:
#line 287 "mon_parse.y"
	{ mon_display_screen(yystack.l_mark[-1].a); }
#line 3275 "mon_parse.c"
break;
case 57:
#line 289 "mon_parse.y"
	{
                        mon_out("Warp mode is %s.\n",
                                vsync_get_warp_mode() ? "on" : "off");
                     }
#line 3283 "mon_parse.c"
break;
case 58:
#line 294 "mon_parse.y"
	{
                        vsync_set_warp_mode(!vsync_get_warp_mode());
                     }
#line 3290 "mon_parse.c"
break;
case 60:
#line 301 "mon_parse.y"
	{ (monitor_cpu_for_memspace[default_memspace]->mon_register_print)(default_memspace); }
#line 3295 "mon_parse.c"
break;
case 61:
#line 303 "mon_parse.y"
	{ (monitor_cpu_for_memspace[yystack.l_mark[-1].i]->mon_register_print)(yystack.l_mark[-1].i); }
#line 3300 "mon_parse.c"
break;
case 63:
#line 308 "mon_parse.y"
	{
                        /* What about the memspace? */
                        mon_playback_commands(yystack.l_mark[-1].str,true);
                    }
#line 3308 "mon_parse.c"
break;
case 64:
#line 313 "mon_parse.y"
	{
                        /* What about the memspace? */
                        mon_playback_commands(yystack.l_mark[-1].str,true);
                    }
#line 3316 "mon_parse.c"
break;
case 65:
#line 318 "mon_parse.y"
	{ mon_save_symbols(yystack.l_mark[-3].i, yystack.l_mark[-1].str); }
#line 3321 "mon_parse.c"
break;
case 66:
#line 320 "mon_parse.y"
	{ mon_save_symbols(e_default_space, yystack.l_mark[-1].str); }
#line 3326 "mon_parse.c"
break;
case 67:
#line 322 "mon_parse.y"
	{ mon_add_name_to_symbol_table(yystack.l_mark[-3].a, yystack.l_mark[-1].str); }
#line 3331 "mon_parse.c"
break;
case 68:
#line 324 "mon_parse.y"
	{ mon_remove_name_from_symbol_table(e_default_space, yystack.l_mark[-1].str); }
#line 3336 "mon_parse.c"
break;
case 69:
#line 326 "mon_parse.y"
	{ mon_remove_name_from_symbol_table(yystack.l_mark[-3].i, yystack.l_mark[-1].str); }
#line 3341 "mon_parse.c"
break;
case 70:
#line 328 "mon_parse.y"
	{ mon_print_symbol_table(yystack.l_mark[-1].i); }
#line 3346 "mon_parse.c"
break;
case 71:
#line 330 "mon_parse.y"
	{ mon_print_symbol_table(e_default_space); }
#line 3351 "mon_parse.c"
break;
case 72:
#line 332 "mon_parse.y"
	{ mon_clear_symbol_table(yystack.l_mark[-1].i); }
#line 3356 "mon_parse.c"
break;
case 73:
#line 334 "mon_parse.y"
	{ mon_clear_symbol_table(e_default_space); }
#line 3361 "mon_parse.c"
break;
case 74:
#line 336 "mon_parse.y"
	{
                        mon_add_name_to_symbol_table(yystack.l_mark[-1].a, mon_prepend_dot_to_name(yystack.l_mark[-3].str));
                    }
#line 3368 "mon_parse.c"
break;
case 75:
#line 340 "mon_parse.y"
	{
                        mon_add_name_to_symbol_table(yystack.l_mark[-2].a, mon_prepend_dot_to_name(yystack.l_mark[-4].str));
                    }
#line 3375 "mon_parse.c"
break;
case 76:
#line 346 "mon_parse.y"
	{ mon_start_assemble_mode(yystack.l_mark[0].a, NULL); }
#line 3380 "mon_parse.c"
break;
case 77:
#line 347 "mon_parse.y"
	{ }
#line 3385 "mon_parse.c"
break;
case 78:
#line 349 "mon_parse.y"
	{ mon_start_assemble_mode(yystack.l_mark[-1].a, NULL); }
#line 3390 "mon_parse.c"
break;
case 79:
#line 351 "mon_parse.y"
	{ mon_disassemble_lines(yystack.l_mark[-1].range[0], yystack.l_mark[-1].range[1]); }
#line 3395 "mon_parse.c"
break;
case 80:
#line 353 "mon_parse.y"
	{ mon_disassemble_lines(BAD_ADDR, BAD_ADDR); }
#line 3400 "mon_parse.c"
break;
case 81:
#line 357 "mon_parse.y"
	{ mon_memory_move(yystack.l_mark[-3].range[0], yystack.l_mark[-3].range[1], yystack.l_mark[-1].a); }
#line 3405 "mon_parse.c"
break;
case 82:
#line 359 "mon_parse.y"
	{ mon_memory_compare(yystack.l_mark[-3].range[0], yystack.l_mark[-3].range[1], yystack.l_mark[-1].a); }
#line 3410 "mon_parse.c"
break;
case 83:
#line 361 "mon_parse.y"
	{ mon_memory_fill(yystack.l_mark[-3].range[0], yystack.l_mark[-3].range[1],(unsigned char *)yystack.l_mark[-1].str); }
#line 3415 "mon_parse.c"
break;
case 84:
#line 363 "mon_parse.y"
	{ mon_memory_hunt(yystack.l_mark[-3].range[0], yystack.l_mark[-3].range[1],(unsigned char *)yystack.l_mark[-1].str); }
#line 3420 "mon_parse.c"
break;
case 85:
#line 365 "mon_parse.y"
	{ mon_memory_display(yystack.l_mark[-3].rt, yystack.l_mark[-1].range[0], yystack.l_mark[-1].range[1], DF_PETSCII); }
#line 3425 "mon_parse.c"
break;
case 86:
#line 367 "mon_parse.y"
	{ mon_memory_display(default_radix, yystack.l_mark[-1].range[0], yystack.l_mark[-1].range[1], DF_PETSCII); }
#line 3430 "mon_parse.c"
break;
case 87:
#line 369 "mon_parse.y"
	{ mon_memory_display(default_radix, BAD_ADDR, BAD_ADDR, DF_PETSCII); }
#line 3435 "mon_parse.c"
break;
case 88:
#line 371 "mon_parse.y"
	{ mon_memory_display_data(yystack.l_mark[-1].range[0], yystack.l_mark[-1].range[1], 8, 8); }
#line 3440 "mon_parse.c"
break;
case 89:
#line 373 "mon_parse.y"
	{ mon_memory_display_data(BAD_ADDR, BAD_ADDR, 8, 8); }
#line 3445 "mon_parse.c"
break;
case 90:
#line 375 "mon_parse.y"
	{ mon_memory_display_data(yystack.l_mark[-1].range[0], yystack.l_mark[-1].range[1], 24, 21); }
#line 3450 "mon_parse.c"
break;
case 91:
#line 377 "mon_parse.y"
	{ mon_memory_display_data(BAD_ADDR, BAD_ADDR, 24, 21); }
#line 3455 "mon_parse.c"
break;
case 92:
#line 379 "mon_parse.y"
	{ mon_memory_display(0, yystack.l_mark[-1].range[0], yystack.l_mark[-1].range[1], DF_PETSCII); }
#line 3460 "mon_parse.c"
break;
case 93:
#line 381 "mon_parse.y"
	{ mon_memory_display(0, BAD_ADDR, BAD_ADDR, DF_PETSCII); }
#line 3465 "mon_parse.c"
break;
case 94:
#line 383 "mon_parse.y"
	{ mon_memory_display(0, yystack.l_mark[-1].range[0], yystack.l_mark[-1].range[1], DF_SCREEN_CODE); }
#line 3470 "mon_parse.c"
break;
case 95:
#line 385 "mon_parse.y"
	{ mon_memory_display(0, BAD_ADDR, BAD_ADDR, DF_SCREEN_CODE); }
#line 3475 "mon_parse.c"
break;
case 96:
#line 387 "mon_parse.y"
	{ mon_memmap_zap(); }
#line 3480 "mon_parse.c"
break;
case 97:
#line 389 "mon_parse.y"
	{ mon_memmap_show(-1,BAD_ADDR,BAD_ADDR); }
#line 3485 "mon_parse.c"
break;
case 98:
#line 391 "mon_parse.y"
	{ mon_memmap_show(yystack.l_mark[-1].i,BAD_ADDR,BAD_ADDR); }
#line 3490 "mon_parse.c"
break;
case 99:
#line 393 "mon_parse.y"
	{ mon_memmap_show(yystack.l_mark[-2].i,yystack.l_mark[-1].range[0],yystack.l_mark[-1].range[1]); }
#line 3495 "mon_parse.c"
break;
case 100:
#line 395 "mon_parse.y"
	{ mon_memmap_save(yystack.l_mark[-3].str,yystack.l_mark[-1].i); }
#line 3500 "mon_parse.c"
break;
case 101:
#line 399 "mon_parse.y"
	{
                      if (yystack.l_mark[-3].i) {
                          temp = mon_breakpoint_add_checkpoint(yystack.l_mark[-2].range[0], yystack.l_mark[-2].range[1], TRUE, yystack.l_mark[-3].i, FALSE, TRUE);
                      } else {
                          temp = mon_breakpoint_add_checkpoint(yystack.l_mark[-2].range[0], yystack.l_mark[-2].range[1], TRUE, e_exec, FALSE, TRUE);
                      }
                      mon_breakpoint_set_checkpoint_condition(temp, yystack.l_mark[-1].cond_node);
                  }
#line 3512 "mon_parse.c"
break;
case 102:
#line 408 "mon_parse.y"
	{ mon_breakpoint_print_checkpoints(); }
#line 3517 "mon_parse.c"
break;
case 103:
#line 411 "mon_parse.y"
	{
                      mon_breakpoint_add_checkpoint(yystack.l_mark[-1].range[0], yystack.l_mark[-1].range[1], TRUE, e_exec, TRUE, TRUE);
                  }
#line 3524 "mon_parse.c"
break;
case 104:
#line 415 "mon_parse.y"
	{ mon_breakpoint_print_checkpoints(); }
#line 3529 "mon_parse.c"
break;
case 105:
#line 418 "mon_parse.y"
	{
                      if (yystack.l_mark[-3].i) {
                          temp = mon_breakpoint_add_checkpoint(yystack.l_mark[-2].range[0], yystack.l_mark[-2].range[1], TRUE, yystack.l_mark[-3].i, FALSE, TRUE);
                      } else {
                          temp = mon_breakpoint_add_checkpoint(yystack.l_mark[-2].range[0], yystack.l_mark[-2].range[1], TRUE, e_load | e_store, FALSE, TRUE);
                      }
                      mon_breakpoint_set_checkpoint_condition(temp, yystack.l_mark[-1].cond_node);
                  }
#line 3541 "mon_parse.c"
break;
case 106:
#line 427 "mon_parse.y"
	{ mon_breakpoint_print_checkpoints(); }
#line 3546 "mon_parse.c"
break;
case 107:
#line 430 "mon_parse.y"
	{
                      if (yystack.l_mark[-3].i) {
                          temp = mon_breakpoint_add_checkpoint(yystack.l_mark[-2].range[0], yystack.l_mark[-2].range[1], FALSE, yystack.l_mark[-3].i, FALSE, TRUE);
                      } else {
                          temp = mon_breakpoint_add_checkpoint(yystack.l_mark[-2].range[0], yystack.l_mark[-2].range[1], FALSE, e_exec | e_load | e_store, FALSE, TRUE);
                      }
                      mon_breakpoint_set_checkpoint_condition(temp, yystack.l_mark[-1].cond_node);
                  }
#line 3558 "mon_parse.c"
break;
case 108:
#line 439 "mon_parse.y"
	{ mon_breakpoint_print_checkpoints(); }
#line 3563 "mon_parse.c"
break;
case 109:
#line 444 "mon_parse.y"
	{ mon_breakpoint_switch_checkpoint(e_ON, yystack.l_mark[-1].i); }
#line 3568 "mon_parse.c"
break;
case 110:
#line 446 "mon_parse.y"
	{ mon_breakpoint_switch_checkpoint(e_ON, -1); }
#line 3573 "mon_parse.c"
break;
case 111:
#line 448 "mon_parse.y"
	{ mon_breakpoint_switch_checkpoint(e_OFF, yystack.l_mark[-1].i); }
#line 3578 "mon_parse.c"
break;
case 112:
#line 450 "mon_parse.y"
	{ mon_breakpoint_switch_checkpoint(e_OFF, -1); }
#line 3583 "mon_parse.c"
break;
case 113:
#line 452 "mon_parse.y"
	{ mon_breakpoint_set_ignore_count(yystack.l_mark[-1].i, -1); }
#line 3588 "mon_parse.c"
break;
case 114:
#line 454 "mon_parse.y"
	{ mon_breakpoint_set_ignore_count(yystack.l_mark[-3].i, yystack.l_mark[-1].i); }
#line 3593 "mon_parse.c"
break;
case 115:
#line 456 "mon_parse.y"
	{ mon_breakpoint_delete_checkpoint(yystack.l_mark[-1].i); }
#line 3598 "mon_parse.c"
break;
case 116:
#line 458 "mon_parse.y"
	{ mon_breakpoint_delete_checkpoint(-1); }
#line 3603 "mon_parse.c"
break;
case 117:
#line 460 "mon_parse.y"
	{ mon_breakpoint_set_checkpoint_condition(yystack.l_mark[-3].i, yystack.l_mark[-1].cond_node); }
#line 3608 "mon_parse.c"
break;
case 118:
#line 462 "mon_parse.y"
	{ mon_breakpoint_set_checkpoint_command(yystack.l_mark[-3].i, yystack.l_mark[-1].str); }
#line 3613 "mon_parse.c"
break;
case 119:
#line 464 "mon_parse.y"
	{ return ERR_EXPECT_STRING; }
#line 3618 "mon_parse.c"
break;
case 120:
#line 468 "mon_parse.y"
	{ sidefx = ((yystack.l_mark[-1].action == e_TOGGLE) ? (sidefx ^ 1) : yystack.l_mark[-1].action); }
#line 3623 "mon_parse.c"
break;
case 121:
#line 470 "mon_parse.y"
	{
                         mon_out("I/O side effects are %s\n",
                                   sidefx ? "enabled" : "disabled");
                     }
#line 3631 "mon_parse.c"
break;
case 122:
#line 475 "mon_parse.y"
	{ 
                         break_on_dummy_access = ((yystack.l_mark[-1].action == e_TOGGLE) ? (break_on_dummy_access ^ 1) : yystack.l_mark[-1].action); 
                         /* FIXME: some day we might want to toggle the break-on-dummy-access 
                                   per MEMSPACE, for now its a global option */                         
                         mon_breakpoint_set_dummy_state(e_default_space, break_on_dummy_access);
                     }
#line 3641 "mon_parse.c"
break;
case 123:
#line 482 "mon_parse.y"
	{
                         mon_out("Checkpoints will %strigger on dummy accesses.\n",
                                   break_on_dummy_access ? "" : "not ");
                         /* FIXME: some day we might want to toggle the break-on-dummy-access 
                                   per MEMSPACE, for now its a global option */                         
                         mon_breakpoint_set_dummy_state(e_default_space, break_on_dummy_access);
                     }
#line 3652 "mon_parse.c"
break;
case 124:
#line 490 "mon_parse.y"
	{ 
                        int logenabled;
                        resources_get_int("MonitorLogEnabled", &logenabled);
                        logenabled = ((yystack.l_mark[-1].action == e_TOGGLE) ? (logenabled ^ 1) : yystack.l_mark[-1].action);
                        resources_set_int("MonitorLogEnabled", logenabled);
                     }
#line 3662 "mon_parse.c"
break;
case 125:
#line 497 "mon_parse.y"
	{
                         int logenabled;
                         const char *logfilename;
                         resources_get_int("MonitorLogEnabled", &logenabled);
                         resources_get_string("MonitorLogFileName", &logfilename);
                         if (logenabled) {
                            mon_out("Logging to '%s' is enabled.\n", logfilename);
                         } else {
                            mon_out("Logging is disabled.\n");
                         }
                     }
#line 3677 "mon_parse.c"
break;
case 126:
#line 509 "mon_parse.y"
	{ 
                        resources_set_string("MonitorLogFileName", yystack.l_mark[-1].str);
                     }
#line 3684 "mon_parse.c"
break;
case 127:
#line 513 "mon_parse.y"
	{ default_radix = yystack.l_mark[-1].rt; }
#line 3689 "mon_parse.c"
break;
case 128:
#line 515 "mon_parse.y"
	{
                         const char *p;

                         if (default_radix == e_hexadecimal)
                             p = "Hexadecimal";
                         else if (default_radix == e_decimal)
                             p = "Decimal";
                         else if (default_radix == e_octal)
                             p = "Octal";
                         else if (default_radix == e_binary)
                             p = "Binary";
                         else
                             p = "Unknown";

                         mon_out("Default radix is %s\n", p);
                     }
#line 3709 "mon_parse.c"
break;
case 129:
#line 533 "mon_parse.y"
	{ monitor_change_device(e_default_space); }
#line 3714 "mon_parse.c"
break;
case 130:
#line 535 "mon_parse.y"
	{ monitor_change_device(yystack.l_mark[-1].i); }
#line 3719 "mon_parse.c"
break;
case 131:
#line 537 "mon_parse.y"
	{ mon_export(); }
#line 3724 "mon_parse.c"
break;
case 132:
#line 539 "mon_parse.y"
	{ mon_quit(); YYACCEPT; }
#line 3729 "mon_parse.c"
break;
case 133:
#line 541 "mon_parse.y"
	{ mon_exit(); YYACCEPT; }
#line 3734 "mon_parse.c"
break;
case 134:
#line 543 "mon_parse.y"
	{ mon_maincpu_trace(); }
#line 3739 "mon_parse.c"
break;
case 135:
#line 545 "mon_parse.y"
	{ mon_maincpu_toggle_trace(yystack.l_mark[-1].action); }
#line 3744 "mon_parse.c"
break;
case 136:
#line 549 "mon_parse.y"
	{ mon_drive_execute_disk_cmd(yystack.l_mark[-1].str); }
#line 3749 "mon_parse.c"
break;
case 137:
#line 551 "mon_parse.y"
	{ mon_out("\t%d\n",yystack.l_mark[-1].i); }
#line 3754 "mon_parse.c"
break;
case 138:
#line 553 "mon_parse.y"
	{ mon_command_print_help(NULL); }
#line 3759 "mon_parse.c"
break;
case 139:
#line 555 "mon_parse.y"
	{ mon_command_print_help(yystack.l_mark[-1].str); }
#line 3764 "mon_parse.c"
break;
case 140:
#line 557 "mon_parse.y"
	{ mon_print_convert(yystack.l_mark[-1].i); }
#line 3769 "mon_parse.c"
break;
case 141:
#line 559 "mon_parse.y"
	{ mon_change_dir(yystack.l_mark[-1].str); }
#line 3774 "mon_parse.c"
break;
case 142:
#line 561 "mon_parse.y"
	{ mon_keyboard_feed(yystack.l_mark[-1].str); }
#line 3779 "mon_parse.c"
break;
case 143:
#line 563 "mon_parse.y"
	{ mon_backtrace(); }
#line 3784 "mon_parse.c"
break;
case 144:
#line 565 "mon_parse.y"
	{ mon_show_dir(yystack.l_mark[-1].str); }
#line 3789 "mon_parse.c"
break;
case 145:
#line 567 "mon_parse.y"
	{ mon_show_pwd(); }
#line 3794 "mon_parse.c"
break;
case 146:
#line 569 "mon_parse.y"
	{ mon_make_dir(yystack.l_mark[-1].str); }
#line 3799 "mon_parse.c"
break;
case 147:
#line 571 "mon_parse.y"
	{ mon_remove_dir(yystack.l_mark[-1].str); }
#line 3804 "mon_parse.c"
break;
case 148:
#line 573 "mon_parse.y"
	{ mon_screenshot_save(yystack.l_mark[-1].str,-1); }
#line 3809 "mon_parse.c"
break;
case 149:
#line 575 "mon_parse.y"
	{ mon_screenshot_save(yystack.l_mark[-3].str,yystack.l_mark[-1].i); }
#line 3814 "mon_parse.c"
break;
case 150:
#line 577 "mon_parse.y"
	{ mon_resource_get(yystack.l_mark[-1].str); }
#line 3819 "mon_parse.c"
break;
case 151:
#line 579 "mon_parse.y"
	{ mon_resource_set(yystack.l_mark[-2].str,yystack.l_mark[-1].str); }
#line 3824 "mon_parse.c"
break;
case 152:
#line 581 "mon_parse.y"
	{ resources_load(yystack.l_mark[-1].str); }
#line 3829 "mon_parse.c"
break;
case 153:
#line 583 "mon_parse.y"
	{ resources_save(yystack.l_mark[-1].str); }
#line 3834 "mon_parse.c"
break;
case 154:
#line 585 "mon_parse.y"
	{ mon_reset_machine(-1); }
#line 3839 "mon_parse.c"
break;
case 155:
#line 587 "mon_parse.y"
	{ mon_reset_machine(yystack.l_mark[-1].i); }
#line 3844 "mon_parse.c"
break;
case 156:
#line 589 "mon_parse.y"
	{ mon_tape_ctrl(TAPEPORT_PORT_1, yystack.l_mark[-1].i); }
#line 3849 "mon_parse.c"
break;
case 157:
#line 591 "mon_parse.y"
	{ mon_cart_freeze(); }
#line 3854 "mon_parse.c"
break;
case 158:
#line 593 "mon_parse.y"
	{ mon_userport_set_output(yystack.l_mark[-1].i); }
#line 3859 "mon_parse.c"
break;
case 159:
#line 595 "mon_parse.y"
	{ mon_joyport_set_output(yystack.l_mark[-2].i, yystack.l_mark[-1].i); }
#line 3864 "mon_parse.c"
break;
case 160:
#line 597 "mon_parse.y"
	{ }
#line 3869 "mon_parse.c"
break;
case 161:
#line 599 "mon_parse.y"
	{ mon_stopwatch_reset(); }
#line 3874 "mon_parse.c"
break;
case 162:
#line 601 "mon_parse.y"
	{ mon_stopwatch_show("Stopwatch: ", "\n"); }
#line 3879 "mon_parse.c"
break;
case 163:
#line 603 "mon_parse.y"
	{ mon_profile_action(yystack.l_mark[-1].action); }
#line 3884 "mon_parse.c"
break;
case 164:
#line 605 "mon_parse.y"
	{ mon_profile(); }
#line 3889 "mon_parse.c"
break;
case 165:
#line 607 "mon_parse.y"
	{ mon_profile_flat(yystack.l_mark[-1].i); }
#line 3894 "mon_parse.c"
break;
case 166:
#line 609 "mon_parse.y"
	{ mon_profile_graph(yystack.l_mark[-1].i, -1); }
#line 3899 "mon_parse.c"
break;
case 167:
#line 611 "mon_parse.y"
	{ mon_profile_graph(yystack.l_mark[-3].i, yystack.l_mark[-1].i); }
#line 3904 "mon_parse.c"
break;
case 168:
#line 613 "mon_parse.y"
	{ mon_profile_func(yystack.l_mark[-1].a); }
#line 3909 "mon_parse.c"
break;
case 169:
#line 615 "mon_parse.y"
	{ mon_profile_disass(yystack.l_mark[-1].a); }
#line 3914 "mon_parse.c"
break;
case 170:
#line 617 "mon_parse.y"
	{ mon_profile_clear(yystack.l_mark[-1].a); }
#line 3919 "mon_parse.c"
break;
case 171:
#line 619 "mon_parse.y"
	{ mon_profile_disass_context(yystack.l_mark[-1].i); }
#line 3924 "mon_parse.c"
break;
case 172:
#line 623 "mon_parse.y"
	{ mon_file_load(yystack.l_mark[-3].str, yystack.l_mark[-2].i, yystack.l_mark[-1].a, FALSE, FALSE); }
#line 3929 "mon_parse.c"
break;
case 173:
#line 625 "mon_parse.y"
	{ mon_file_load(yystack.l_mark[-3].str, yystack.l_mark[-2].i, yystack.l_mark[-1].a, FALSE, TRUE); }
#line 3934 "mon_parse.c"
break;
case 174:
#line 627 "mon_parse.y"
	{ mon_file_load(yystack.l_mark[-3].str, yystack.l_mark[-2].i, yystack.l_mark[-1].a, TRUE, FALSE); }
#line 3939 "mon_parse.c"
break;
case 175:
#line 629 "mon_parse.y"
	{ return ERR_EXPECT_ADDRESS; }
#line 3944 "mon_parse.c"
break;
case 176:
#line 631 "mon_parse.y"
	{ mon_file_save(yystack.l_mark[-3].str, yystack.l_mark[-2].i, yystack.l_mark[-1].range[0], yystack.l_mark[-1].range[1], FALSE); }
#line 3949 "mon_parse.c"
break;
case 177:
#line 633 "mon_parse.y"
	{ return ERR_EXPECT_DEVICE_NUM; }
#line 3954 "mon_parse.c"
break;
case 178:
#line 635 "mon_parse.y"
	{ return ERR_EXPECT_ADDRESS; }
#line 3959 "mon_parse.c"
break;
case 179:
#line 637 "mon_parse.y"
	{ mon_file_save(yystack.l_mark[-3].str, yystack.l_mark[-2].i, yystack.l_mark[-1].range[0], yystack.l_mark[-1].range[1], TRUE); }
#line 3964 "mon_parse.c"
break;
case 180:
#line 639 "mon_parse.y"
	{ return ERR_EXPECT_ADDRESS; }
#line 3969 "mon_parse.c"
break;
case 181:
#line 641 "mon_parse.y"
	{ mon_file_verify(yystack.l_mark[-3].str,yystack.l_mark[-2].i,yystack.l_mark[-1].a,FALSE); }
#line 3974 "mon_parse.c"
break;
case 182:
#line 643 "mon_parse.y"
	{ mon_file_verify(yystack.l_mark[-3].str,yystack.l_mark[-2].i,yystack.l_mark[-1].a,TRUE); }
#line 3979 "mon_parse.c"
break;
case 183:
#line 645 "mon_parse.y"
	{ return ERR_EXPECT_ADDRESS; }
#line 3984 "mon_parse.c"
break;
case 184:
#line 647 "mon_parse.y"
	{ mon_drive_block_cmd(0,yystack.l_mark[-3].i,yystack.l_mark[-2].i,yystack.l_mark[-1].a); }
#line 3989 "mon_parse.c"
break;
case 185:
#line 649 "mon_parse.y"
	{ mon_drive_block_cmd(1,yystack.l_mark[-3].i,yystack.l_mark[-2].i,yystack.l_mark[-1].a); }
#line 3994 "mon_parse.c"
break;
case 186:
#line 651 "mon_parse.y"
	{ mon_drive_list(-1); }
#line 3999 "mon_parse.c"
break;
case 187:
#line 653 "mon_parse.y"
	{ mon_drive_list(yystack.l_mark[-1].i); }
#line 4004 "mon_parse.c"
break;
case 188:
#line 655 "mon_parse.y"
	{ mon_attach(yystack.l_mark[-2].str,yystack.l_mark[-1].i); }
#line 4009 "mon_parse.c"
break;
case 189:
#line 657 "mon_parse.y"
	{ mon_detach(yystack.l_mark[-1].i); }
#line 4014 "mon_parse.c"
break;
case 190:
#line 659 "mon_parse.y"
	{ mon_autostart(yystack.l_mark[-1].str,0,1); }
#line 4019 "mon_parse.c"
break;
case 191:
#line 661 "mon_parse.y"
	{ mon_autostart(yystack.l_mark[-3].str,yystack.l_mark[-1].i,1); }
#line 4024 "mon_parse.c"
break;
case 192:
#line 663 "mon_parse.y"
	{ mon_autostart(yystack.l_mark[-1].str,0,0); }
#line 4029 "mon_parse.c"
break;
case 193:
#line 665 "mon_parse.y"
	{ mon_autostart(yystack.l_mark[-3].str,yystack.l_mark[-1].i,0); }
#line 4034 "mon_parse.c"
break;
case 194:
#line 669 "mon_parse.y"
	{ mon_record_commands(yystack.l_mark[-1].str); }
#line 4039 "mon_parse.c"
break;
case 195:
#line 671 "mon_parse.y"
	{ mon_end_recording(); }
#line 4044 "mon_parse.c"
break;
case 196:
#line 673 "mon_parse.y"
	{ mon_playback_commands(yystack.l_mark[-1].str,true); }
#line 4049 "mon_parse.c"
break;
case 197:
#line 677 "mon_parse.y"
	{ mon_memory_fill(yystack.l_mark[-2].a, BAD_ADDR, (unsigned char *)yystack.l_mark[-1].str); }
#line 4054 "mon_parse.c"
break;
case 198:
#line 679 "mon_parse.y"
	{ printf("Not yet.\n"); }
#line 4059 "mon_parse.c"
break;
case 199:
#line 683 "mon_parse.y"
	{
#if YYDEBUG
                     yydebug = 1;
#endif
                     }
#line 4068 "mon_parse.c"
break;
case 200:
#line 690 "mon_parse.y"
	{ yyval.str = yystack.l_mark[0].str; }
#line 4073 "mon_parse.c"
break;
case 201:
#line 693 "mon_parse.y"
	{ yyval.str = yystack.l_mark[0].str; }
#line 4078 "mon_parse.c"
break;
case 202:
#line 694 "mon_parse.y"
	{ yyval.str = NULL; }
#line 4083 "mon_parse.c"
break;
case 203:
#line 697 "mon_parse.y"
	{ yyval.str = yystack.l_mark[0].str; }
#line 4088 "mon_parse.c"
break;
case 205:
#line 701 "mon_parse.y"
	{ return ERR_EXPECT_FILENAME; }
#line 4093 "mon_parse.c"
break;
case 207:
#line 705 "mon_parse.y"
	{ return ERR_EXPECT_DEVICE_NUM; }
#line 4098 "mon_parse.c"
break;
case 208:
#line 708 "mon_parse.y"
	{ yyval.i = yystack.l_mark[-1].i | yystack.l_mark[0].i; }
#line 4103 "mon_parse.c"
break;
case 209:
#line 709 "mon_parse.y"
	{ yyval.i = yystack.l_mark[0].i; }
#line 4108 "mon_parse.c"
break;
case 210:
#line 712 "mon_parse.y"
	{ yyval.i = yystack.l_mark[0].i; }
#line 4113 "mon_parse.c"
break;
case 211:
#line 713 "mon_parse.y"
	{ yyval.i = 0; }
#line 4118 "mon_parse.c"
break;
case 212:
#line 716 "mon_parse.y"
	{
                                    if (!mon_register_valid(default_memspace, yystack.l_mark[0].reg)) {
                                        return ERR_INVALID_REGISTER;
                                    }
                                    yyval.i = new_reg(default_memspace, yystack.l_mark[0].reg);
                                }
#line 4128 "mon_parse.c"
break;
case 213:
#line 722 "mon_parse.y"
	{
                                    if (!mon_register_valid(yystack.l_mark[-1].i, yystack.l_mark[0].reg)) {
                                        return ERR_INVALID_REGISTER;
                                    }
                                    yyval.i = new_reg(yystack.l_mark[-1].i, yystack.l_mark[0].reg);
                                }
#line 4138 "mon_parse.c"
break;
case 216:
#line 735 "mon_parse.y"
	{ (monitor_cpu_for_memspace[reg_memspace(yystack.l_mark[-2].i)]->mon_register_set_val)(reg_memspace(yystack.l_mark[-2].i), reg_regid(yystack.l_mark[-2].i), (uint16_t) yystack.l_mark[0].i); }
#line 4143 "mon_parse.c"
break;
case 217:
#line 738 "mon_parse.y"
	{ yyval.i = yystack.l_mark[0].i; }
#line 4148 "mon_parse.c"
break;
case 218:
#line 739 "mon_parse.y"
	{ return ERR_EXPECT_CHECKNUM; }
#line 4153 "mon_parse.c"
break;
case 219:
#line 742 "mon_parse.y"
	{ yyval.i = yystack.l_mark[0].i; }
#line 4158 "mon_parse.c"
break;
case 220:
#line 743 "mon_parse.y"
	{ yyval.i = -1; }
#line 4163 "mon_parse.c"
break;
case 222:
#line 747 "mon_parse.y"
	{ yyval.range[0] = yystack.l_mark[0].a; yyval.range[1] = BAD_ADDR; }
#line 4168 "mon_parse.c"
break;
case 223:
#line 750 "mon_parse.y"
	{ yyval.range[0] = yystack.l_mark[-2].a; yyval.range[1] = yystack.l_mark[0].a; }
#line 4173 "mon_parse.c"
break;
case 224:
#line 752 "mon_parse.y"
	{ if (resolve_range(e_default_space, yyval.range, yystack.l_mark[0].str)) return ERR_ADDR_TOO_BIG; }
#line 4178 "mon_parse.c"
break;
case 225:
#line 754 "mon_parse.y"
	{ if (resolve_range(yystack.l_mark[-2].i, yyval.range, yystack.l_mark[0].str)) return ERR_ADDR_TOO_BIG; }
#line 4183 "mon_parse.c"
break;
case 226:
#line 757 "mon_parse.y"
	{ yyval.a = yystack.l_mark[0].a; }
#line 4188 "mon_parse.c"
break;
case 227:
#line 758 "mon_parse.y"
	{ yyval.a = BAD_ADDR; }
#line 4193 "mon_parse.c"
break;
case 228:
#line 762 "mon_parse.y"
	{
             yyval.a = new_addr(e_default_space,yystack.l_mark[0].i);
             if (opt_asm) new_cmd = asm_mode = 1;
         }
#line 4201 "mon_parse.c"
break;
case 229:
#line 767 "mon_parse.y"
	{
             yyval.a = new_addr(yystack.l_mark[-2].i, yystack.l_mark[0].i);
             if (opt_asm) new_cmd = asm_mode = 1;
         }
#line 4209 "mon_parse.c"
break;
case 230:
#line 772 "mon_parse.y"
	{
             temp = mon_symbol_table_lookup_addr(e_default_space, yystack.l_mark[0].str);
             if (temp >= 0)
                 yyval.a = new_addr(e_default_space, temp);
             else
                 return ERR_UNDEFINED_LABEL;
         }
#line 4220 "mon_parse.c"
break;
case 233:
#line 785 "mon_parse.y"
	{ yyval.i = e_comp_space; }
#line 4225 "mon_parse.c"
break;
case 234:
#line 786 "mon_parse.y"
	{ yyval.i = e_disk8_space; }
#line 4230 "mon_parse.c"
break;
case 235:
#line 787 "mon_parse.y"
	{ yyval.i = e_disk9_space; }
#line 4235 "mon_parse.c"
break;
case 236:
#line 788 "mon_parse.y"
	{ yyval.i = e_disk10_space; }
#line 4240 "mon_parse.c"
break;
case 237:
#line 789 "mon_parse.y"
	{ yyval.i = e_disk11_space; }
#line 4245 "mon_parse.c"
break;
case 238:
#line 792 "mon_parse.y"
	{ yyval.i = yystack.l_mark[0].i; if (!CHECK_ADDR(yystack.l_mark[0].i)) return ERR_ADDR_TOO_BIG; }
#line 4250 "mon_parse.c"
break;
case 239:
#line 794 "mon_parse.y"
	{ yyval.i = yystack.l_mark[0].i; }
#line 4255 "mon_parse.c"
break;
case 240:
#line 796 "mon_parse.y"
	{ yyval.i = yystack.l_mark[-2].i + yystack.l_mark[0].i; }
#line 4260 "mon_parse.c"
break;
case 241:
#line 797 "mon_parse.y"
	{ yyval.i = yystack.l_mark[-2].i - yystack.l_mark[0].i; }
#line 4265 "mon_parse.c"
break;
case 242:
#line 798 "mon_parse.y"
	{ yyval.i = yystack.l_mark[-2].i * yystack.l_mark[0].i; }
#line 4270 "mon_parse.c"
break;
case 243:
#line 799 "mon_parse.y"
	{ yyval.i = (yystack.l_mark[0].i) ? (yystack.l_mark[-2].i / yystack.l_mark[0].i) : 1; }
#line 4275 "mon_parse.c"
break;
case 244:
#line 800 "mon_parse.y"
	{ yyval.i = yystack.l_mark[-1].i; }
#line 4280 "mon_parse.c"
break;
case 245:
#line 801 "mon_parse.y"
	{ return ERR_MISSING_CLOSE_PAREN; }
#line 4285 "mon_parse.c"
break;
case 246:
#line 802 "mon_parse.y"
	{ yyval.i = yystack.l_mark[0].i; }
#line 4290 "mon_parse.c"
break;
case 247:
#line 805 "mon_parse.y"
	{ yyval.cond_node = yystack.l_mark[0].cond_node; }
#line 4295 "mon_parse.c"
break;
case 248:
#line 806 "mon_parse.y"
	{ yyval.cond_node = 0; }
#line 4300 "mon_parse.c"
break;
case 249:
#line 809 "mon_parse.y"
	{
               yyval.cond_node = new_cond; yyval.cond_node->is_parenthized = FALSE;
               yyval.cond_node->child1 = yystack.l_mark[-2].cond_node; yyval.cond_node->child2 = yystack.l_mark[0].cond_node; yyval.cond_node->operation = yystack.l_mark[-1].cond_op;
           }
#line 4308 "mon_parse.c"
break;
case 250:
#line 814 "mon_parse.y"
	{ return ERR_INCOMPLETE_COND_OP; }
#line 4313 "mon_parse.c"
break;
case 251:
#line 816 "mon_parse.y"
	{ yyval.cond_node = yystack.l_mark[-1].cond_node; yyval.cond_node->is_parenthized = TRUE; }
#line 4318 "mon_parse.c"
break;
case 252:
#line 818 "mon_parse.y"
	{ return ERR_MISSING_CLOSE_PAREN; }
#line 4323 "mon_parse.c"
break;
case 253:
#line 820 "mon_parse.y"
	{ yyval.cond_node = yystack.l_mark[0].cond_node; }
#line 4328 "mon_parse.c"
break;
case 254:
#line 823 "mon_parse.y"
	{ yyval.cond_node = new_cond;
                            yyval.cond_node->operation = e_INV;
                            yyval.cond_node->is_parenthized = FALSE;
                            yyval.cond_node->reg_num = yystack.l_mark[0].i; yyval.cond_node->is_reg = TRUE; yyval.cond_node->banknum=-1;
                            yyval.cond_node->child1 = NULL; yyval.cond_node->child2 = NULL;
                          }
#line 4338 "mon_parse.c"
break;
case 255:
#line 829 "mon_parse.y"
	{ yyval.cond_node = new_cond;
                            yyval.cond_node->operation = e_INV;
                            yyval.cond_node->is_parenthized = FALSE;
                            yyval.cond_node->value = yystack.l_mark[0].i; yyval.cond_node->is_reg = FALSE; yyval.cond_node->banknum=-1;
                            yyval.cond_node->child1 = NULL; yyval.cond_node->child2 = NULL;
                          }
#line 4348 "mon_parse.c"
break;
case 256:
#line 836 "mon_parse.y"
	{
                            yyval.cond_node = new_cond;
                            yyval.cond_node->operation = e_INV;
                            yyval.cond_node->is_parenthized = FALSE;
                            yyval.cond_node->banknum = mon_banknum_from_bank(e_default_space, yystack.l_mark[-4].str);
                            if (yyval.cond_node->banknum < 0) {
                                return ERR_ILLEGAL_INPUT;
                            }
                            yyval.cond_node->value = 0;
                            yyval.cond_node->is_reg = FALSE;
                            yyval.cond_node->child1 = yystack.l_mark[-1].cond_node;
                            yyval.cond_node->child2 = NULL;
                        }
#line 4365 "mon_parse.c"
break;
case 257:
#line 849 "mon_parse.y"
	{
                            yyval.cond_node = new_cond;
                            yyval.cond_node->operation = e_INV;
                            yyval.cond_node->is_parenthized = FALSE;
                            yyval.cond_node->banknum = mon_banknum_from_bank(e_default_space, yystack.l_mark[-2].str);
                            if (yyval.cond_node->banknum < 0) {
                                return ERR_ILLEGAL_INPUT;
                            }
                            yyval.cond_node->value = yystack.l_mark[0].a;
                            yyval.cond_node->is_reg = FALSE;
                            yyval.cond_node->child1 = NULL; yyval.cond_node->child2 = NULL;  
                        }
#line 4381 "mon_parse.c"
break;
case 260:
#line 867 "mon_parse.y"
	{ mon_add_number_to_buffer(yystack.l_mark[0].i); }
#line 4386 "mon_parse.c"
break;
case 261:
#line 868 "mon_parse.y"
	{ mon_add_string_to_buffer(yystack.l_mark[0].str); }
#line 4391 "mon_parse.c"
break;
case 264:
#line 875 "mon_parse.y"
	{ mon_add_number_to_buffer(yystack.l_mark[0].i); }
#line 4396 "mon_parse.c"
break;
case 265:
#line 876 "mon_parse.y"
	{ mon_add_number_masked_to_buffer(yystack.l_mark[0].i, 0x00); }
#line 4401 "mon_parse.c"
break;
case 266:
#line 877 "mon_parse.y"
	{ mon_add_string_to_buffer(yystack.l_mark[0].str); }
#line 4406 "mon_parse.c"
break;
case 267:
#line 880 "mon_parse.y"
	{ yyval.i = yystack.l_mark[0].i; }
#line 4411 "mon_parse.c"
break;
case 268:
#line 881 "mon_parse.y"
	{ yyval.i = (monitor_cpu_for_memspace[reg_memspace(yystack.l_mark[0].i)]->mon_register_get_val)(reg_memspace(yystack.l_mark[0].i), reg_regid(yystack.l_mark[0].i)); }
#line 4416 "mon_parse.c"
break;
case 269:
#line 884 "mon_parse.y"
	{ yyval.i = yystack.l_mark[0].i; }
#line 4421 "mon_parse.c"
break;
case 270:
#line 885 "mon_parse.y"
	{ yyval.i = (int)strtol(yystack.l_mark[0].str, NULL, 10); }
#line 4426 "mon_parse.c"
break;
case 271:
#line 886 "mon_parse.y"
	{ yyval.i = (int)strtol(yystack.l_mark[0].str, NULL, 10); }
#line 4431 "mon_parse.c"
break;
case 272:
#line 887 "mon_parse.y"
	{ yyval.i = (int)strtol(yystack.l_mark[0].str, NULL, 10); }
#line 4436 "mon_parse.c"
break;
case 273:
#line 890 "mon_parse.y"
	{ yyval.i = yystack.l_mark[0].i; }
#line 4441 "mon_parse.c"
break;
case 274:
#line 891 "mon_parse.y"
	{ yyval.i = -1; }
#line 4446 "mon_parse.c"
break;
case 275:
#line 894 "mon_parse.y"
	{ yyval.i = resolve_datatype(B_NUMBER,yystack.l_mark[0].str); }
#line 4451 "mon_parse.c"
break;
case 276:
#line 895 "mon_parse.y"
	{ yyval.i = resolve_datatype(D_NUMBER,yystack.l_mark[0].str); }
#line 4456 "mon_parse.c"
break;
case 277:
#line 896 "mon_parse.y"
	{ yyval.i = resolve_datatype(O_NUMBER,yystack.l_mark[0].str); }
#line 4461 "mon_parse.c"
break;
case 278:
#line 899 "mon_parse.y"
	{ yyval.i = yystack.l_mark[0].i; }
#line 4466 "mon_parse.c"
break;
case 279:
#line 900 "mon_parse.y"
	{ yyval.i = yystack.l_mark[0].i; }
#line 4471 "mon_parse.c"
break;
case 280:
#line 901 "mon_parse.y"
	{ yyval.i = yystack.l_mark[0].i; }
#line 4476 "mon_parse.c"
break;
case 281:
#line 902 "mon_parse.y"
	{ yyval.i = yystack.l_mark[0].i; }
#line 4481 "mon_parse.c"
break;
case 282:
#line 903 "mon_parse.y"
	{ yyval.i = yystack.l_mark[0].i; }
#line 4486 "mon_parse.c"
break;
case 286:
#line 911 "mon_parse.y"
	{ yyval.i = 0;
                                                if (yystack.l_mark[-1].str) {
                                                    (monitor_cpu_for_memspace[default_memspace]->mon_assemble_instr)(yystack.l_mark[-1].str, yystack.l_mark[0].mode);
                                                } else {
                                                    new_cmd = 1;
                                                    asm_mode = 0;
                                                }
                                                opt_asm = 0;
                                              }
#line 4499 "mon_parse.c"
break;
case 288:
#line 922 "mon_parse.y"
	{ asm_mode = 0; }
#line 4504 "mon_parse.c"
break;
case 289:
#line 925 "mon_parse.y"
	{ if (yystack.l_mark[0].i > 0xff) {
                          yyval.mode.addr_mode = ASM_ADDR_MODE_IMMEDIATE_16;
                          yyval.mode.param = yystack.l_mark[0].i;
                        } else {
                          yyval.mode.addr_mode = ASM_ADDR_MODE_IMMEDIATE;
                          yyval.mode.param = yystack.l_mark[0].i;
                        } }
#line 4515 "mon_parse.c"
break;
case 290:
#line 932 "mon_parse.y"
	{ if (yystack.l_mark[0].i >= 0x10000) {
               yyval.mode.addr_mode = ASM_ADDR_MODE_ABSOLUTE_LONG;
               yyval.mode.param = yystack.l_mark[0].i;
             } else if (yystack.l_mark[0].i < 0x100) {
               yyval.mode.addr_mode = ASM_ADDR_MODE_ZERO_PAGE;
               yyval.mode.param = yystack.l_mark[0].i;
             } else {
               yyval.mode.addr_mode = ASM_ADDR_MODE_ABSOLUTE;
               yyval.mode.param = yystack.l_mark[0].i;
             }
           }
#line 4530 "mon_parse.c"
break;
case 291:
#line 943 "mon_parse.y"
	{ if (yystack.l_mark[-2].i >= 0x10000) {
                            yyval.mode.addr_mode = ASM_ADDR_MODE_ABSOLUTE_LONG_X;
                            yyval.mode.param = yystack.l_mark[-2].i;
                          } else if (yystack.l_mark[-2].i < 0x100) { 
                            yyval.mode.addr_mode = ASM_ADDR_MODE_ZERO_PAGE_X;
                            yyval.mode.param = yystack.l_mark[-2].i;
                          } else {
                            yyval.mode.addr_mode = ASM_ADDR_MODE_ABSOLUTE_X;
                            yyval.mode.param = yystack.l_mark[-2].i;
                          }
                        }
#line 4545 "mon_parse.c"
break;
case 292:
#line 954 "mon_parse.y"
	{ if (yystack.l_mark[-2].i < 0x100) {
                            yyval.mode.addr_mode = ASM_ADDR_MODE_ZERO_PAGE_Y;
                            yyval.mode.param = yystack.l_mark[-2].i;
                          } else {
                            yyval.mode.addr_mode = ASM_ADDR_MODE_ABSOLUTE_Y;
                            yyval.mode.param = yystack.l_mark[-2].i;
                          }
                        }
#line 4557 "mon_parse.c"
break;
case 293:
#line 962 "mon_parse.y"
	{ if (yystack.l_mark[-2].i < 0x100) {
                            yyval.mode.addr_mode = ASM_ADDR_MODE_STACK_RELATIVE;
                            yyval.mode.param = yystack.l_mark[-2].i;
                          } else { /* 6809 */
                            yyval.mode.addr_mode = ASM_ADDR_MODE_INDEXED;
                            if (yystack.l_mark[-2].i >= -16 && yystack.l_mark[-2].i < 16) {
                                yyval.mode.addr_submode = yystack.l_mark[0].i | (yystack.l_mark[-2].i & 0x1F);
                            } else if (yystack.l_mark[-2].i >= -128 && yystack.l_mark[-2].i < 128) {
                                yyval.mode.addr_submode = 0x80 | yystack.l_mark[0].i | ASM_ADDR_MODE_INDEXED_OFF8;
                                yyval.mode.param = yystack.l_mark[-2].i;
                            } else if (yystack.l_mark[-2].i >= -32768 && yystack.l_mark[-2].i < 32768) {
                                yyval.mode.addr_submode = 0x80 | yystack.l_mark[0].i | ASM_ADDR_MODE_INDEXED_OFF16;
                                yyval.mode.param = yystack.l_mark[-2].i;
                            } else {
                                yyval.mode.addr_mode = ASM_ADDR_MODE_ILLEGAL;
                                mon_out("offset too large even for 16 bits (signed)\n");
                            }
                          }
                        }
#line 4580 "mon_parse.c"
break;
case 294:
#line 981 "mon_parse.y"
	{ if (yystack.l_mark[-2].i < 0x100) {
                            yyval.mode.addr_mode = ASM_ADDR_MODE_DOUBLE;
                            yyval.mode.param = yystack.l_mark[0].i;
                            yyval.mode.addr_submode = yystack.l_mark[-2].i;
                          }
                        }
#line 4590 "mon_parse.c"
break;
case 295:
#line 987 "mon_parse.y"
	{ if (yystack.l_mark[-1].i < 0x100) {
                               yyval.mode.addr_mode = ASM_ADDR_MODE_INDIRECT;
                               yyval.mode.param = yystack.l_mark[-1].i;
                             } else {
                               yyval.mode.addr_mode = ASM_ADDR_MODE_ABS_INDIRECT;
                               yyval.mode.param = yystack.l_mark[-1].i;
                             }
                           }
#line 4602 "mon_parse.c"
break;
case 296:
#line 995 "mon_parse.y"
	{ if (yystack.l_mark[-3].i < 0x100) {
                                           yyval.mode.addr_mode = ASM_ADDR_MODE_INDIRECT_X;
                                           yyval.mode.param = yystack.l_mark[-3].i;
                                         } else {
                                           yyval.mode.addr_mode = ASM_ADDR_MODE_ABS_INDIRECT_X;
                                           yyval.mode.param = yystack.l_mark[-3].i;
                                         }
                                       }
#line 4614 "mon_parse.c"
break;
case 297:
#line 1004 "mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_STACK_RELATIVE_Y; yyval.mode.param = yystack.l_mark[-5].i; }
#line 4619 "mon_parse.c"
break;
case 298:
#line 1006 "mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_INDIRECT_Y; yyval.mode.param = yystack.l_mark[-3].i; }
#line 4624 "mon_parse.c"
break;
case 299:
#line 1007 "mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_REG_IND_BC; }
#line 4629 "mon_parse.c"
break;
case 300:
#line 1008 "mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_REG_IND_DE; }
#line 4634 "mon_parse.c"
break;
case 301:
#line 1009 "mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_REG_IND_HL; }
#line 4639 "mon_parse.c"
break;
case 302:
#line 1010 "mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_REG_IND_IX; }
#line 4644 "mon_parse.c"
break;
case 303:
#line 1011 "mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_REG_IND_IY; }
#line 4649 "mon_parse.c"
break;
case 304:
#line 1012 "mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_REG_IND_SP; }
#line 4654 "mon_parse.c"
break;
case 305:
#line 1014 "mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_ABSOLUTE_A; yyval.mode.param = yystack.l_mark[-3].i; }
#line 4659 "mon_parse.c"
break;
case 306:
#line 1016 "mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_ABSOLUTE_HL; yyval.mode.param = yystack.l_mark[-3].i; }
#line 4664 "mon_parse.c"
break;
case 307:
#line 1018 "mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_ABSOLUTE_IX; yyval.mode.param = yystack.l_mark[-3].i; }
#line 4669 "mon_parse.c"
break;
case 308:
#line 1020 "mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_ABSOLUTE_IY; yyval.mode.param = yystack.l_mark[-3].i; }
#line 4674 "mon_parse.c"
break;
case 309:
#line 1021 "mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_IMPLIED; }
#line 4679 "mon_parse.c"
break;
case 310:
#line 1022 "mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_ACCUMULATOR; }
#line 4684 "mon_parse.c"
break;
case 311:
#line 1023 "mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_REG_B; }
#line 4689 "mon_parse.c"
break;
case 312:
#line 1024 "mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_REG_C; }
#line 4694 "mon_parse.c"
break;
case 313:
#line 1025 "mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_REG_D; }
#line 4699 "mon_parse.c"
break;
case 314:
#line 1026 "mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_REG_E; }
#line 4704 "mon_parse.c"
break;
case 315:
#line 1027 "mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_REG_H; }
#line 4709 "mon_parse.c"
break;
case 316:
#line 1028 "mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_REG_IXH; }
#line 4714 "mon_parse.c"
break;
case 317:
#line 1029 "mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_REG_IYH; }
#line 4719 "mon_parse.c"
break;
case 318:
#line 1030 "mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_REG_L; }
#line 4724 "mon_parse.c"
break;
case 319:
#line 1031 "mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_REG_IXL; }
#line 4729 "mon_parse.c"
break;
case 320:
#line 1032 "mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_REG_IYL; }
#line 4734 "mon_parse.c"
break;
case 321:
#line 1033 "mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_REG_AF; }
#line 4739 "mon_parse.c"
break;
case 322:
#line 1034 "mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_REG_BC; }
#line 4744 "mon_parse.c"
break;
case 323:
#line 1035 "mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_REG_DE; }
#line 4749 "mon_parse.c"
break;
case 324:
#line 1036 "mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_REG_HL; }
#line 4754 "mon_parse.c"
break;
case 325:
#line 1037 "mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_REG_IX; }
#line 4759 "mon_parse.c"
break;
case 326:
#line 1038 "mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_REG_IY; }
#line 4764 "mon_parse.c"
break;
case 327:
#line 1039 "mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_REG_SP; }
#line 4769 "mon_parse.c"
break;
case 328:
#line 1041 "mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_DIRECT; yyval.mode.param = yystack.l_mark[0].i; }
#line 4774 "mon_parse.c"
break;
case 329:
#line 1042 "mon_parse.y"
	{    /* Clash with addr,x addr,y addr,s modes! */
        yyval.mode.addr_mode = ASM_ADDR_MODE_INDEXED;
        if (yystack.l_mark[-2].i >= -16 && yystack.l_mark[-2].i < 16) {
            yyval.mode.addr_submode = (3 << 5) | (yystack.l_mark[-2].i & 0x1F);
        } else if (yystack.l_mark[-2].i >= -128 && yystack.l_mark[-2].i < 128) {
            yyval.mode.addr_submode = 0x80 | (3 << 5) | ASM_ADDR_MODE_INDEXED_OFF8;
            yyval.mode.param = yystack.l_mark[-2].i;
        } else if (yystack.l_mark[-2].i >= -32768 && yystack.l_mark[-2].i < 32768) {
            yyval.mode.addr_submode = 0x80 | (3 << 5) | ASM_ADDR_MODE_INDEXED_OFF16;
            yyval.mode.param = yystack.l_mark[-2].i;
        } else {
            yyval.mode.addr_mode = ASM_ADDR_MODE_ILLEGAL;
            mon_out("offset too large even for 16 bits (signed)\n");
        }
    }
#line 4793 "mon_parse.c"
break;
case 330:
#line 1057 "mon_parse.y"
	{
        yyval.mode.addr_mode = ASM_ADDR_MODE_INDEXED;
        yyval.mode.addr_submode = 0x80 | yystack.l_mark[-1].i | ASM_ADDR_MODE_INDEXED_INC1;
        }
#line 4801 "mon_parse.c"
break;
case 331:
#line 1061 "mon_parse.y"
	{
        yyval.mode.addr_mode = ASM_ADDR_MODE_INDEXED;
        yyval.mode.addr_submode = 0x80 | yystack.l_mark[-2].i | ASM_ADDR_MODE_INDEXED_INC2;
        }
#line 4809 "mon_parse.c"
break;
case 332:
#line 1065 "mon_parse.y"
	{
        yyval.mode.addr_mode = ASM_ADDR_MODE_INDEXED;
        yyval.mode.addr_submode = 0x80 | yystack.l_mark[0].i | ASM_ADDR_MODE_INDEXED_DEC1;
        }
#line 4817 "mon_parse.c"
break;
case 333:
#line 1069 "mon_parse.y"
	{
        yyval.mode.addr_mode = ASM_ADDR_MODE_INDEXED;
        yyval.mode.addr_submode = 0x80 | yystack.l_mark[0].i | ASM_ADDR_MODE_INDEXED_DEC2;
        }
#line 4825 "mon_parse.c"
break;
case 334:
#line 1073 "mon_parse.y"
	{
        yyval.mode.addr_mode = ASM_ADDR_MODE_INDEXED;
        yyval.mode.addr_submode = 0x80 | yystack.l_mark[0].i | ASM_ADDR_MODE_INDEXED_OFF0;
        }
#line 4833 "mon_parse.c"
break;
case 335:
#line 1077 "mon_parse.y"
	{
        yyval.mode.addr_mode = ASM_ADDR_MODE_INDEXED;
        yyval.mode.addr_submode = 0x80 | yystack.l_mark[-1].i | ASM_ADDR_MODE_INDEXED_OFFB;
        }
#line 4841 "mon_parse.c"
break;
case 336:
#line 1081 "mon_parse.y"
	{
        yyval.mode.addr_mode = ASM_ADDR_MODE_INDEXED;
        yyval.mode.addr_submode = 0x80 | yystack.l_mark[-1].i | ASM_ADDR_MODE_INDEXED_OFFA;
        }
#line 4849 "mon_parse.c"
break;
case 337:
#line 1085 "mon_parse.y"
	{
        yyval.mode.addr_mode = ASM_ADDR_MODE_INDEXED;
        yyval.mode.addr_submode = 0x80 | yystack.l_mark[-1].i | ASM_ADDR_MODE_INDEXED_OFFD;
        }
#line 4857 "mon_parse.c"
break;
case 338:
#line 1089 "mon_parse.y"
	{
        yyval.mode.addr_mode = ASM_ADDR_MODE_INDEXED;
        yyval.mode.param = yystack.l_mark[-2].i;
        if (yystack.l_mark[-2].i >= -128 && yystack.l_mark[-2].i < 128) {
            yyval.mode.addr_submode = ASM_ADDR_MODE_INDEXED_OFFPC8;
        } else if (yystack.l_mark[-2].i >= -32768 && yystack.l_mark[-2].i < 32768) {
            yyval.mode.addr_submode = ASM_ADDR_MODE_INDEXED_OFFPC16;
        } else {
            yyval.mode.addr_mode = ASM_ADDR_MODE_ILLEGAL;
            mon_out("offset too large even for 16 bits (signed)\n");
        }
    }
#line 4873 "mon_parse.c"
break;
case 339:
#line 1101 "mon_parse.y"
	{
        yyval.mode.addr_mode = ASM_ADDR_MODE_INDEXED;
        if (yystack.l_mark[-3].i >= -16 && yystack.l_mark[-3].i < 16) {
            yyval.mode.addr_submode = yystack.l_mark[-3].i & 0x1F;
        } else if (yystack.l_mark[-4].i >= -128 && yystack.l_mark[-4].i < 128) {
            yyval.mode.addr_submode = ASM_ADDR_MODE_INDEXED_OFF8;
            yyval.mode.param = yystack.l_mark[-3].i;
        } else if (yystack.l_mark[-3].i >= -32768 && yystack.l_mark[-3].i < 32768) {
            yyval.mode.addr_submode = ASM_ADDR_MODE_INDEXED_OFF16;
            yyval.mode.param = yystack.l_mark[-3].i;
        } else {
            yyval.mode.addr_mode = ASM_ADDR_MODE_ILLEGAL;
            mon_out("offset too large even for 16 bits (signed)\n");
        }
    }
#line 4892 "mon_parse.c"
break;
case 340:
#line 1116 "mon_parse.y"
	{
        yyval.mode.addr_mode = ASM_ADDR_MODE_INDEXED;
        yyval.mode.addr_submode = 0x80 | yystack.l_mark[-2].i | ASM_ADDR_MODE_INDEXED_INC1;
        }
#line 4900 "mon_parse.c"
break;
case 341:
#line 1120 "mon_parse.y"
	{
        yyval.mode.addr_mode = ASM_ADDR_MODE_INDEXED;
        yyval.mode.addr_submode = 0x80 | yystack.l_mark[-3].i | ASM_ADDR_MODE_INDEXED_INC2;
        }
#line 4908 "mon_parse.c"
break;
case 342:
#line 1124 "mon_parse.y"
	{
        yyval.mode.addr_mode = ASM_ADDR_MODE_INDEXED;
        yyval.mode.addr_submode = 0x80 | yystack.l_mark[-1].i | ASM_ADDR_MODE_INDEXED_DEC1;
        }
#line 4916 "mon_parse.c"
break;
case 343:
#line 1128 "mon_parse.y"
	{
        yyval.mode.addr_mode = ASM_ADDR_MODE_INDEXED;
        yyval.mode.addr_submode = 0x80 | yystack.l_mark[-1].i | ASM_ADDR_MODE_INDEXED_DEC2;
        }
#line 4924 "mon_parse.c"
break;
case 344:
#line 1132 "mon_parse.y"
	{
        yyval.mode.addr_mode = ASM_ADDR_MODE_INDEXED;
        yyval.mode.addr_submode = 0x80 | yystack.l_mark[-1].i | ASM_ADDR_MODE_INDEXED_OFF0;
        }
#line 4932 "mon_parse.c"
break;
case 345:
#line 1136 "mon_parse.y"
	{
        yyval.mode.addr_mode = ASM_ADDR_MODE_INDEXED;
        yyval.mode.addr_submode = 0x80 | yystack.l_mark[-2].i | ASM_ADDR_MODE_INDEXED_OFFB;
        }
#line 4940 "mon_parse.c"
break;
case 346:
#line 1140 "mon_parse.y"
	{
        yyval.mode.addr_mode = ASM_ADDR_MODE_INDEXED;
        yyval.mode.addr_submode = 0x80 | yystack.l_mark[-2].i | ASM_ADDR_MODE_INDEXED_OFFA;
        }
#line 4948 "mon_parse.c"
break;
case 347:
#line 1144 "mon_parse.y"
	{
        yyval.mode.addr_mode = ASM_ADDR_MODE_INDEXED;
        yyval.mode.addr_submode = 0x80 | yystack.l_mark[-2].i | ASM_ADDR_MODE_INDEXED_OFFD;
        }
#line 4956 "mon_parse.c"
break;
case 348:
#line 1148 "mon_parse.y"
	{
        yyval.mode.addr_mode = ASM_ADDR_MODE_INDEXED;
        yyval.mode.param = yystack.l_mark[-3].i;
        if (yystack.l_mark[-3].i >= -128 && yystack.l_mark[-3].i < 128) {
            yyval.mode.addr_submode = ASM_ADDR_MODE_INDEXED_OFFPC8_IND;
        } else if (yystack.l_mark[-3].i >= -32768 && yystack.l_mark[-3].i < 32768) {
            yyval.mode.addr_submode = ASM_ADDR_MODE_INDEXED_OFFPC16_IND;
        } else {
            yyval.mode.addr_mode = ASM_ADDR_MODE_ILLEGAL;
            mon_out("offset too large even for 16 bits (signed)\n");
        }
    }
#line 4972 "mon_parse.c"
break;
case 349:
#line 1160 "mon_parse.y"
	{
        yyval.mode.addr_mode = ASM_ADDR_MODE_INDEXED;
        yyval.mode.addr_submode = 0x80 | ASM_ADDR_MODE_EXTENDED_INDIRECT;
        yyval.mode.param = yystack.l_mark[-1].i;
        }
#line 4981 "mon_parse.c"
break;
case 350:
#line 1165 "mon_parse.y"
	{
        yyval.mode.addr_mode = ASM_ADDR_MODE_INDIRECT_LONG_Y;
        yyval.mode.param = yystack.l_mark[-3].i;
        }
#line 4989 "mon_parse.c"
break;
case 351:
#line 1173 "mon_parse.y"
	{ yyval.i = (0 << 5); printf("reg_x\n"); }
#line 4994 "mon_parse.c"
break;
case 352:
#line 1174 "mon_parse.y"
	{ yyval.i = (1 << 5); printf("reg_y\n"); }
#line 4999 "mon_parse.c"
break;
case 353:
#line 1175 "mon_parse.y"
	{ yyval.i = yystack.l_mark[0].i; }
#line 5004 "mon_parse.c"
break;
case 354:
#line 1176 "mon_parse.y"
	{ yyval.i = (3 << 5); printf("reg_s\n"); }
#line 5009 "mon_parse.c"
break;
case 355:
#line 1180 "mon_parse.y"
	{ yyval.i = (2 << 5); printf("reg_u\n"); }
#line 5014 "mon_parse.c"
break;
#line 5016 "mon_parse.c"
    default:
        break;
    }
    yystack.s_mark -= yym;
    yystate = *yystack.s_mark;
    yystack.l_mark -= yym;
#if defined(YYLTYPE) || defined(YYLTYPE_IS_DECLARED)
    yystack.p_mark -= yym;
#endif
    yym = yylhs[yyn];
    if (yystate == 0 && yym == 0)
    {
#if YYDEBUG
        if (yydebug)
        {
            fprintf(stderr, "%s[%d]: after reduction, ", YYDEBUGSTR, yydepth);
#ifdef YYSTYPE_TOSTRING
#if YYBTYACC
            if (!yytrial)
#endif /* YYBTYACC */
                fprintf(stderr, "result is <%s>, ", YYSTYPE_TOSTRING(yystos[YYFINAL], yyval));
#endif
            fprintf(stderr, "shifting from state 0 to final state %d\n", YYFINAL);
        }
#endif
        yystate = YYFINAL;
        *++yystack.s_mark = YYFINAL;
        *++yystack.l_mark = yyval;
#if defined(YYLTYPE) || defined(YYLTYPE_IS_DECLARED)
        *++yystack.p_mark = yyloc;
#endif
        if (yychar < 0)
        {
#if YYBTYACC
            do {
            if (yylvp < yylve)
            {
                /* we're currently re-reading tokens */
                yylval = *yylvp++;
#if defined(YYLTYPE) || defined(YYLTYPE_IS_DECLARED)
                yylloc = *yylpp++;
#endif
                yychar = *yylexp++;
                break;
            }
            if (yyps->save)
            {
                /* in trial mode; save scanner results for future parse attempts */
                if (yylvp == yylvlim)
                {   /* Enlarge lexical value queue */
                    size_t p = (size_t) (yylvp - yylvals);
                    size_t s = (size_t) (yylvlim - yylvals);

                    s += YYLVQUEUEGROWTH;
                    if ((yylexemes = (YYINT *)realloc(yylexemes, s * sizeof(YYINT))) == NULL)
                        goto yyenomem;
                    if ((yylvals   = (YYSTYPE *)realloc(yylvals, s * sizeof(YYSTYPE))) == NULL)
                        goto yyenomem;
#if defined(YYLTYPE) || defined(YYLTYPE_IS_DECLARED)
                    if ((yylpsns   = (YYLTYPE *)realloc(yylpsns, s * sizeof(YYLTYPE))) == NULL)
                        goto yyenomem;
#endif
                    yylvp   = yylve = yylvals + p;
                    yylvlim = yylvals + s;
#if defined(YYLTYPE) || defined(YYLTYPE_IS_DECLARED)
                    yylpp   = yylpe = yylpsns + p;
                    yylplim = yylpsns + s;
#endif
                    yylexp  = yylexemes + p;
                }
                *yylexp = (YYINT) YYLEX;
                *yylvp++ = yylval;
                yylve++;
#if defined(YYLTYPE) || defined(YYLTYPE_IS_DECLARED)
                *yylpp++ = yylloc;
                yylpe++;
#endif
                yychar = *yylexp++;
                break;
            }
            /* normal operation, no conflict encountered */
#endif /* YYBTYACC */
            yychar = YYLEX;
#if YYBTYACC
            } while (0);
#endif /* YYBTYACC */
            if (yychar < 0) yychar = YYEOF;
#if YYDEBUG
            if (yydebug)
            {
                if ((yys = yyname[YYTRANSLATE(yychar)]) == NULL) yys = yyname[YYUNDFTOKEN];
                fprintf(stderr, "%s[%d]: state %d, reading token %d (%s)\n",
                                YYDEBUGSTR, yydepth, YYFINAL, yychar, yys);
            }
#endif
        }
        if (yychar == YYEOF) goto yyaccept;
        goto yyloop;
    }
    if (((yyn = yygindex[yym]) != 0) && (yyn += yystate) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == (YYINT) yystate)
        yystate = yytable[yyn];
    else
        yystate = yydgoto[yym];
#if YYDEBUG
    if (yydebug)
    {
        fprintf(stderr, "%s[%d]: after reduction, ", YYDEBUGSTR, yydepth);
#ifdef YYSTYPE_TOSTRING
#if YYBTYACC
        if (!yytrial)
#endif /* YYBTYACC */
            fprintf(stderr, "result is <%s>, ", YYSTYPE_TOSTRING(yystos[yystate], yyval));
#endif
        fprintf(stderr, "shifting from state %d to state %d\n", *yystack.s_mark, yystate);
    }
#endif
    if (yystack.s_mark >= yystack.s_last && yygrowstack(&yystack) == YYENOMEM) goto yyoverflow;
    *++yystack.s_mark = (YYINT) yystate;
    *++yystack.l_mark = yyval;
#if defined(YYLTYPE) || defined(YYLTYPE_IS_DECLARED)
    *++yystack.p_mark = yyloc;
#endif
    goto yyloop;
#if YYBTYACC

    /* Reduction declares that this path is valid. Set yypath and do a full parse */
yyvalid:
    if (yypath) YYABORT;
    while (yyps->save)
    {
        YYParseState *save = yyps->save;
        yyps->save = save->save;
        save->save = yypath;
        yypath = save;
    }
#if YYDEBUG
    if (yydebug)
        fprintf(stderr, "%s[%d]: state %d, CONFLICT trial successful, backtracking to state %d, %d tokens\n",
                        YYDEBUGSTR, yydepth, yystate, yypath->state, (int)(yylvp - yylvals - yypath->lexeme));
#endif
    if (yyerrctx)
    {
        yyFreeState(yyerrctx);
        yyerrctx = NULL;
    }
    yylvp          = yylvals + yypath->lexeme;
#if defined(YYLTYPE) || defined(YYLTYPE_IS_DECLARED)
    yylpp          = yylpsns + yypath->lexeme;
#endif
    yylexp         = yylexemes + yypath->lexeme;
    yychar         = YYEMPTY;
    yystack.s_mark = yystack.s_base + (yypath->yystack.s_mark - yypath->yystack.s_base);
    memcpy (yystack.s_base, yypath->yystack.s_base, (size_t) (yystack.s_mark - yystack.s_base + 1) * sizeof(YYINT));
    yystack.l_mark = yystack.l_base + (yypath->yystack.l_mark - yypath->yystack.l_base);
    memcpy (yystack.l_base, yypath->yystack.l_base, (size_t) (yystack.l_mark - yystack.l_base + 1) * sizeof(YYSTYPE));
#if defined(YYLTYPE) || defined(YYLTYPE_IS_DECLARED)
    yystack.p_mark = yystack.p_base + (yypath->yystack.p_mark - yypath->yystack.p_base);
    memcpy (yystack.p_base, yypath->yystack.p_base, (size_t) (yystack.p_mark - yystack.p_base + 1) * sizeof(YYLTYPE));
#endif
    yystate        = yypath->state;
    goto yyloop;
#endif /* YYBTYACC */

yyoverflow:
    YYERROR_CALL("yacc stack overflow");
#if YYBTYACC
    goto yyabort_nomem;
yyenomem:
    YYERROR_CALL("memory exhausted");
yyabort_nomem:
#endif /* YYBTYACC */
    yyresult = 2;
    goto yyreturn;

yyabort:
    yyresult = 1;
    goto yyreturn;

yyaccept:
#if YYBTYACC
    if (yyps->save) goto yyvalid;
#endif /* YYBTYACC */
    yyresult = 0;

yyreturn:
#if defined(YYDESTRUCT_CALL)
    if (yychar != YYEOF && yychar != YYEMPTY)
#if defined(YYLTYPE) || defined(YYLTYPE_IS_DECLARED)
        YYDESTRUCT_CALL("cleanup: discarding token", yychar, &yylval, &yylloc);
#else
        YYDESTRUCT_CALL("cleanup: discarding token", yychar, &yylval);
#endif /* defined(YYLTYPE) || defined(YYLTYPE_IS_DECLARED) */

    {
        YYSTYPE *pv;
#if defined(YYLTYPE) || defined(YYLTYPE_IS_DECLARED)
        YYLTYPE *pp;

        for (pv = yystack.l_base, pp = yystack.p_base; pv <= yystack.l_mark; ++pv, ++pp)
             YYDESTRUCT_CALL("cleanup: discarding state",
                             yystos[*(yystack.s_base + (pv - yystack.l_base))], pv, pp);
#else
        for (pv = yystack.l_base; pv <= yystack.l_mark; ++pv)
             YYDESTRUCT_CALL("cleanup: discarding state",
                             yystos[*(yystack.s_base + (pv - yystack.l_base))], pv);
#endif /* defined(YYLTYPE) || defined(YYLTYPE_IS_DECLARED) */
    }
#endif /* defined(YYDESTRUCT_CALL) */

#if YYBTYACC
    if (yyerrctx)
    {
        yyFreeState(yyerrctx);
        yyerrctx = NULL;
    }
    while (yyps)
    {
        YYParseState *save = yyps;
        yyps = save->save;
        save->save = NULL;
        yyFreeState(save);
    }
    while (yypath)
    {
        YYParseState *save = yypath;
        yypath = save->save;
        save->save = NULL;
        yyFreeState(save);
    }
#endif /* YYBTYACC */
    yyfreestack(&yystack);
    return (yyresult);
}
