#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2018 BetaRays
# SPDX-FileCopyrightText: © 2018 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Zachtronics games built on top of Unity3D:
# - Infinifactory
# - TIS-100
###

script_version=20240529.1

PLAYIT_COMPATIBILITY_LEVEL='2.29'

GAME_ID_INFINIFACTORY='infinifactory'
GAME_NAME_INFINIFACTORY='Infinifactory'

GAME_ID_TIS100='tis-100'
GAME_NAME_TIS100='TIS-100'

# Archives

## Infinifactory

ARCHIVE_BASE_INFINIFACTORY_0_NAME='infinifactory_11_14_2020_43258.sh'
ARCHIVE_BASE_INFINIFACTORY_0_MD5='c0b873dde4f29d49f0c7aa3fec2b1384'
ARCHIVE_BASE_INFINIFACTORY_0_SIZE='1700000'
ARCHIVE_BASE_INFINIFACTORY_0_VERSION='2020.11.14-gog43258'
ARCHIVE_BASE_INFINIFACTORY_0_URL='https://www.gog.com/game/infinifactory'

## TIS-100

ARCHIVE_BASE_TIS100_1_NAME='tis_100_11_14_2020_43142.sh'
ARCHIVE_BASE_TIS100_1_MD5='ce632a3b15de61222f79d3c4f506bac1'
ARCHIVE_BASE_TIS100_1_SIZE='84000'
ARCHIVE_BASE_TIS100_1_VERSION='2020.11.14-gog43142'
ARCHIVE_BASE_TIS100_1_URL='https://www.gog.com/game/tis100'

ARCHIVE_BASE_TIS100_0_NAME='tis_100_en_11_27_2017_16765.sh'
ARCHIVE_BASE_TIS100_0_MD5='70518ec82ee8148697b704ed2c3c8953'
ARCHIVE_BASE_TIS100_0_SIZE='83000'
ARCHIVE_BASE_TIS100_0_VERSION='2017.11.27-gog16765'


UNITY3D_NAME_INFINIFACTORY='infinifactory'
UNITY3D_NAME_TIS100='tis100'
UNITY3D_PLUGINS_INFINIFACTORY='
libfmod.so
libfmodstudio.so
ScreenSelector.so'
UNITY3D_PLUGINS_TIS100='
ScreenSelector.so'

CONTENT_PATH_DEFAULT='data/noarch/game'
CONTENT_DOC_DATA_FILES='
*.pdf
*.txt'

# Packages

PACKAGES_LIST='
PKG_BIN64
PKG_BIN32
PKG_DATA'

PKG_DATA_DESCRIPTION='data'

PKG_BIN64_ARCH='64'
PKG_BIN32_ARCH='32'
PKG_BIN_DEPENDENCIES_LIBRARIES='
libc.so.6
libdl.so.2
libgcc_s.so.1
libgdk_pixbuf-2.0.so.0
libglib-2.0.so.0
libGL.so.1
libgobject-2.0.so.0
libgtk-x11-2.0.so.0
libm.so.6
libpthread.so.0
librt.so.1
libstdc++.so.6
libX11.so.6
libXcursor.so.1
libXrandr.so.2'
PKG_BIN64_DEPENDENCIES_LIBRARIES="$PKG_BIN_DEPENDENCIES_LIBRARIES"
PKG_BIN32_DEPENDENCIES_LIBRARIES="$PKG_BIN_DEPENDENCIES_LIBRARIES"

## Infinifactory

PKG_DATA_ID_INFINIFACTORY="${GAME_ID_INFINIFACTORY}-data"

PKG_BIN_DEPS_INFINIFACTORY="$PKG_DATA_ID_INFINIFACTORY"
PKG_BIN64_DEPS_INFINIFACTORY="$PKG_BIN_DEPS_INFINIFACTORY"
PKG_BIN32_DEPS_INFINIFACTORY="$PKG_BIN_DEPS_INFINIFACTORY"

## TIS-100

PKG_DATA_ID_TIS100="${GAME_ID_TIS100}-data"

PKG_BIN_DEPS_TIS100="$PKG_DATA_ID_TIS100"
PKG_BIN64_DEPS_TIS100="$PKG_BIN_DEPS_TIS100"
PKG_BIN32_DEPS_TIS100="$PKG_BIN_DEPS_TIS100"

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# TIS-100 - Copy the manual in the game directory

case "$(current_archive)" in
	('ARCHIVE_BASE_TIS100_'*)
		manual_source="$(package_path 'PKG_DATA')$(path_documentation)/TIS-100 Reference Manual.pdf"
		manual_destination="$(package_path 'PKG_DATA')$(path_game_data)/TIS-100 Reference Manual.pdf"
		mkdir --parents "$(dirname "$manual_destination")"
		cp --link "$manual_source" "$manual_destination"
	;;
esac

# Write launchers

launchers_generation 'PKG_BIN64'
launchers_generation 'PKG_BIN32'

# Build packages

packages_generation
print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
