#!/bin/sh
set -o errexit

###
# Copyright (c) 2015-2021, Antoine Le Gonidec <vv221@dotslashplay.it>
# Copyright (c) 2016-2021, Mopi
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# 1. Redistributions of source code must retain the above copyright notice,
# this list of conditions and the following disclaimer.
#
# 2. Redistributions in binary form must reproduce the above copyright notice,
# this list of conditions and the following disclaimer in the documentation
# and/or other materials provided with the distribution.
#
# This software is provided by the copyright holders and contributors "as is"
# and any express or implied warranties, including, but not limited to, the
# implied warranties of merchantability and fitness for a particular purpose
# are disclaimed. In no event shall the copyright holder or contributors be
# liable for any direct, indirect, incidental, special, exemplary, or
# consequential damages (including, but not limited to, procurement of
# substitute goods or services; loss of use, data, or profits; or business
# interruption) however caused and on any theory of liability, whether in
# contract, strict liability, or tort (including negligence or otherwise)
# arising in any way out of the use of this software, even if advised of the
# possibility of such damage.
###

###
# Anodyne
# build native packages from the original installers
# send your bug reports to contact@dotslashplay.it
###

script_version=20211229.2

# Set game-specific variables

GAME_ID='anodyne'
GAME_NAME='Anodyne'

ARCHIVE_BASE_0='1_6winanodyne.zip'
ARCHIVE_BASE_0_MD5='5e7be131731a8073f3dbf4489d7e414a'
ARCHIVE_BASE_0_VERSION='1.60-itch1'
ARCHIVE_BASE_0_SIZE='110000'
ARCHIVE_BASE_0_URL='https://han-tani.itch.io/anodyne'

CONTENT_PATH_DEFAULT='windows'
ARCHIVE_DOC_DATA_FILES='
README.txt'
ARCHIVE_GAME_BIN_FILES='
Adobe?AIR
*.dll
*.exe'
ARCHIVE_GAME_DATA_FILES='
icons
js
META-INF
mimetype
*.der
*.dylib
*.html
*.png
*.ssp4
*.swf
*.txt'

APP_MAIN_TYPE='wine'
APP_MAIN_EXE='Anodyne.exe'
APP_MAIN_ICONS_LIST='APP_MAIN_ICON_29 APP_MAIN_ICON_32 APP_MAIN_ICON_48 APP_MAIN_ICON_57 APP_MAIN_ICON_128 APP_MAIN_ICON_512'
APP_MAIN_ICON_29='icons/IntraAIR29.png'
APP_MAIN_ICON_32='icons/IntraAIR32.png'
APP_MAIN_ICON_48='icons/IntraAIR48.png'
APP_MAIN_ICON_57='icons/IntraAIR57.png'
APP_MAIN_ICON_512='icons/IntraAIR512.png'
APP_MAIN_ICON_128='icons/IntraAIR128.png'

PACKAGES_LIST='PKG_BIN PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN_ARCH='32'
PKG_BIN_DEPS="$PKG_DATA_ID wine"

# Use persistent storage for saved games

APP_WINE_LINK_DIRS="$APP_WINE_LINK_DIRS"'
userdata:users/${USER}/.Anodyne'
DATA_DIRS="$DATA_DIRS ./userdata"

# Load common functions

target_version='2.15'

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

extract_data_from "$SOURCE_ARCHIVE"
prepare_package_layout

# Delete temporary files

rm --recursive "${PLAYIT_WORKDIR}/gamedata"

# Include game icon

PKG='PKG_DATA'
icons_get_from_package 'APP_MAIN'

# Write launchers

PKG='PKG_BIN'
launchers_write 'APP_MAIN'

# Build package

write_metadata
build_pkg

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

# Print instructions

print_instructions

exit 0
