/**
 * Contains supporting classes for the HTML-HUL module.
 * <br>
 * <p>
 * This module uses code generated by
 * <a href="https://javacc.dev.java.net/doc/docindex.html">JavaCC</a>.
 * The grammar file is <code>ParseHtml.jj</code>. It can be compiled using
 * <code>BuildParser.bat</code>. Compiling it generates the following files:
 * <ul>
 * <li>CharStream.java
 * <li>ParseException.java
 * <li>ParseHtml.java
 * <li>ParseHtmlConstants.java
 * <li>ParseHtmlTokenManager.java
 * <li>SimpleCharStream.java
 * <li>Token.java
 * <li>TokenMgrError.java
 * </ul>
 * <p>
 * In addition, <code>HtmlCharStream.java</code> has been created by manually
 * modifying <code>CharStream.java</code>. If a future version of JavaCC
 * changes <code>CharStream.java</code>, <code>HtmlCharStream.java</code>
 * should be changed to match.
 * <p>
 * A number of DTD and Entity files have been stored with this package to
 * facilitate resolution of Doctypes without having to get them over
 * the Internet. These are the W3 Consortium's files, and no rights over
 * them are claimed by including them here.
 * <p>
 * The included files:
 * <ul>
 * <li>xhtml1-frameset.dtd
 * <li>xhtml1-strict.dtd
 * <li>xhtml1-transitional.dtd
 * <li>xhtml-lat1.ent
 * <li>xhtml-special.ent
 * <li>xhtml-symbol.ent
 * </ul>
 * <p>
 * This module uses the XML-HUL module for validating XHTML files.
 */
package edu.harvard.hul.ois.jhove.module.html;