#!/bin/sh
#               sift.sh <file of blocks>
#
fasta=""
if [ $# -gt 0 -a -f "$1" ]
then
	./blimps-bin/blalign $1 -f > $1.fas
	fasta=`cat $1.fas`
fi
#  From the <HTML> to </HTML> is ~btest/www/codehop.html
#       with the blocks TEXTAREA modified to insert $blocks

cat << EOM
Content-type: text/html

<HTML>
<body bgcolor=white>
<TITLE>SIFT:Submit aligned sequences</TITLE>
<H1>
<img src="/sift/pics/sifter.gif" align=left width="20%">
S<font color=red>I</font>F<font color=blue>T</font>: Submit aligned sequences</H1>
<BR>
<FORM ENCTYPE="MULTIPART/FORM-DATA" METHOD="POST" ACTION="/sift-bin/SIFT_aligned_seqs_submit.pl">
Submit your query sequence along with other protein sequences that are aligned to it for SIFT.  Your query sequence is the sequence that you would like prediction on (i.e. the sequence in which you have introduced the amino acid substitutions). <b> 
The query sequence should be first in the alignment.
  The alignment must correspond to the length of your query sequence (i.e. no gaps in your query sequence in the alignment).</b>
Partial sequences should be flanked by Xes at the beginning and end of the sequence so that those positions are not considered gaps (and hence have liberal prediction).
<A HREF="/sift/SIFT_help.html">[More info]</A><BR>
<BR>
<HR>
<i>Entering sequences </i><BR>
Enter your query sequence aligned with related sequences. These sequences are assumed to be functional, and is what SIFT will base its prediction on. The normal (functional) query sequence should appear first. 
<BR>
<BR>
Enter the name of the file containing your aligned sequences 
<A HREF="/blocks/help/blocks_format.html#fasta">
[clustal, msf, or fasta format]</A>.
<INPUT SIZE=50 NAME="alignment_file" TYPE="file"><BR><BR>
<center>-or-</center><BR>
Paste in your aligned sequences 
<A HREF="/blocks/help/blocks_format.html#fasta">
[clustal, msf, or fasta format]</A>.<BR>
<TEXTAREA NAME = "aligned_seqs" ROWS=10 COLS=70>$fasta</TEXTAREA>
<BR>
<BR>
<HR>
<font color=blue>Optional fields</font><BR>
<BR>
<i>Entering substitutions.</i><BR>
Enter the substitutions that occur in the query sequence.<BR>
<BR>
Enter the name of file containing substitutions of interest:
<A HREF="/sift/SIFT_help.html#substitution">[format]</A>:
<BR>
<INPUT SIZE=50 NAME="substitution_file" TYPE="file"><BR><BR>
<center>-or-</center><BR>
Enter the substitutions of interest:
<A HREF="/sift/SIFT_help.html#substitution">[format]</A>:
<BR>
<TEXTAREA NAME = "substitutions" ROWS=5 COLS=50></TEXTAREA>
<HR>
<input type=checkbox checked name=gap_option value="TRUE">Account for Gaps
<BR>
<i>  If your alignment is especially gapped, turn this off.</i><HR>
<BR>
<INPUT TYPE=submit>
<INPUT TYPE=reset>
<HR>
<BR>
Questions or comments?<BR>
<A href="/blocks/contact.html">Contact us</A> <P>

</HTML>

EOM
exit
