/*************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * Copyright 2009 by Sun Microsystems, Inc.
 *
 * OpenOffice.org - a multi-platform office productivity suite
 *
 * $RCSfile: EvolutionarySolverStatus.java,v $
 * $Revision: 1.1 $
 *
 * This file is part of OpenOffice.org.
 *
 * OpenOffice.org is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * OpenOffice.org is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with OpenOffice.org.  If not, see
 * <http://www.openoffice.org/license.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/

package com.sun.star.NLPSolver.dialogs;

import java.awt.Color;
import java.awt.Container;
import javax.swing.Spring;
import javax.swing.SpringLayout;

/**
 *
 * @author Andreas Schneider <Andreas.Schneider@Sun.COM>
 */
public class EvolutionarySolverStatus extends javax.swing.JFrame
    implements IEvolutionarySolverStatusDialog {

    private int m_userState;

    public int getUserState() {
        return m_userState;
    }

    private synchronized void setUserState(int state) {
        m_userState = state;
        notifyAll();
    }

    /** Creates new form EvolutionSolverStatus */
    public EvolutionarySolverStatus() {
        initComponents();
        setLocationRelativeTo(null);
    }

    /** This method is called from within the constructor to
     * initialize the form.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">
    private void initComponents() {

        jLabel1 = new javax.swing.JLabel();
        pbIteration = new javax.swing.JProgressBar();
        lblSolutionValue = new javax.swing.JLabel();
        lblIteration = new javax.swing.JLabel();
        lblStagnation = new javax.swing.JLabel();
        pbStagnation = new javax.swing.JProgressBar();
        btnContinue = new javax.swing.JButton();
        btnOK = new javax.swing.JButton();
        btnStop = new javax.swing.JButton();

        setDefaultCloseOperation(javax.swing.WindowConstants.DO_NOTHING_ON_CLOSE);
        setTitle("Solver Status");

        jLabel1.setFont(jLabel1.getFont().deriveFont(jLabel1.getFont().getStyle() & ~java.awt.Font.BOLD));
        jLabel1.setText("Current solution:");

        pbIteration.setFont(pbIteration.getFont().deriveFont(pbIteration.getFont().getStyle() & ~java.awt.Font.BOLD));
        pbIteration.setString("");
        pbIteration.setStringPainted(true);

        lblSolutionValue.setFont(lblSolutionValue.getFont().deriveFont(lblSolutionValue.getFont().getStyle() | java.awt.Font.BOLD));
        lblSolutionValue.setText("-");

        lblIteration.setFont(lblIteration.getFont().deriveFont(lblIteration.getFont().getStyle() & ~java.awt.Font.BOLD));
        lblIteration.setText("Iteration:");

        lblStagnation.setFont(lblStagnation.getFont().deriveFont(lblStagnation.getFont().getStyle() & ~java.awt.Font.BOLD));
        lblStagnation.setText("Stagnation:");

        btnContinue.setText("Continue Solver");
        btnContinue.setEnabled(false);
        btnContinue.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnContinueActionPerformed(evt);
            }
        });

        btnOK.setText("OK");
        btnOK.setEnabled(false);
        btnOK.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnOKActionPerformed(evt);
            }
        });

        btnStop.setText("Stop");
        btnStop.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnStopActionPerformed(evt);
            }
        });
        
        /*Dimension dim = pbIteration.getSize();
        //dim.width = btnStop.getWidth() + btnContinue.getWidth() + btnOK.getWidth() + 20 - lblIteration.getWidth();
        dim.width = 200;
        pbIteration.setMinimumSize(dim);
        pbStagnation.setMinimumSize(dim);*/

        /*javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(jLabel1)
                            .addComponent(lblIteration)
                            .addComponent(lblStagnation))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(pbIteration, javax.swing.GroupLayout.DEFAULT_SIZE, 201, Short.MAX_VALUE)
                            .addComponent(pbStagnation, javax.swing.GroupLayout.DEFAULT_SIZE, 201, Short.MAX_VALUE)
                            .addComponent(lblSolutionValue, javax.swing.GroupLayout.PREFERRED_SIZE, 201, javax.swing.GroupLayout.PREFERRED_SIZE)))
                    .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                        .addComponent(btnStop)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 129, Short.MAX_VALUE)
                        .addComponent(btnOK)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(btnContinue)))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel1)
                    .addComponent(lblSolutionValue))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(lblIteration)
                    .addComponent(pbIteration, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(lblStagnation)
                    .addComponent(pbStagnation, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGap(18, 18, 18)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(btnContinue)
                    .addComponent(btnOK)
                    .addComponent(btnStop))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );*/

        Container contentPane = getContentPane();
        SpringLayout layout = new SpringLayout();
        contentPane.setLayout(layout);
        contentPane.add(jLabel1);
        contentPane.add(lblSolutionValue);
        contentPane.add(lblIteration);
        contentPane.add(pbIteration);
        contentPane.add(lblStagnation);
        contentPane.add(pbStagnation);
        contentPane.add(btnContinue);
        contentPane.add(btnOK);
        contentPane.add(btnStop);

        SpringUtilities.makeCompactGrid(contentPane, 3, 2, 10, 10, 10, 10);

        /*layout.putConstraint(SpringLayout.WEST, jLabel1, 5, SpringLayout.WEST, contentPane);
        layout.putConstraint(SpringLayout.NORTH, jLabel1, 5, SpringLayout.NORTH, contentPane);
        layout.putConstraint(SpringLayout.WEST, lblSolutionValue, 5, SpringLayout.EAST, jLabel1);
        layout.putConstraint(SpringLayout.NORTH, lblSolutionValue, 0, SpringLayout.NORTH, jLabel1);

        layout.putConstraint(SpringLayout.WEST, lblIteration, 0, SpringLayout.WEST, jLabel1);
        layout.putConstraint(SpringLayout.NORTH, lblIteration, 5, SpringLayout.SOUTH, jLabel1);
        layout.putConstraint(SpringLayout.WEST, pbIteration, 5, SpringLayout.EAST, lblIteration);
        layout.putConstraint(SpringLayout.NORTH, pbIteration, 0, SpringLayout.NORTH, lblIteration);

        layout.putConstraint(SpringLayout.WEST, lblStagnation, 0, SpringLayout.WEST, lblIteration);
        layout.putConstraint(SpringLayout.NORTH, lblStagnation, 5, SpringLayout.SOUTH, lblIteration);
        layout.putConstraint(SpringLayout.WEST, pbStagnation, 0, SpringLayout.EAST, lblStagnation);
        layout.putConstraint(SpringLayout.NORTH, pbStagnation, 0, SpringLayout.NORTH, lblStagnation);*/

        layout.putConstraint(SpringLayout.WEST, btnStop, 10, SpringLayout.WEST, contentPane);
        layout.putConstraint(SpringLayout.NORTH, btnStop, 10, SpringLayout.SOUTH, lblStagnation);

        layout.putConstraint(SpringLayout.SOUTH, contentPane, 10, SpringLayout.SOUTH, btnStop);
        layout.getConstraints(pbIteration).setWidth(Spring.constant(200));
        layout.getConstraints(pbStagnation).setWidth(Spring.constant(200));
        layout.putConstraint(SpringLayout.EAST, contentPane, 10, SpringLayout.EAST, pbStagnation);

        layout.putConstraint(SpringLayout.EAST, btnContinue, -10, SpringLayout.EAST, contentPane);
        layout.putConstraint(SpringLayout.NORTH, btnContinue, 0, SpringLayout.NORTH, btnStop);
        layout.putConstraint(SpringLayout.EAST, btnOK, -10, SpringLayout.WEST, btnContinue);
        layout.putConstraint(SpringLayout.NORTH, btnOK, 0, SpringLayout.NORTH, btnStop);

        pack();
        setResizable(false);
    }// </editor-fold>

    private void btnOKActionPerformed(java.awt.event.ActionEvent evt) {
        setUserState(OK);
    }

    private void btnContinueActionPerformed(java.awt.event.ActionEvent evt) {
        setUserState(CONTINUE);
    }

    private void btnStopActionPerformed(java.awt.event.ActionEvent evt) {
        setUserState(CANCEL);
    }

    /**
    * @param args the command line arguments
    */
    public static void main(String args[]) {
        java.awt.EventQueue.invokeLater(new Runnable() {
            public void run() {
                new EvolutionarySolverStatus().setVisible(true);
            }
        });
    }

    // Variables declaration - do not modify
    private javax.swing.JButton btnContinue;
    private javax.swing.JButton btnOK;
    private javax.swing.JButton btnStop;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel lblIteration;
    private javax.swing.JLabel lblSolutionValue;
    private javax.swing.JLabel lblStagnation;
    private javax.swing.JProgressBar pbIteration;
    private javax.swing.JProgressBar pbStagnation;
    // End of variables declaration

    public void setBestSolution(double solution, boolean feasible) {
        lblSolutionValue.setText(String.format("%.2f", solution));
        if (feasible)
            lblSolutionValue.setForeground(jLabel1.getForeground());
        else
            lblSolutionValue.setForeground(Color.RED);
    }

    public void setMaxIterations(int maxIterations) {
        pbIteration.setMaximum(maxIterations);
    }

    public void setMaxStagnation(int maxStagnation) {
        pbStagnation.setMaximum(maxStagnation);
    }

    public void setIteration(int iteration) {
        pbIteration.setValue(iteration);
        pbIteration.setString(String.format("%d/%d", iteration, pbIteration.getMaximum()));
    }

    public void setStagnation(int stagnation) {
        pbStagnation.setValue(stagnation);
    }

    public synchronized int waitForUser() {
        m_userState = WAITING;
        btnOK.setEnabled(true);
        btnContinue.setEnabled(true);
        btnStop.setEnabled(false);

        Color iterationColor = lblIteration.getForeground();
        Color stagnationColor = lblStagnation.getForeground();

        if (pbIteration.getValue() >= pbIteration.getMaximum()) {
            lblIteration.setForeground(Color.RED);
        }

        if (pbStagnation.getValue() >= pbStagnation.getMaximum()) {
            lblStagnation.setForeground(Color.RED);
        }

        try {
            while (m_userState == WAITING) {
              wait();
            }
        } catch (Exception e) {
            System.out.println(e);
        }

        btnOK.setEnabled(false);
        btnContinue.setEnabled(false);
        btnStop.setEnabled(true);

        lblIteration.setForeground(iterationColor);
        lblStagnation.setForeground(stagnationColor);

        return m_userState;
    }

}
