/*
 * Copyright (c) 2008-2016 Stefan Krah. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */


#ifndef VCCOMPAT_H
#define VCCOMPAT_H


/* Visual C fixes: no stdint.h, no snprintf ... */
#ifdef _MSC_VER
  #include "vcstdint.h"
  #undef inline
  #define inline __inline
  #undef random
  #define random rand
  #undef srandom
  #define srandom srand
  #undef snprintf
  #define snprintf sprintf_s
  #define HAVE_SNPRINTF
  #undef strncasecmp
  #define strncasecmp _strnicmp
  #undef strcasecmp
  #define strcasecmp _stricmp
  #undef strtoll
  #define strtoll _strtoi64
  #define strdup _strdup
  #define PRIi64 "I64i"
  #define PRIu64 "I64u"
  #define PRIi32 "I32i"
  #define PRIu32 "I32u"
#endif


#endif /* VCCOMPAT_H */



