//------------------------------------------------------------------------------
// <copyright file="TypedTableBase.cs" company="Microsoft">
//     Copyright (c) Microsoft Corporation.  All rights reserved.
// </copyright>
// <owner current="true" primary="true">[....]</owner>
// <owner current="true" primary="false">spather</owner>
//------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Collections;
using System.Linq;
using System.Linq.Expressions;
using System.Runtime.Serialization;

namespace System.Data {

    /// <summary>
    /// This is the generic base class for TypedDataSet
    /// </summary>
    [Serializable]
    public abstract class TypedTableBase<T> : DataTable, IEnumerable<T> where T : DataRow {

        /// <summary>
        ///   Default constructor for generic TypedTableBase.
        ///   Will be called by generated Typed DataSet classes and is not for public use.
        /// </summary>
        protected TypedTableBase() : base() {}

        /// <summary>
        ///   Constructor for the generic TypedTableBase with takes SerializationInfo and StreamingContext.
        ///   Will be called by generated Typed DataSet classes and
        ///   is not for public use.
        /// </summary>
        /// <param name="info">
        ///   SerializationInfo containing data to construct the object.
        /// </param>
        /// <param name="context">
        ///   The streaming context for the object being deserializad.
        /// </param>
        protected TypedTableBase(System.Runtime.Serialization.SerializationInfo info, System.Runtime.Serialization.StreamingContext context)
            : base(info, context) {}

        /// <summary>
        ///   This property returns a enumerator of T for the TypedTable.  Note, this could
        ///   execute the underlying Linq expression.
        /// </summary>
        /// <returns>
        ///   IEnumerable of T.
        /// </returns>
        public IEnumerator<T> GetEnumerator() {
            return this.Rows.Cast<T>().GetEnumerator();
        }

        IEnumerator IEnumerable.GetEnumerator() {
            return GetEnumerator();
        }


        /// <summary>
        /// Casts an EnumerableDataTable_TSource into EnumerableDataTable_TResult
        /// </summary>
        public EnumerableRowCollection<TResult> Cast<TResult>()
        {
            EnumerableRowCollection<T> erc = new EnumerableRowCollection<T>((DataTable)this);
            return erc.Cast<TResult>();
        }

    }
}
